/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Objects;
import org.boon.Universal;

public class Dbl {
    public static double[] grow(double[] array, int size) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] grow(double[] array) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] shrink(double[] array, int size) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static double[] compact(double[] array) {
        Objects.requireNonNull(array);
        int nullCount = 0;
        for (double ch : array) {
            if (ch != 0.0) continue;
            ++nullCount;
        }
        double[] newArray = new double[array.length - nullCount];
        int j = 0;
        for (double ch : array) {
            if (ch == 0.0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static double[] arrayOfDouble(int size) {
        return new double[size];
    }

    @Universal
    public static double[] array(double ... array) {
        Objects.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(double[] array) {
        return array.length;
    }

    @Universal
    public static double idx(double[] array, int index) {
        int i = Dbl.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(double[] array, int index, double value) {
        int i = Dbl.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static double[] slc(double[] array, int startIndex, int endIndex) {
        Objects.requireNonNull(array);
        int start = Dbl.calculateIndex(array, startIndex);
        int end = Dbl.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static double[] slc(double[] array, int startIndex) {
        Objects.requireNonNull(array);
        int start = Dbl.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static double[] slcEnd(double[] array, int endIndex) {
        int end;
        Objects.requireNonNull(array);
        int newLength = end = Dbl.calculateIndex(array, endIndex);
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(double value, double[] array) {
        for (double currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static double[] copy(double[] array) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static double[] add(double[] array, double v) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static double[] add(double[] array, double[] array2) {
        Objects.requireNonNull(array);
        double[] newArray = new double[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static double[] insert(double[] array, int idx, double v) {
        Objects.requireNonNull(array);
        if (idx >= array.length) {
            return Dbl.add(array, v);
        }
        int index = Dbl.calculateIndex(array, idx);
        double[] newArray = new double[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static double[] insert(double[] array, int fromIndex, double[] values) {
        Objects.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Dbl.add(array, values);
        }
        int index = Dbl.calculateIndex(array, fromIndex);
        double[] newArray = new double[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(double[] array, int originalIndex) {
        int length = array.length;
        Objects.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }
}

