/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import org.boon.HTTP;
import org.boon.IO;
import org.boon.json.JsonException;
import org.boon.json.ObjectMapperFactory;
import org.boon.json.implementation.JsonParserUsingCharacterSource;

public class JsonSlurper {
    public Object parseText(String text) {
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException("The JSON input text should neither be null nor empty.");
        }
        return ObjectMapperFactory.create().fromJson(text);
    }

    public Object parse(Reader reader) {
        return new JsonParserUsingCharacterSource().parse(reader);
    }

    public Object parse(File file) {
        return this.parseFile(file, null);
    }

    public Object parse(File file, String charset) {
        return this.parseFile(file, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parseFile(File file, String scharset) {
        Charset charset;
        Charset charset2 = charset = scharset == null || scharset.length() == 0 ? StandardCharsets.UTF_8 : Charset.forName(scharset);
        if (file.length() > 2000000L) {
            try (BufferedReader reader = Files.newBufferedReader(IO.path(file.toString()), charset);){
                Object object = this.parse(reader);
                return object;
            }
            catch (IOException ioe) {
                throw new JsonException("Unable to process file: " + file.getPath(), ioe);
            }
        }
        try {
            return ObjectMapperFactory.create().fromJson(Files.newBufferedReader(IO.path(file.toString()), charset));
        }
        catch (IOException e) {
            throw new JsonException("Unable to process file: " + file.getPath(), e);
        }
    }

    public Object parse(URL url) {
        return this.parseURL(url, null);
    }

    public Object parse(URL url, Map params) {
        return this.parseURL(url, params);
    }

    public Object parse(Map params, URL url) {
        return this.parseURL(url, params);
    }

    private Object parseURL(URL url, Map params) {
        return this.parse(new StringReader(IO.read(url.toString())));
    }

    public Object parse(URL url, String charset) {
        return this.parseURL(url, null, charset);
    }

    public Object parse(URL url, Map params, String charset) {
        return this.parseURL(url, params, charset);
    }

    public Object parse(Map params, URL url, String charset) {
        return this.parseURL(url, params, charset);
    }

    private Object parseURL(URL url, Map params, String charset) {
        return this.parse(new StringReader(HTTP.getJSONWithParams(url.toString(), null, params)));
    }
}

