/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di;

import java.util.HashMap;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.di.Module;

public class ObjectListModule
implements Module {
    Map<Class, Object> objects = new HashMap<Class, Object>();

    public ObjectListModule(Object ... objects) {
        for (Object object : objects) {
            Class<?>[] superTypes;
            Class<?> cls = object.getClass();
            this.objects.put(cls, object);
            Class<?> superClass = cls.getSuperclass();
            for (Class<?> superType : superTypes = cls.getInterfaces()) {
                this.objects.put(superType, object);
            }
            while (superClass != Object.class) {
                this.objects.put(superClass, object);
                for (Class<?> superType : superTypes = cls.getInterfaces()) {
                    this.objects.put(superType, object);
                }
                superClass = cls.getSuperclass();
            }
        }
    }

    @Override
    public <T> T get(Class<T> type) {
        try {
            return (T)this.objects.get(type);
        }
        catch (Exception e) {
            Exceptions.handle(e);
            return null;
        }
    }

    @Override
    public boolean has(Class type) {
        return this.objects.containsKey(type);
    }
}

