/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.fields.FieldAccess;

public abstract class BaseField
implements FieldAccess {
    private static final int PRIMITIVE = 0;
    private static final int FINAL = 1;
    private static final int STATIC = 2;
    private static final int VOLATILE = 3;
    private static final int QUALIFIED = 4;
    private static final int READ_ONLY = 5;
    private static final int INCLUDE = 6;
    private static final int IGNORE = 7;
    private static final int WRITE_ONLY = 8;
    protected final BitSet bits = new BitSet();
    protected final Class<?> type;
    protected final Class<?> parentType;
    protected final String name;
    protected final ParameterizedType parameterizedType;
    protected final Class<?> componentClass;
    protected final String typeName;
    public final Type typeEnum;
    private Map<String, Map<String, Object>> annotationMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private HashSet<String> includedViews;
    private HashSet<String> ignoreWithViews;
    private final String alias;

    private String initAnnotationData(Class clazz) {
        String[] props;
        Map<String, AnnotationData> classAnnotations;
        AnnotationData jsonIgnoreProperties;
        String include;
        Map<String, Object> jsonIgnore;
        Collection<AnnotationData> annotationDataForFieldAndProperty = Annotations.getAnnotationDataForFieldAndProperty(clazz, this.name, Collections.EMPTY_SET);
        for (AnnotationData data : annotationDataForFieldAndProperty) {
            this.annotationMap.put(data.getSimpleClassName(), data.getValues());
            this.annotationMap.put(data.getFullClassName(), data.getValues());
        }
        if (this.hasAnnotation("JsonViews")) {
            Map<String, Object> jsonViews = this.getAnnotationData("JsonViews");
            String[] includeWithViews = (String[])jsonViews.get("includeWithViews");
            String[] ignoreWithViews = (String[])jsonViews.get("ignoreWithViews");
            if (includeWithViews != null) {
                this.includedViews = new HashSet();
                for (String view : includeWithViews) {
                    this.includedViews.add(view);
                }
            }
            if (ignoreWithViews != null) {
                this.ignoreWithViews = new HashSet();
                for (String view : ignoreWithViews) {
                    this.ignoreWithViews.add(view);
                }
            }
        }
        if (this.hasAnnotation("JsonIgnore")) {
            jsonIgnore = this.getAnnotationData("JsonIgnore");
            boolean ignore = (Boolean)jsonIgnore.get("value");
            this.bits.set(7, ignore);
        }
        if (this.hasAnnotation("JsonInclude") && (include = (String)(jsonIgnore = this.getAnnotationData("JsonInclude")).get("value")).equals("ALWAYS")) {
            this.bits.set(6);
        }
        if (this.hasAnnotation("Expose")) {
            jsonIgnore = this.getAnnotationData("Expose");
            boolean serialize = (Boolean)jsonIgnore.get("serialize");
            this.bits.set(6, serialize);
            this.bits.set(7, !serialize);
        }
        String alias = null;
        if (this.hasAnnotation("SerializedName")) {
            Map<String, Object> aliasD = this.getAnnotationData("SerializedName");
            alias = (String)aliasD.get("value");
        }
        if (alias == null && this.hasAnnotation("JsonProperty")) {
            Map<String, Object> aliasD = this.getAnnotationData("JsonProperty");
            alias = (String)aliasD.get("value");
        }
        if (this.parentType != null && (jsonIgnoreProperties = (classAnnotations = Annotations.getAnnotationDataForClassAsMap(this.parentType)).get("JsonIgnoreProperties")) != null && (props = (String[])jsonIgnoreProperties.getValues().get("value")) != null) {
            for (String prop : props) {
                if (!prop.equals(this.name)) continue;
                this.bits.set(7, true);
                break;
            }
        }
        return alias;
    }

    protected BaseField(String name, Method getter, Method setter) {
        try {
            String alias;
            if (setter == null) {
                this.bits.set(5);
            } else if (getter == null) {
                this.bits.set(8);
                this.bits.set(7);
            }
            this.name = name.intern();
            this.bits.set(3, false);
            this.bits.set(4, false);
            if (getter != null) {
                java.lang.reflect.Type obj2;
                this.bits.set(2, Modifier.isStatic(getter.getModifiers()));
                this.bits.set(1, Modifier.isFinal(getter.getModifiers()));
                this.type = getter.getReturnType();
                this.parentType = getter.getDeclaringClass();
                this.bits.set(0, this.type.isPrimitive());
                this.typeName = this.type.getName().intern();
                java.lang.reflect.Type obj = getter.getGenericReturnType();
                this.parameterizedType = obj instanceof ParameterizedType ? (ParameterizedType)obj : null;
                this.componentClass = this.parameterizedType == null ? null : ((obj2 = this.parameterizedType.getActualTypeArguments()[0]) instanceof Class ? (Class)this.parameterizedType.getActualTypeArguments()[0] : null);
                alias = this.initAnnotationData(getter.getDeclaringClass());
            } else {
                this.bits.set(2, Modifier.isStatic(setter.getModifiers()));
                this.bits.set(1, Modifier.isFinal(setter.getModifiers()));
                this.type = setter.getParameterTypes()[0];
                this.bits.set(0, this.type.isPrimitive());
                this.typeName = this.type.getName().intern();
                this.parameterizedType = null;
                this.componentClass = null;
                this.parentType = setter.getDeclaringClass();
                alias = this.initAnnotationData(setter.getDeclaringClass());
            }
            this.typeEnum = name.startsWith("$") ? Type.SYSTEM : Type.getType(this.type);
            this.alias = alias != null ? alias : name;
        }
        catch (Exception ex) {
            Exceptions.handle("name " + name + " setter " + setter + " getter " + getter, (Throwable)ex);
            throw new RuntimeException("die");
        }
    }

    protected BaseField(Field field) {
        java.lang.reflect.Type obj;
        this.name = field.getName().intern();
        this.bits.set(2, Modifier.isStatic(field.getModifiers()));
        this.bits.set(1, Modifier.isFinal(field.getModifiers()));
        this.bits.set(3, Modifier.isVolatile(field.getModifiers()));
        this.bits.set(4, this.bits.get(1) || this.bits.get(3));
        this.bits.set(5, this.bits.get(1));
        this.bits.set(7, Modifier.isTransient(field.getModifiers()));
        this.parentType = field.getDeclaringClass();
        this.type = field.getType();
        this.typeName = this.type.getName().intern();
        this.bits.set(0, this.type.isPrimitive());
        this.parameterizedType = field != null ? ((obj = field.getGenericType()) instanceof ParameterizedType ? (ParameterizedType)obj : null) : null;
        this.componentClass = this.parameterizedType == null ? null : ((obj = this.parameterizedType.getActualTypeArguments()[0]) instanceof Class ? (Class)this.parameterizedType.getActualTypeArguments()[0] : null);
        this.typeEnum = this.name.startsWith("$") ? Type.SYSTEM : Type.getType(this.type);
        String alias = this.initAnnotationData(field.getDeclaringClass());
        this.alias = alias != null ? alias : this.name;
    }

    @Override
    public final Object getValue(Object obj) {
        switch (this.typeEnum) {
            case INT: {
                return this.getInt(obj);
            }
            case LONG: {
                return this.getLong(obj);
            }
            case BOOLEAN: {
                return this.getBoolean(obj);
            }
            case BYTE: {
                return this.getByte(obj);
            }
            case SHORT: {
                return this.getShort(obj);
            }
            case CHAR: {
                return Character.valueOf(this.getChar(obj));
            }
            case DOUBLE: {
                return this.getDouble(obj);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(obj));
            }
        }
        return this.getObject(obj);
    }

    @Override
    public final void setValue(Object obj, Object value) {
        switch (this.typeEnum) {
            case INT: {
                this.setInt(obj, Conversions.toInt(value));
                return;
            }
            case LONG: {
                this.setLong(obj, Conversions.toLong(value));
                return;
            }
            case BOOLEAN: {
                this.setBoolean(obj, Conversions.toBoolean(value));
                return;
            }
            case BYTE: {
                this.setByte(obj, Conversions.toByte(value));
                return;
            }
            case SHORT: {
                this.setShort(obj, Conversions.toShort(value));
                return;
            }
            case CHAR: {
                this.setChar(obj, Conversions.toChar(value));
                return;
            }
            case DOUBLE: {
                this.setDouble(obj, Conversions.toDouble(value));
                return;
            }
            case FLOAT: {
                this.setFloat(obj, Conversions.toFloat(value));
                return;
            }
            case DATE: {
                this.setObject(obj, Conversions.toDate(value));
                return;
            }
            case STRING: {
                if (value instanceof String) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toString(value));
                }
                return;
            }
            case ENUM: {
                if (value.getClass() == this.type) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toEnum(this.type, value));
                }
                return;
            }
            case BIG_DECIMAL: {
                if (value instanceof BigDecimal) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toBigDecimal(value));
                }
                return;
            }
            case BIG_INT: {
                if (value instanceof BigInteger) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toBigInteger(value));
                }
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                this.setObject(obj, Conversions.toCollection(this.type, value));
                return;
            }
        }
        if (value != null) {
            if (value.getClass() == this.type) {
                this.setObject(obj, value);
            } else if (Typ.implementsInterface(value.getClass(), this.type)) {
                this.setObject(obj, value);
            } else {
                this.setObject(obj, Conversions.coerce(this.typeEnum, this.type, value));
            }
        } else {
            this.setObject(obj, null);
        }
    }

    @Override
    public final void setFromValue(Object obj, Value value) {
        switch (this.typeEnum) {
            case INT: {
                this.setInt(obj, value.intValue());
                return;
            }
            case LONG: {
                this.setLong(obj, value.longValue());
                return;
            }
            case BOOLEAN: {
                this.setBoolean(obj, value.booleanValue());
                return;
            }
            case BYTE: {
                this.setByte(obj, value.byteValue());
                return;
            }
            case SHORT: {
                this.setShort(obj, value.shortValue());
                return;
            }
            case CHAR: {
                this.setChar(obj, value.charValue());
                return;
            }
            case DOUBLE: {
                this.setDouble(obj, value.doubleValue());
                return;
            }
            case FLOAT: {
                this.setFloat(obj, value.floatValue());
                return;
            }
            case INTEGER_WRAPPER: {
                this.setObject(obj, value.intValue());
                return;
            }
            case LONG_WRAPPER: {
                this.setObject(obj, value.longValue());
                return;
            }
            case BOOLEAN_WRAPPER: {
                this.setObject(obj, value.booleanValue());
                return;
            }
            case BYTE_WRAPPER: {
                this.setObject(obj, value.byteValue());
                return;
            }
            case SHORT_WRAPPER: {
                this.setObject(obj, value.shortValue());
                return;
            }
            case CHAR_WRAPPER: {
                this.setObject(obj, Character.valueOf(value.charValue()));
                return;
            }
            case DOUBLE_WRAPPER: {
                this.setObject(obj, value.doubleValue());
                return;
            }
            case FLOAT_WRAPPER: {
                this.setObject(obj, Float.valueOf(value.floatValue()));
                return;
            }
            case STRING: 
            case CHAR_SEQUENCE: {
                this.setObject(obj, value.stringValue());
                return;
            }
            case BIG_DECIMAL: {
                this.setObject(obj, value.bigDecimalValue());
                return;
            }
            case BIG_INT: {
                this.setObject(obj, value.bigIntegerValue());
                return;
            }
            case DATE: {
                this.setObject(obj, value.dateValue());
                return;
            }
            case ENUM: {
                this.setObject(obj, value.toEnum(this.type));
                return;
            }
        }
        this.setObject(obj, Conversions.coerce(this.typeEnum, this.type, value.toValue()));
    }

    @Override
    public final ParameterizedType getParameterizedType() {
        return this.parameterizedType;
    }

    @Override
    public final Class<?> getComponentClass() {
        return this.componentClass;
    }

    protected void analyzeError(Exception e, Object obj) {
        Exceptions.handle(Str.lines(e.getClass().getName(), String.format("cause %s", e.getCause()), String.format("Field info name %s, type %s, class that declared field %s", this.getName(), this.getType(), this.getField().getDeclaringClass()), String.format("Type of object passed %s", obj.getClass().getName())), (Throwable)e);
    }

    @Override
    public final boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public final Map<String, Object> getAnnotationData(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    @Override
    public final boolean isPrimitive() {
        return this.bits.get(0);
    }

    @Override
    public final Type typeEnum() {
        return this.typeEnum;
    }

    @Override
    public final boolean isFinal() {
        return this.bits.get(1);
    }

    @Override
    public final boolean isStatic() {
        return this.bits.get(2);
    }

    @Override
    public final boolean isVolatile() {
        return this.bits.get(3);
    }

    @Override
    public final boolean isQualified() {
        return this.bits.get(4);
    }

    @Override
    public final boolean isReadOnly() {
        return this.bits.get(5);
    }

    @Override
    public boolean isWriteOnly() {
        return this.bits.get(8);
    }

    @Override
    public final Class<?> getType() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    public String toString() {
        return "BaseField [name=" + this.name + ", type=" + this.type + "]";
    }

    @Override
    public final boolean isViewActive(String activeView) {
        if (this.includedViews == null && this.ignoreWithViews == null) {
            return true;
        }
        if (this.includedViews != null) {
            return this.includedViews.contains(activeView);
        }
        if (this.ignoreWithViews != null) {
            return !this.ignoreWithViews.contains(activeView);
        }
        return true;
    }

    @Override
    public final boolean include() {
        return this.bits.get(6);
    }

    @Override
    public final boolean ignore() {
        return this.bits.get(7);
    }
}

