/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import org.boon.core.Typ;

public enum Type {
    INT,
    SHORT,
    BYTE,
    LONG,
    CHAR,
    BOOLEAN,
    COLLECTION,
    ARRAY,
    FLOAT,
    INSTANCE,
    BIG_INT,
    BIG_DECIMAL,
    DATE,
    NUMBER,
    LONG_WRAPPER,
    INTEGER_WRAPPER,
    SHORT_WRAPPER,
    CHAR_WRAPPER,
    BOOLEAN_WRAPPER,
    BYTE_WRAPPER,
    FLOAT_WRAPPER,
    DOUBLE_WRAPPER,
    INTEGER,
    STRING,
    DOUBLE,
    TRUE,
    FALSE,
    NULL,
    MAP,
    LIST,
    SET,
    CHAR_SEQUENCE,
    INTERFACE,
    ABSTRACT,
    OBJECT,
    SYSTEM,
    ENUM,
    CALENDAR,
    VALUE_MAP,
    VALUE;


    public static Type getInstanceType(Object object) {
        if (object == null) {
            return NULL;
        }
        return Type.getType(object.getClass());
    }

    public static Type getType(Class<?> clazz) {
        String className = clazz.getName();
        Type type = Type.getType(className);
        if (type != INSTANCE) {
            return type;
        }
        if (className.startsWith("java")) {
            type = Typ.isCharSequence(clazz) ? CHAR_SEQUENCE : (Typ.isCollection(clazz) ? (Typ.isList(clazz) ? LIST : (Typ.isSet(clazz) ? SET : COLLECTION)) : (Typ.isMap(clazz) ? MAP : SYSTEM));
        } else if (clazz.isInterface()) {
            type = INTERFACE;
        } else if (clazz.isEnum()) {
            type = ENUM;
        } else if (clazz.isArray()) {
            type = ARRAY;
        } else if (Typ.isAbstract(clazz)) {
            type = ABSTRACT;
        }
        return type;
    }

    public static Type getType(String typeName) {
        switch (typeName) {
            case "int": {
                return INT;
            }
            case "short": {
                return SHORT;
            }
            case "byte": {
                return BYTE;
            }
            case "float": {
                return FLOAT;
            }
            case "double": {
                return DOUBLE;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "char": {
                return CHAR;
            }
            case "long": {
                return LONG;
            }
            case "java.lang.String": {
                return STRING;
            }
            case "java.lang.Boolean": {
                return BOOLEAN_WRAPPER;
            }
            case "java.lang.Byte": {
                return BYTE_WRAPPER;
            }
            case "java.lang.Short": {
                return SHORT_WRAPPER;
            }
            case "java.lang.Integer": {
                return INTEGER_WRAPPER;
            }
            case "java.lang.Double": {
                return DOUBLE_WRAPPER;
            }
            case "java.lang.Float": {
                return FLOAT_WRAPPER;
            }
            case "java.lang.Character": {
                return CHAR_WRAPPER;
            }
            case "java.lang.Long": {
                return LONG_WRAPPER;
            }
            case "java.util.Set": 
            case "java.util.HashSet": 
            case "java.util.TreeSet": {
                return SET;
            }
            case "java.util.List": 
            case "java.util.ArrayList": 
            case "java.util.LinkedList": {
                return LIST;
            }
            case "java.util.Map": 
            case "org.boon.core.LazyMap": 
            case "java.util.HashMap": 
            case "java.util.LinkedHashMap": 
            case "java.util.TreeMap": 
            case "org.boon.core.value.LazyValueMap": {
                return MAP;
            }
            case "java.lang.CharSequence": {
                return CHAR_SEQUENCE;
            }
            case "java.math.BigDecimal": {
                return BIG_DECIMAL;
            }
            case "java.math.BigInteger": {
                return BIG_INT;
            }
            case "java.util.Date": 
            case "java.sql.Date": 
            case "java.sql.Time": 
            case "java.sql.Timestamp": {
                return DATE;
            }
            case "java.util.Calendar": {
                return CALENDAR;
            }
            case "org.boon.core.value.ValueMapImpl": {
                return VALUE_MAP;
            }
            case "org.boon.core.value.NumberValue": 
            case "org.boon.core.value.CharSequenceValue": {
                return VALUE;
            }
        }
        return INSTANCE;
    }

    public static boolean hasLength(Type type) {
        switch (type) {
            case LIST: 
            case MAP: 
            case STRING: 
            case CHAR_SEQUENCE: 
            case SET: 
            case COLLECTION: 
            case ARRAY: {
                return true;
            }
        }
        return false;
    }
}

