/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SortableConcurrentList<T extends Comparable>
implements List<T> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final List<T> list;

    public SortableConcurrentList(List<T> list) {
        this.list = list;
    }

    public SortableConcurrentList() {
        this.list = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.remove(o);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.list.addAll(index, c);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        boolean ret;
        this.readWriteLock.writeLock().lock();
        try {
            ret = this.list.add(t);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.readWriteLock.writeLock().lock();
        try {
            this.list.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        this.readWriteLock.readLock().lock();
        try {
            Iterator<T> iterator = new ArrayList<T>(this.list).iterator();
            return iterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.readWriteLock.readLock().lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.readWriteLock.readLock().lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        this.readWriteLock.readLock().lock();
        try {
            Comparable comparable = (Comparable)this.list.get(index);
            return (T)comparable;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        this.readWriteLock.writeLock().lock();
        try {
            Comparable comparable = (Comparable)this.list.set(index, element);
            return (T)comparable;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        this.readWriteLock.writeLock().lock();
        try {
            this.list.add(index, element);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        this.readWriteLock.writeLock().lock();
        try {
            Comparable comparable = (Comparable)this.list.remove(index);
            return (T)comparable;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        this.readWriteLock.readLock().lock();
        try {
            ListIterator<T> listIterator = new ArrayList<T>(this.list).listIterator();
            return listIterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        this.readWriteLock.readLock().lock();
        try {
            ListIterator<T> listIterator = new ArrayList<T>(this.list).listIterator(index);
            return listIterator;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.readWriteLock.readLock().lock();
        try {
            List<T> list = this.list.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readWriteLock.readLock().lock();
        try {
            String string = this.list.toString();
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        this.readWriteLock.writeLock().lock();
        try {
            Collections.sort(this.list);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> sortAndReturnPurgeList(float removePercent) {
        this.readWriteLock.writeLock().lock();
        try {
            int size = this.list.size();
            int removeSize = (int)((float)size - (float)size * removePercent);
            int start = size - removeSize;
            Collections.sort(this.list);
            ArrayList<T> removeList = new ArrayList<T>(this.list.subList(0, start));
            this.list.removeAll(removeList);
            ArrayList<T> arrayList = removeList;
            return arrayList;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

