/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.boon.Universal;
import org.boon.core.Function;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Reflection;

public class Lists {
    public static <V> List<V> list(Class<V> clazz) {
        return new ArrayList();
    }

    public static <V> List<V> list(Iterable<V> iterable) {
        ArrayList<V> list = new ArrayList<V>();
        for (V o : iterable) {
            list.add(o);
        }
        return list;
    }

    public static List<?> toList(Object item) {
        if (item == null) {
            return new ArrayList();
        }
        if (item.getClass().isArray()) {
            int length = Array.getLength(item);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int index = 0; index < length; ++index) {
                list.add(Array.get(item, index));
            }
            return list;
        }
        if (item instanceof Collection) {
            return Lists.list((Collection)item);
        }
        if (item instanceof Iterator) {
            return Lists.list((Iterator)item);
        }
        if (item instanceof Enumeration) {
            return Lists.list((Enumeration)item);
        }
        if (item instanceof Iterable) {
            return Lists.list((Iterable)item);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(item);
        return list;
    }

    public static <V> List<V> list(Collection<V> collection) {
        return new ArrayList<V>(collection);
    }

    public static <V, WRAP> List<WRAP> wrap(Class<WRAP> wrapper, Collection<V> collection) {
        ArrayList<WRAP> list = new ArrayList<WRAP>(collection.size());
        for (V v : collection) {
            WRAP wrap = Reflection.newInstance(wrapper, v);
            list.add(wrap);
        }
        return list;
    }

    public static <V> List<V> list(Enumeration<V> enumeration) {
        ArrayList<V> list = new ArrayList<V>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <V> Enumeration<V> enumeration(List<V> list) {
        final Iterator<V> iter = list.iterator();
        return new Enumeration<V>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public V nextElement() {
                return iter.next();
            }
        };
    }

    public static <V> List<V> list(Iterator<V> iterator) {
        ArrayList<V> list = new ArrayList<V>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <V, N> List<N> list(Function<V, N> function, V ... array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList<N> list = new ArrayList<N>(array.length);
        for (V v : array) {
            list.add(function.apply(v));
        }
        return list;
    }

    @SafeVarargs
    public static <V> List<V> list(V ... array) {
        if (array == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    @SafeVarargs
    public static <V> List<V> safeList(V ... array) {
        return new CopyOnWriteArrayList<V>(array);
    }

    @SafeVarargs
    public static <V> List<V> linkedList(V ... array) {
        if (array == null) {
            return new ArrayList();
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list;
    }

    public static <V> List<V> safeList(Collection<V> collection) {
        return new CopyOnWriteArrayList<V>(collection);
    }

    public static <V> List<V> linkedList(Collection<V> collection) {
        return new LinkedList<V>(collection);
    }

    @Universal
    public static int len(List<?> list) {
        return list.size();
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    @Universal
    public static <V> boolean in(V value, List<?> list) {
        return list.contains(value);
    }

    @Universal
    public static <V> void add(List<V> list, V value) {
        list.add(value);
    }

    @Universal
    public static <T> T idx(List<T> list, int index) {
        int i = Lists.calculateIndex(list, index);
        if (i > list.size() - 1) {
            i = list.size() - 1;
        }
        return list.get(i);
    }

    @Universal
    public static <V> void idx(List<V> list, int index, V v) {
        int i = Lists.calculateIndex(list, index);
        list.set(i, v);
    }

    @Universal
    public static <V> List<V> slc(List<V> list, int startIndex, int endIndex) {
        int start = Lists.calculateIndex(list, startIndex);
        int end = Lists.calculateIndex(list, endIndex);
        return list.subList(start, end);
    }

    @Universal
    public static <V> List<V> slc(List<V> list, int startIndex) {
        return Lists.slc(list, startIndex, list.size());
    }

    @Universal
    public static <V> List<V> slcEnd(List<V> list, int endIndex) {
        return Lists.slc(list, 0, endIndex);
    }

    @Universal
    public static <V> List<V> copy(List<V> list) {
        if (list instanceof LinkedList) {
            return new LinkedList<V>(list);
        }
        if (list instanceof CopyOnWriteArrayList) {
            return new CopyOnWriteArrayList<V>(list);
        }
        return new ArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(CopyOnWriteArrayList<V> list) {
        Objects.requireNonNull(list, "listStream cannot be null");
        return new CopyOnWriteArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(ArrayList<V> list) {
        Objects.requireNonNull(list, "listStream cannot be null");
        return new ArrayList<V>(list);
    }

    @Universal
    public static <V> List<V> copy(LinkedList<V> list) {
        Objects.requireNonNull(list, "listStream cannot be null");
        return new LinkedList<V>(list);
    }

    @Universal
    public static <V> void insert(List<V> list, int index, V v) {
        int i = Lists.calculateIndex(list, index);
        list.add(i, v);
    }

    private static <T> int calculateIndex(List<T> list, int originalIndex) {
        int length = list.size();
        Objects.requireNonNull(list, "listStream cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static <T> List<T> listFromProperty(Class<T> propertyType, String propertyPath, Collection<?> list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object item : list) {
            Object newItem = BeanUtils.idx(item, propertyPath);
            newList.add(newItem);
        }
        return newList;
    }

    public static List<Map<String, Object>> toListOfMaps(List<?> list) {
        return Reflection.toListOfMaps(list);
    }
}

