/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.io.IOException;
import java.io.Reader;
import org.boon.Boon;

public class IOReader
extends Reader {
    private static int defaultBufferSize = 100000;
    private char[] buffer;
    private Reader reader;
    private int length;
    private int position;

    public IOReader(int size) {
        this.reader = this.reader;
        this.buffer = new char[size];
    }

    public IOReader() {
        this.reader = this.reader;
        this.buffer = new char[defaultBufferSize];
    }

    public static IOReader reader(IOReader reader, int size) {
        if (reader == null) {
            return new IOReader(size);
        }
        return reader;
    }

    public IOReader reader(Reader in) {
        try {
            this.close();
        }
        catch (IOException e) {
            Boon.logger("IO").warn((Object)e.getMessage(), e);
        }
        this.reader = in;
        return this;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.length) {
            int countRead;
            this.position = 0;
            this.length = countRead = this.reader.read(this.buffer);
            if (this.length == -1) {
                return -1;
            }
        }
        char value = this.buffer[this.position];
        ++this.position;
        return value & 0xFF;
    }

    @Override
    public int read(char[] destination, int destinationOffset, int destinationLength) throws IOException {
        int countRead;
        if (this.reader == null) {
            throw new IOException("Stream is closed");
        }
        int available = this.length - this.position;
        if (available >= destinationLength) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, destinationLength);
            this.position += destinationLength;
            return destinationLength;
        }
        if (available > 0) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, available);
            destinationLength -= available;
            destinationOffset += available;
        }
        this.position = 0;
        this.length = countRead = this.reader.read(this.buffer);
        if (this.length == -1) {
            return available == 0 ? -1 : available;
        }
        int amountToRead = destinationLength < this.length ? destinationLength : this.length;
        System.arraycopy(this.buffer, this.position, destination, destinationOffset, amountToRead);
        this.position = amountToRead;
        destinationOffset += amountToRead;
        if ((destinationLength -= amountToRead) == 0) {
            return amountToRead + available;
        }
        countRead = this.read(destination, destinationOffset, destinationLength);
        if (countRead == -1) {
            return amountToRead + available;
        }
        return amountToRead + available + countRead;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
        this.position = 0;
        this.length = 0;
    }
}

