/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.io.IOException;
import java.io.InputStream;
import org.boon.Boon;

public final class IOInputStream
extends InputStream {
    private static int defaultBufferSize = 100000;
    private byte[] buffer;
    private InputStream inputStream;
    private int length;
    private int position;

    public IOInputStream() {
        this.buffer = new byte[defaultBufferSize];
    }

    public IOInputStream(int size) {
        this.buffer = new byte[size];
    }

    public IOInputStream(int size, boolean autoGrowToMatch) {
        this.buffer = new byte[size];
    }

    public static IOInputStream input(IOInputStream input) {
        if (input == null) {
            return new IOInputStream();
        }
        return input;
    }

    public static IOInputStream input(IOInputStream input, int size) {
        if (input == null) {
            return new IOInputStream(size);
        }
        return input;
    }

    public static IOInputStream auto(IOInputStream input, int size) {
        if (input == null) {
            return new IOInputStream(size, true);
        }
        return input;
    }

    public IOInputStream input(InputStream in) {
        try {
            this.close();
        }
        catch (IOException e) {
            Boon.logger("IO").warn((Object)e.getMessage(), e);
        }
        this.inputStream = in;
        return this;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.length) {
            int countRead;
            this.position = 0;
            this.length = countRead = this.inputStream.read(this.buffer);
            if (this.length == -1) {
                return -1;
            }
        }
        byte value = this.buffer[this.position];
        ++this.position;
        return value & 0xFF;
    }

    @Override
    public int read(byte[] destination, int destinationOffset, int destinationLength) throws IOException {
        int countRead;
        if (this.inputStream == null) {
            throw new IOException("Stream is closed");
        }
        int available = this.length - this.position;
        if (available >= destinationLength) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, destinationLength);
            this.position += destinationLength;
            return destinationLength;
        }
        if (available > 0) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, available);
            destinationLength -= available;
            destinationOffset += available;
        }
        this.position = 0;
        this.length = countRead = this.inputStream.read(this.buffer);
        if (this.length == -1) {
            return available == 0 ? -1 : available;
        }
        int amountToRead = destinationLength < this.length ? destinationLength : this.length;
        System.arraycopy(this.buffer, this.position, destination, destinationOffset, amountToRead);
        this.position = amountToRead;
        destinationOffset += amountToRead;
        if ((destinationLength -= amountToRead) == 0) {
            return amountToRead + available;
        }
        countRead = this.read(destination, destinationOffset, destinationLength);
        if (countRead == -1) {
            return amountToRead + available;
        }
        return amountToRead + available + countRead;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip not supported");
    }

    @Override
    public int available() throws IOException {
        int totalCount = this.length - this.position;
        int available = this.inputStream.available();
        return totalCount > Integer.MAX_VALUE - available ? Integer.MAX_VALUE : totalCount + available;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Resetting not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = null;
        this.position = 0;
        this.length = 0;
    }
}

