/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Arrays;
import org.boon.Exceptions;
import org.boon.primitive.Byt;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;
import org.boon.primitive.Chr;

public class ByteScanner {
    static final String MIN_INT_STR_NO_SIGN = String.valueOf(Integer.MIN_VALUE).substring(1);
    static final String MAX_INT_STR = String.valueOf(Integer.MAX_VALUE);
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final long L_BILLION = 1000000000L;
    private static double[] powersOf10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18};

    public static boolean isDigits(char[] inputArray) {
        for (int index = 0; index < inputArray.length; ++index) {
            char a = inputArray[index];
            if (CharScanner.isDigit(a)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDecimalChar(byte[] chars, boolean negative) {
        int index = 0;
        if (negative) {
            ++index;
        }
        while (index < chars.length) {
            switch (chars[index]) {
                case 43: 
                case 45: 
                case 46: 
                case 69: 
                case 101: {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    public static byte[][] splitExact(byte[] inputArray, int split, int resultsArrayLength) {
        int actualLength;
        Object results = new byte[resultsArrayLength][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            if (c == split) {
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
            }
            ++index;
            ++currentLineLength;
        }
        if (c != split) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < resultsArrayLength) {
            int newSize = resultsArrayLength - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitExact(byte[] inputArray, int resultsArrayLength, int ... delims) {
        int actualLength;
        Object results = new byte[resultsArrayLength][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            for (int j = 0; j < delims.length; ++j) {
                int split = delims[j];
                if (c != split) continue;
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
                break;
            }
            ++index;
            ++currentLineLength;
        }
        if (!Byt.inIntArray((byte)c, delims)) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < resultsArrayLength) {
            int newSize = resultsArrayLength - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] split(byte[] inputArray, int split) {
        int actualLength;
        Object results = new byte[16][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        int c = 0;
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            if (c == split) {
                if (resultIndex == ((byte[][])results).length) {
                    results = ByteScanner._grow(results);
                }
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
            }
            ++index;
            ++currentLineLength;
        }
        if (c != split) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < ((byte[][])results).length) {
            int newSize = ((byte[][])results).length - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitByChars(byte[] inputArray, char ... delims) {
        int actualLength;
        Object results = new byte[16][];
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        char c = '\u0000';
        int index = 0;
        while (index < inputArray.length) {
            c = inputArray[index];
            for (int j = 0; j < delims.length; ++j) {
                char split = delims[j];
                if (c != split) continue;
                if (resultIndex == ((byte[][])results).length) {
                    results = ByteScanner._grow(results);
                }
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
                break;
            }
            ++index;
            ++currentLineLength;
        }
        if (!Chr.in((int)c, delims)) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < ((byte[][])results).length) {
            int newSize = ((byte[][])results).length - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitByCharsFromToDelims(byte[] inputArray, int from, int to, byte ... delims) {
        int actualLength;
        Object results = new byte[16][];
        int length = to - from;
        int resultIndex = 0;
        int startCurrentLineIndex = 0;
        int currentLineLength = 1;
        byte c = 0;
        int index = from;
        while (index < length) {
            c = inputArray[index];
            for (int j = 0; j < delims.length; ++j) {
                byte split = delims[j];
                if (c != split) continue;
                if (resultIndex == ((byte[][])results).length) {
                    results = ByteScanner._grow(results);
                }
                results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
                startCurrentLineIndex = index + 1;
                currentLineLength = 0;
                ++resultIndex;
                break;
            }
            ++index;
            ++currentLineLength;
        }
        if (!Byt.in((int)c, delims)) {
            results[resultIndex] = Byt.copy(inputArray, startCurrentLineIndex, currentLineLength - 1);
            ++resultIndex;
        }
        if ((actualLength = resultIndex) < ((byte[][])results).length) {
            int newSize = ((byte[][])results).length - actualLength;
            results = ByteScanner.__shrink(results, newSize);
        }
        return results;
    }

    public static byte[][] splitByCharsNoneEmpty(byte[] inputArray, char ... delims) {
        byte[][] results = ByteScanner.splitByChars(inputArray, delims);
        return ByteScanner.compact(results);
    }

    public static byte[][] splitByCharsNoneEmpty(byte[] inputArray, int from, int to, byte ... delims) {
        byte[][] results = ByteScanner.splitByCharsFromToDelims(inputArray, from, to, delims);
        return ByteScanner.compact(results);
    }

    public static byte[][] compact(byte[][] array) {
        int nullCount = 0;
        for (byte[] ch : array) {
            if (ch != null && ch.length != 0) continue;
            ++nullCount;
        }
        byte[][] newArray = new byte[array.length - nullCount][];
        int j = 0;
        for (byte[] ch : array) {
            if (ch == null || ch.length == 0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    private static byte[][] _grow(byte[][] array) {
        Exceptions.requireNonNull(array);
        byte[][] newArray = new byte[array.length * 2][];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private static byte[][] __shrink(byte[][] array, int size) {
        Exceptions.requireNonNull(array);
        byte[][] newArray = new byte[array.length - size][];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static boolean isInteger(byte[] digitChars, int offset, int len) {
        String cmpStr = digitChars[offset] == 45 ? MIN_INT_STR_NO_SIGN : MAX_INT_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static boolean isLong(byte[] digitChars, int offset, int len) {
        String cmpStr = digitChars[offset] == 45 ? MIN_INT_STR_NO_SIGN : MAX_INT_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static int parseInt(byte[] digitChars) {
        return ByteScanner.parseIntFromTo(digitChars, 0, digitChars.length);
    }

    public static int parseIntFromTo(byte[] digitChars, int offset, int to) {
        try {
            int num;
            boolean negative = false;
            byte c = digitChars[offset];
            if (c == 45) {
                ++offset;
                negative = true;
            }
            if (negative) {
                num = digitChars[offset] - 48;
                if (++offset < to) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < to) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < to) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < to) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < to) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < to) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                        if (++offset < to) {
                                            num = num * 10 + (digitChars[offset] - 48);
                                            if (++offset < to) {
                                                num = num * 10 + (digitChars[offset] - 48);
                                                if (++offset < to) {
                                                    num = num * 10 + (digitChars[offset] - 48);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                num = digitChars[offset] - 48;
                if (++offset < to) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < to) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < to) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < to) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < to) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < to) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                        if (++offset < to) {
                                            num = num * 10 + (digitChars[offset] - 48);
                                            if (++offset < to) {
                                                num = num * 10 + (digitChars[offset] - 48);
                                                if (++offset < to) {
                                                    num = num * 10 + (digitChars[offset] - 48);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return negative ? num * -1 : num;
        }
        catch (Exception ex) {
            return Exceptions.handle(Integer.TYPE, ex);
        }
    }

    public static int parseIntIgnoreDot(byte[] digitChars, int offset, int len) {
        int to;
        int num = digitChars[offset] - 48;
        if (++offset < (to = len + offset)) {
            int n = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
            if (++offset < to) {
                int n2 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                if (++offset < to) {
                    int n3 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                    if (++offset < to) {
                        int n4 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                        if (++offset < to) {
                            int n5 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                            if (++offset < to) {
                                int n6 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                if (++offset < to) {
                                    int n7 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                    if (++offset < to) {
                                        int n8 = num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                        if (++offset < to) {
                                            num = digitChars[offset] != 46 ? num * 10 + (digitChars[offset] - 48) : num;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static long parseLong(byte[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)ByteScanner.parseIntFromTo(digitChars, offset, len1) * 1000000000L;
        return val + (long)ByteScanner.parseIntFromTo(digitChars, offset + len1, 9);
    }

    public static long parseLongIgnoreDot(byte[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = (long)ByteScanner.parseIntIgnoreDot(digitChars, offset, len1) * 1000000000L;
        return val + (long)ByteScanner.parseIntIgnoreDot(digitChars, offset + len1, 9);
    }

    public static Number parseJsonNumber(byte[] buffer) {
        return ByteScanner.parseJsonNumber(buffer, 0, buffer.length);
    }

    public static Number parseJsonNumber(byte[] buffer, int from, int to) {
        return ByteScanner.parseJsonNumber(buffer, from, to, null);
    }

    public static Number parseJsonNumber(byte[] buffer, int from, int max, int[] size) {
        Number value = null;
        boolean simple = true;
        int digitsPastPoint = 0;
        int index = from;
        if (buffer[index] == 45) {
            ++index;
        }
        boolean foundDot = false;
        while (index < max) {
            byte ch = buffer[index];
            if (CharScanner.isNumberDigit(ch)) {
                if (foundDot) {
                    ++digitsPastPoint;
                }
            } else {
                if (ch <= 32 || CharScanner.isDelimiter(ch)) break;
                if (ch == 46) {
                    foundDot = true;
                } else if (ch == 69 || ch == 101 || ch == 45 || ch == 43) {
                    simple = false;
                } else {
                    Exceptions.die("unexpected character " + ch);
                }
            }
            ++index;
        }
        if (digitsPastPoint >= powersOf10.length - 1) {
            simple = false;
        }
        int length = index - from;
        if (!foundDot && simple) {
            value = ByteScanner.isInteger(buffer, from, length) ? (Number)ByteScanner.parseIntFromTo(buffer, from, index) : (Number)ByteScanner.parseLongFromTo(buffer, from, index);
        } else if (foundDot && simple) {
            if (length < powersOf10.length) {
                long lvalue = ByteScanner.isInteger(buffer, from, length) ? (long)ByteScanner.parseIntFromToIgnoreDot(buffer, from, index) : ByteScanner.parseLongFromToIgnoreDot(buffer, from, index);
                double power = powersOf10[digitsPastPoint];
                value = (double)lvalue / power;
            } else {
                value = Double.parseDouble(new String(buffer, from, length));
            }
        } else {
            value = Double.parseDouble(new String(buffer, from, index - from));
        }
        if (size != null) {
            size[0] = index;
        }
        return value;
    }

    public static long parseLongFromTo(byte[] digitChars, int offset, int to) {
        boolean negative = false;
        byte c = digitChars[offset];
        if (c == 45) {
            ++offset;
            negative = true;
        }
        c = digitChars[offset];
        long num = c - 48;
        ++offset;
        while (offset < to) {
            c = digitChars[offset];
            long digit = c - 48;
            num = num * 10L + digit;
            ++offset;
        }
        return negative ? num * -1L : num;
    }

    public static int parseIntFromToIgnoreDot(byte[] digitChars, int offset, int to) {
        boolean negative = false;
        byte c = digitChars[offset];
        if (c == 45) {
            ++offset;
            negative = true;
        }
        c = digitChars[offset];
        int num = c - 48;
        ++offset;
        while (offset < to) {
            c = digitChars[offset];
            if (c != 46) {
                num = num * 10 + (c - 48);
            }
            ++offset;
        }
        return negative ? num * -1 : num;
    }

    public static long parseLongFromToIgnoreDot(byte[] digitChars, int offset, int to) {
        boolean negative = false;
        byte c = digitChars[offset];
        if (c == 45) {
            ++offset;
            negative = true;
        }
        c = digitChars[offset];
        long num = c - 48;
        ++offset;
        while (offset < to) {
            c = digitChars[offset];
            if (c != 46) {
                num = num * 10L + (long)(c - 48);
            }
            ++offset;
        }
        return negative ? num * -1L : num;
    }

    public static float parseFloat(byte[] buffer, int from, int to) {
        return (float)ByteScanner.parseDouble(buffer, from, to);
    }

    public static double parseDouble(byte[] buffer) {
        return ByteScanner.parseDouble(buffer, 0, buffer.length);
    }

    public static double parseDouble(byte[] buffer, int from, int to) {
        double value;
        boolean simple = true;
        int digitsPastPoint = 0;
        int index = from;
        if (buffer[index] == 45) {
            ++index;
        }
        boolean foundDot = false;
        while (index < to) {
            byte ch = buffer[index];
            if (CharScanner.isNumberDigit(ch)) {
                if (foundDot) {
                    ++digitsPastPoint;
                }
            } else if (ch == 46) {
                foundDot = true;
            } else if (ch == 69 || ch == 101 || ch == 45 || ch == 43) {
                simple = false;
            } else {
                Exceptions.die("unexpected character " + ch);
            }
            ++index;
        }
        if (digitsPastPoint >= powersOf10.length - 1) {
            simple = false;
        }
        int length = index - from;
        if (!foundDot && simple) {
            value = ByteScanner.isInteger(buffer, from, length) ? (double)ByteScanner.parseIntFromTo(buffer, from, index) : (double)ByteScanner.parseLongFromTo(buffer, from, index);
        } else if (foundDot && simple) {
            if (length < powersOf10.length) {
                long lvalue = ByteScanner.isInteger(buffer, from, length) ? (long)ByteScanner.parseIntFromToIgnoreDot(buffer, from, index) : ByteScanner.parseLongFromToIgnoreDot(buffer, from, index);
                double power = powersOf10[digitsPastPoint];
                value = (double)lvalue / power;
            } else {
                value = Double.parseDouble(new String(buffer, from, length));
            }
        } else {
            value = Double.parseDouble(new String(buffer, from, index - from));
        }
        return value;
    }

    public static double simpleDouble(byte[] buffer, boolean simple, int digitsPastPoint, int startIndex, int endIndex) {
        if (simple) {
            int length = endIndex - startIndex;
            long value = ByteScanner.isInteger(buffer, startIndex, length) ? (long)ByteScanner.parseIntIgnoreDot(buffer, startIndex, length) : ByteScanner.parseLongIgnoreDot(buffer, startIndex, length);
            if (digitsPastPoint < powersOf10.length) {
                double power = powersOf10[digitsPastPoint];
                return (double)value / power;
            }
        }
        return Double.parseDouble(new String(buffer, startIndex, endIndex - startIndex));
    }

    public static int skipWhiteSpace(byte[] array, int index) {
        while (index < array.length) {
            byte c = array[index];
            if (c > 32) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static int skipWhiteSpace(byte[] array, int index, int length) {
        while (index < length) {
            byte c = array[index];
            if (c > 32) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static byte[] readNumber(byte[] array, int idx) {
        int startIndex = idx;
        while (CharScanner.isDecimalDigit(array[idx]) && ++idx < array.length) {
        }
        return Arrays.copyOfRange(array, startIndex, idx);
    }

    public static byte[] readNumber(byte[] array, int idx, int len) {
        int startIndex = idx;
        while (CharScanner.isDecimalDigit(array[idx]) && ++idx < len) {
        }
        return Arrays.copyOfRange(array, startIndex, idx);
    }

    public static int skipWhiteSpaceFast(byte[] array) {
        int index;
        for (index = 0; index < array.length; ++index) {
            byte c = array[index];
            if (c <= 32) continue;
            return index;
        }
        return index;
    }

    public static int skipWhiteSpaceFast(byte[] array, int index) {
        while (index < array.length) {
            byte c = array[index];
            if (c > 32) {
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    protected static int encodeNibbleToHexAsciiCharByte(int nibble) {
        switch (nibble) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return nibble + 48;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return nibble + 87;
            }
        }
        Exceptions.die("illegal nibble: " + nibble);
        return -1;
    }

    public static void encodeByteIntoTwoAsciiCharBytes(int decoded, byte[] encoded) {
        encoded[0] = (byte)ByteScanner.encodeNibbleToHexAsciiCharByte(decoded >> 4 & 0xF);
        encoded[1] = (byte)ByteScanner.encodeNibbleToHexAsciiCharByte(decoded & 0xF);
    }

    public static String errorDetails(String message, byte[] array, int index, int ch) {
        CharBuf buf = CharBuf.create(255);
        buf.addLine(message);
        buf.addLine("");
        buf.addLine("The current character read is " + CharScanner.debugCharDescription(ch));
        buf.addLine(message);
        int line = 0;
        int lastLineIndex = 0;
        for (int i = 0; i < index && i < array.length; ++i) {
            if (array[i] != 10) continue;
            ++line;
            lastLineIndex = i + 1;
        }
        int count = 0;
        int i = lastLineIndex;
        while (i < array.length && array[i] != 10) {
            ++i;
            ++count;
        }
        buf.addLine("line number " + (line + 1));
        buf.addLine("index number " + index);
        try {
            buf.addLine(new String(array, lastLineIndex, count));
        }
        catch (Exception ex) {
            try {
                index = index - 10 < 0 ? 0 : index - 10;
                int start = index;
                buf.addLine(new String(array, start, index));
            }
            catch (Exception ex2) {
                buf.addLine(new String(array, 0, array.length));
            }
        }
        for (i = 0; i < index - lastLineIndex; ++i) {
            buf.add('.');
        }
        buf.add('^');
        return buf.toString();
    }

    public static boolean hasEscapeChar(byte[] array, int index, int[] indexHolder) {
        while (index < array.length) {
            byte currentChar = array[index];
            if (CharScanner.isDoubleQuote(currentChar)) {
                indexHolder[0] = index;
                return false;
            }
            if (CharScanner.isEscape(currentChar)) {
                indexHolder[0] = index;
                return true;
            }
            ++index;
        }
        indexHolder[0] = index;
        return false;
    }

    public static int findEndQuote(byte[] array, int index) {
        byte currentChar;
        boolean escape = false;
        while (index < array.length && (!CharScanner.isDoubleQuote(currentChar = array[index]) || escape)) {
            escape = CharScanner.isEscape(currentChar) ? !escape : false;
            ++index;
        }
        return index;
    }

    public static int findEndQuoteUTF8(byte[] array, int index) {
        boolean escape = false;
        while (index < array.length) {
            byte currentChar = array[index];
            if (currentChar >= 0) {
                if (CharScanner.isDoubleQuote(currentChar) && !escape) break;
                escape = CharScanner.isEscape(currentChar) ? !escape : false;
            } else {
                index = ByteScanner.skipUTF8NonCharOrLongChar(currentChar, index);
            }
            ++index;
        }
        return index;
    }

    private static int skipUTF8NonCharOrLongChar(int c, int index) {
        if (c >> 5 == -2) {
            ++index;
        } else if (c >> 4 == -2) {
            index += 2;
        } else if (c >> 3 == -2) {
            index += 3;
        }
        return index;
    }

    public static boolean hasEscapeCharUTF8(byte[] array, int index, int[] indexHolder) {
        while (index < array.length) {
            byte currentChar = array[index];
            if (currentChar >= 0) {
                if (CharScanner.isDoubleQuote(currentChar)) {
                    indexHolder[0] = index;
                    return false;
                }
                if (CharScanner.isEscape(currentChar)) {
                    indexHolder[0] = index;
                    return true;
                }
            } else {
                index = ByteScanner.skipUTF8NonCharOrLongChar(currentChar, index);
            }
            ++index;
        }
        indexHolder[0] = index;
        return false;
    }
}

