/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl.indexes;

import java.util.ArrayList;
import java.util.List;

class MultiValue<T> {
    List<T> values = null;

    public static <T> MultiValue<T> add(MultiValue<T> org, T newItem, int bucketSize) {
        if (org == null) {
            return new MultiValue<T>(newItem, bucketSize);
        }
        super.add(newItem);
        return org;
    }

    public static <T> MultiValue<T> remove(MultiValue<T> org, T removeItem) {
        if (org == null) {
            return null;
        }
        if (removeItem != null) {
            super.remove(removeItem);
        }
        return org.size() == 0 ? null : org;
    }

    private MultiValue() {
    }

    private MultiValue(T item, int bucketSize) {
        this.values = new ArrayList<T>(bucketSize);
        this.values.add(item);
    }

    private void add(T item) {
        this.values.add(item);
    }

    private void remove(T item) {
        this.values.remove(item);
    }

    T getValue() {
        return this.values.size() > 0 ? (T)this.values.get(0) : null;
    }

    final List<T> getValues() {
        return this.values;
    }

    int size() {
        return this.values.size();
    }

    void addTo(List<T> results) {
        results.addAll(this.values);
    }
}

