/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.validators.BaseValidator;

public class MatchAnyRegexValidator
extends BaseValidator {
    private String[] matches;
    private Map<String, Pattern> compiledRegexCache = new HashMap<String, Pattern>();

    @Override
    public ValidatorMessageHolder validate(Object object, String fieldLabel) {
        ValidatorMessage message = new ValidatorMessage();
        if (object == null) {
            return message;
        }
        String string = object.toString();
        int validCount = 0;
        for (String match : this.matches) {
            Pattern pattern = this.compileRegex(match);
            if (!pattern.matcher(string).matches()) continue;
            ++validCount;
        }
        if (validCount == 0) {
            this.populateMessage(message, fieldLabel, new Object[0]);
            return message;
        }
        return message;
    }

    private Pattern compileRegex(String match) {
        Pattern pattern = this.compiledRegexCache.get(match);
        if (pattern == null) {
            pattern = Pattern.compile(match);
            this.compiledRegexCache.put(match, pattern);
        }
        return pattern;
    }

    public void setMatches(String[] matches) {
        this.matches = matches;
    }
}

