/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di.modules;

import java.util.Iterator;
import java.util.Set;
import org.boon.Sets;
import org.boon.Str;
import org.boon.core.reflection.Annotated;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MethodAccess;

public class NamedUtils {
    private static Set<String> annotationsThatHaveNamed = Sets.set("jsonProperty", "serializedName", "named", "id", "in", "qualifier");

    public static String namedValueForClass(Class<?> type) {
        ClassMeta<?> cls = ClassMeta.classMeta(type);
        String named = NamedUtils.findNamed(cls, type);
        return named;
    }

    public static String namedValueForMethod(MethodAccess method) {
        String named = NamedUtils.findNamed(method, method.returnType());
        if (named == null) {
            named = NamedUtils.namedValueForClass(method.returnType());
        }
        return named;
    }

    private static String findNamed(Annotated annotated, Class<?> type) {
        String annotationName;
        String named = null;
        Iterator<String> i$ = annotationsThatHaveNamed.iterator();
        while (i$.hasNext() && (named = NamedUtils.getName(annotated, annotationName = i$.next(), type)) == null) {
        }
        return named;
    }

    private static String getName(Annotated annotated, String annotationName, Class<?> type) {
        String named = null;
        if (annotated.hasAnnotation(annotationName) && Str.isEmpty(named = (String)annotated.annotation(annotationName).getValues().get("value"))) {
            named = Str.uncapitalize(type.getSimpleName());
        }
        return named;
    }
}

