/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import org.boon.core.Handler;
import org.boon.logging.ConfigurableLogger;
import org.boon.logging.LogLevel;
import org.boon.logging.LogRecord;
import org.boon.logging.LoggerDelegate;
import org.boon.logging.TeeLoggerWrapper;

public class Logger {
    private volatile transient LoggerDelegate logger;
    final LoggerDelegate original;

    public Logger(LoggerDelegate delegate) {
        this.original = this.logger = delegate;
    }

    public synchronized void tee(LoggerDelegate newLogger) {
        this.logger = new TeeLoggerWrapper(this.logger, newLogger);
    }

    public synchronized void handler(Handler<LogRecord> handler) {
        this.logger = new ConfigurableLogger(this.logger, handler);
    }

    public synchronized void teeAndHandler(LoggerDelegate newLogger, Handler<LogRecord> handler) {
        this.logger = new TeeLoggerWrapper(this.logger, newLogger);
    }

    public synchronized void unwrap() {
        this.logger = this.original;
    }

    public boolean infoOn() {
        return this.logger.infoOn();
    }

    public boolean debugOn() {
        return this.logger.debugOn();
    }

    public boolean traceOn() {
        return this.logger.traceOn();
    }

    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    public void fatal(Exception message) {
        this.logger.fatal((Object)"", message);
    }

    public void error(Exception message) {
        this.logger.error((Object)"", message);
    }

    public void warn(Exception message) {
        this.logger.warn((Object)"", message);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    public void warn(Object message) {
        this.logger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public void info(Object message, Throwable t) {
        this.logger.info(message, t);
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.logger.debug(message, t);
    }

    public void trace(Object message) {
        this.logger.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.logger.trace(message, t);
    }

    public void level(LogLevel level) {
        this.logger.level(level);
    }

    public void turnOff() {
        this.logger.turnOff();
    }

    public void fatal(Object ... messages) {
        this.logger.fatal(messages);
    }

    public void fatal(Throwable t, Object ... messages) {
        this.logger.fatal(t, messages);
    }

    public void error(Object ... messages) {
        this.logger.error(messages);
    }

    public void error(Throwable t, Object ... messages) {
        this.logger.error(t, messages);
    }

    public void warn(Object ... messages) {
        this.logger.warn(messages);
    }

    public void warn(Throwable t, Object ... messages) {
        this.logger.warn(t, messages);
    }

    public void info(Object ... messages) {
        this.logger.info(messages);
    }

    public void info(Throwable t, Object ... messages) {
        this.logger.info(t, messages);
    }

    public void config(Object ... messages) {
        this.logger.config(messages);
    }

    public void config(Throwable t, Object ... messages) {
        this.logger.config(t, messages);
    }

    public void debug(Object ... messages) {
        this.logger.debug(messages);
    }

    public void debug(Throwable t, Object ... messages) {
        this.logger.debug(t, messages);
    }

    public void trace(Object ... messages) {
        this.logger.trace(messages);
    }

    public void trace(Throwable t, Object ... messages) {
        this.logger.trace(t, messages);
    }
}

