/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.ConstructorAccess;

public class ConstructorAccessImpl<T>
implements ConstructorAccess {
    final Constructor<T> constructor;
    final List<AnnotationData> annotationData;
    final Map<String, AnnotationData> annotationMap;

    ConstructorAccessImpl() {
        this.constructor = null;
        this.annotationData = null;
        this.annotationMap = null;
    }

    public ConstructorAccessImpl(Constructor<T> method) {
        this.constructor = method;
        this.constructor.setAccessible(true);
        this.annotationData = Annotations.getAnnotationDataForMethod(method);
        this.annotationMap = new ConcurrentHashMap<String, AnnotationData>();
        for (AnnotationData data : this.annotationData) {
            this.annotationMap.put(data.getName(), data);
            this.annotationMap.put(data.getSimpleClassName(), data);
            this.annotationMap.put(data.getFullClassName(), data);
        }
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return new Iterable<AnnotationData>(){

            @Override
            public Iterator<AnnotationData> iterator() {
                return ConstructorAccessImpl.this.annotationData.iterator();
            }
        };
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    @Override
    public Class<?>[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public T create(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception ex) {
            return Exceptions.handle(this.constructor.getDeclaringClass(), ex, "\nunable to invoke constructor", this.constructor, "\n on object ", this.constructor.getDeclaringClass(), "\nwith arguments", args, "\nparams", this.constructor.getParameterTypes());
        }
    }

    public String toString() {
        return this.constructor.toString();
    }
}

