/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.boon.cache.Cache;

public class ConcurrentLruCache<KEY, VALUE>
implements Cache<KEY, VALUE> {
    private final Map<KEY, VALUE> map = new ConcurrentHashMap<KEY, VALUE>();
    private final Deque<KEY> queue = new ConcurrentLinkedDeque<KEY>();
    private final int limit;

    public ConcurrentLruCache(int limit) {
        this.limit = limit;
    }

    @Override
    public void put(KEY key, VALUE value) {
        VALUE oldValue = this.map.put(key, value);
        if (oldValue != null) {
            this.removeThenAddKey(key);
        } else {
            this.addKey(key);
        }
        if (this.map.size() > this.limit) {
            this.map.remove(this.removeLast());
        }
    }

    @Override
    public VALUE get(KEY key) {
        this.removeThenAddKey(key);
        return this.map.get(key);
    }

    @Override
    public VALUE getSilent(KEY key) {
        return this.map.get(key);
    }

    @Override
    public void remove(KEY key) {
        this.removeFirstOccurrence(key);
        this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private void addKey(KEY key) {
        this.queue.addFirst(key);
    }

    private KEY removeLast() {
        KEY removedKey = this.queue.removeLast();
        return removedKey;
    }

    private void removeThenAddKey(KEY key) {
        this.queue.removeFirstOccurrence(key);
        this.queue.addFirst(key);
    }

    private void removeFirstOccurrence(KEY key) {
        this.queue.removeFirstOccurrence(key);
    }

    public String toString() {
        return this.map.toString();
    }
}

