/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.Maps;
import org.boon.core.Sys;
import org.boon.primitive.ByteBuf;
import org.boon.service.Response;

public class HTTP {
    public static final int DEFAULT_TIMEOUT_SECONDS = Sys.sysProp("org.boon.HTTP.timeout.seconds", 30);
    public static final String APPLICATION_JSON = "application/json";

    public static String get(final String url) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                Map<String, String> accept = Maps.map("Accept", "text/html,application/xhtml+xml,application/xml,application/json,text/plain;");
                URLConnection connection = HTTP.doGet(url, accept, null, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String post(String url, String body) {
        return HTTP.postBodyTextWithContentType(url, "text/plain", body);
    }

    public static Response getResponse(final String url) {
        return Exceptions.tryIt(Response.class, new Exceptions.TrialWithReturn<Response>(){

            @Override
            public Response tryIt() throws Exception {
                Map<String, String> accept = Maps.map("Accept", "text/html,application/xhtml+xml,application/xml,application/json,text/plain;");
                URLConnection connection = HTTP.doGet(url, accept, null, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static byte[] getBytes(final String url, final String contentType) {
        return Exceptions.tryIt(byte[].class, new Exceptions.TrialWithReturn<byte[]>(){

            @Override
            public byte[] tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, null, contentType, null, true);
                return HTTP.extractResponseBytes(connection);
            }
        });
    }

    public static byte[] getBytesWithHeaders(final String url, final String contentType, final Map<String, ?> headers) {
        return Exceptions.tryIt(byte[].class, new Exceptions.TrialWithReturn<byte[]>(){

            @Override
            public byte[] tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, null, true);
                return HTTP.extractResponseBytes(connection);
            }
        });
    }

    public static String getWithHeaders(final String url, final Map<String, ?> headers) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, null, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String getWithContentType(final String url, final Map<String, ?> headers, final String contentType) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String getWithCharSet(final String url, final Map<String, ?> headers, final String contentType, final String charSet) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, contentType, charSet);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postText(String url, String body) {
        return HTTP.postBodyTextWithContentType(url, "text/plain", body);
    }

    public static String postBodyTextWithContentType(final String url, final String contentType, final String body) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, null, contentType, null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postJSON(String url, String jsonString) {
        return HTTP.postBodyTextWithContentType(url, APPLICATION_JSON, jsonString);
    }

    public static Response jsonRestCallViaPOST(String url, String jsonString) {
        return HTTP.postBodyTextWithContentTypeReturnResponse(url, APPLICATION_JSON, jsonString);
    }

    public static String getJSON(final String url, final Map<String, ?> headers) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static Response jsonRestCallWithHeaders(final String url, final Map<String, ?> headers) {
        return Exceptions.tryIt(Response.class, new Exceptions.TrialWithReturn<Response>(){

            @Override
            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response jsonRestCall(final String url) {
        return Exceptions.tryIt(Response.class, new Exceptions.TrialWithReturn<Response>(){

            @Override
            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, null, HTTP.APPLICATION_JSON, null);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static Response postBodyTextWithContentTypeReturnResponse(final String url, final String contentType, final String body) {
        return Exceptions.tryIt(Response.class, new Exceptions.TrialWithReturn<Response>(){

            @Override
            public Response tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, null, contentType, null, body);
                return HTTP.extractResponseObject(connection);
            }
        });
    }

    public static String getJSONWithParams(final String url, final Map<String, ?> headers, final Map<String, ?> params) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doGet(url, headers, HTTP.APPLICATION_JSON, null, params);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postXML(String url, String jsonString) {
        return HTTP.postBodyTextWithContentType(url, "text/xml", jsonString);
    }

    public static String postWithHeaders(final String url, final Map<String, ?> headers, final String body) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, "text/plain", null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postWithContentType(final String url, final Map<String, ?> headers, final String contentType, final String body) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, contentType, null, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    public static String postWithCharset(final String url, final Map<String, ?> headers, final String contentType, final String charSet, final String body) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPost(url, headers, contentType, charSet, body);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    private static URLConnection doPost(String url, Map<String, ?> headers, String contentType, String charset, String body) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setDoOutput(true);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        IO.write(connection.getOutputStream(), body, IO.DEFAULT_CHARSET);
        return connection;
    }

    public static String postForm(final String url, final Map<String, ?> headers, final Map<String, Object> formData) {
        return Exceptions.tryIt(String.class, new Exceptions.TrialWithReturn<String>(){

            @Override
            public String tryIt() throws Exception {
                URLConnection connection = HTTP.doPostFormData(url, headers, formData);
                return HTTP.extractResponseString(connection);
            }
        });
    }

    private static URLConnection doPostFormData(String url, Map<String, ?> headers, Map<String, Object> formData) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        connection.setDoOutput(true);
        connection.addRequestProperty("Content-TypeType", "application/x-www-form-urlencoded");
        ByteBuf buf = ByteBuf.create(244);
        Set<String> keys = formData.keySet();
        int index = 0;
        for (String key : keys) {
            Object value = formData.get(key);
            if (index > 0) {
                buf.addByte(38);
            }
            buf.addUrlEncoded(key);
            buf.addByte(61);
            if (!(value instanceof byte[])) {
                buf.addUrlEncoded(value.toString());
            } else {
                buf.addUrlEncodedByteArray((byte[])value);
            }
            ++index;
        }
        HTTP.manageContentTypeHeaders("application/x-www-form-urlencoded", StandardCharsets.UTF_8.name(), connection);
        HTTP.manageHeaders(headers, connection);
        int len = buf.len();
        IO.write(connection.getOutputStream(), new String(buf.readForRecycle(), 0, len, StandardCharsets.UTF_8), IO.DEFAULT_CHARSET);
        return connection;
    }

    private static void manageHeaders(Map<String, ?> headers, URLConnection connection) {
        if (headers != null) {
            for (Map.Entry<String, ?> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue().toString());
            }
        }
    }

    private static void manageContentTypeHeaders(String contentType, String charset, URLConnection connection, boolean binary) {
        if (!binary) {
            connection.setRequestProperty("Accept-Charset", charset == null ? StandardCharsets.UTF_8.displayName() : charset);
        }
        if (contentType != null && !contentType.isEmpty()) {
            connection.setRequestProperty("Content-TypeType", contentType);
        }
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset, boolean binary) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection, binary);
        HTTP.manageHeaders(headers, connection);
        return connection;
    }

    private static String extractResponseString(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        String charset = HTTP.getCharset(connection.getHeaderField("Content-TypeType"));
        if (status == 200) {
            return HTTP.readResponseBody(http, charset);
        }
        return HTTP.readErrorResponseBody(http, status, charset);
    }

    private static Response extractResponseObject(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        String charset = HTTP.getCharset(connection.getHeaderField("Content-TypeType"));
        String body = status == 200 ? HTTP.readResponseBody(http, charset) : HTTP.readErrorResponseBodyDoNotDie(http, status, charset);
        return Response.response(status, Collections.EMPTY_MAP, http.getResponseMessage(), body);
    }

    private static byte[] extractResponseBytes(URLConnection connection) throws IOException {
        HttpURLConnection http = (HttpURLConnection)connection;
        int status = http.getResponseCode();
        if (status == 200) {
            return HTTP.readResponseBodyAsBytes(http);
        }
        String charset = HTTP.getCharset(connection.getHeaderField("Content-TypeType"));
        HTTP.readErrorResponseBody(http, status, charset);
        return null;
    }

    private static byte[] readResponseBodyAsBytes(HttpURLConnection http) {
        try {
            return IO.input(http.getInputStream());
        }
        catch (IOException e) {
            return Exceptions.handle(byte[].class, e);
        }
    }

    private static String readErrorResponseBody(HttpURLConnection http, int status, String charset) {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = charset == null ? IO.read(errorStream) : IO.read(errorStream, charset);
            return Exceptions.die(String.class, "STATUS CODE =" + status + "\n\n" + error);
        }
        return Exceptions.die(String.class, "STATUS CODE =" + status);
    }

    private static String readErrorResponseBodyDoNotDie(HttpURLConnection http, int status, String charset) {
        InputStream errorStream = http.getErrorStream();
        if (errorStream != null) {
            String error = charset == null ? IO.read(errorStream) : IO.read(errorStream, charset);
            return error;
        }
        return "";
    }

    private static String readResponseBody(HttpURLConnection http, String charset) throws IOException {
        if (charset != null) {
            return IO.read(http.getInputStream(), charset);
        }
        return IO.read(http.getInputStream());
    }

    private static String getCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        String charset = null;
        for (String param : contentType.replace(" ", "").split(";")) {
            if (!param.startsWith("charset=")) continue;
            charset = param.split("=", 2)[1];
            break;
        }
        charset = charset == null ? StandardCharsets.UTF_8.displayName() : charset;
        return charset;
    }

    private static void manageContentTypeHeaders(String contentType, String charset, URLConnection connection) {
        connection.setRequestProperty("Accept-Charset", charset == null ? StandardCharsets.UTF_8.displayName() : charset);
        if (contentType != null && !contentType.isEmpty()) {
            connection.setRequestProperty("Content-TypeType", contentType);
        }
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        return connection;
    }

    private static URLConnection doGet(String url, Map<String, ?> headers, String contentType, String charset, Map<String, ?> params) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.UTF_8.name();
        }
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(DEFAULT_TIMEOUT_SECONDS * 1000);
        HTTP.manageContentTypeHeaders(contentType, charset, connection);
        HTTP.manageHeaders(headers, connection);
        Set<String> keys = params.keySet();
        for (String key : keys) {
            Object value = params.get(key);
            connection.addRequestProperty(URLEncoder.encode(key, charset), URLEncoder.encode(value.toString(), charset));
        }
        return connection;
    }
}

