/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.reflection.BeanUtils;
import org.boon.json.JsonFactory;
import org.boon.primitive.CharBuf;
import org.boon.template.JSTLCoreParser;
import org.boon.template.Template;

public class JSTLTemplate
implements Template {
    private Object context;
    private JSTLTemplate parentTemplate;

    @Override
    public String replace(String template, Object context) {
        this.initContext(context);
        CharBuf buf = CharBuf.create(template.length());
        JSTLCoreParser parser = new JSTLCoreParser();
        parser.parse(template);
        Iterator<JSTLCoreParser.Token> tokens = parser.getTokenList().iterator();
        while (tokens.hasNext()) {
            JSTLCoreParser.Token token = tokens.next();
            switch (token.type()) {
                case TEXT: {
                    buf.add(template, token.start(), token.stop());
                    break;
                }
                case EXPRESSION: {
                    String path = this.textFromToken(template, token);
                    buf.add(this.lookup(path));
                    break;
                }
                case COMMAND: {
                    this.handleCommand(buf, template, token, tokens);
                }
            }
        }
        return buf.toString();
    }

    private String textFromToken(String template, JSTLCoreParser.Token token) {
        return template.substring(token.start(), token.stop());
    }

    protected void initContext(Object context) {
        if (context instanceof CharSequence) {
            try {
                this.context = JsonFactory.fromJson(context.toString());
            }
            catch (Exception ex) {
                this.context = context;
            }
        } else {
            this.context = context;
        }
    }

    public Object lookup(String objectName) {
        return this.lookup(objectName, objectName);
    }

    public Object lookup(String objectName, String defaultValue) {
        Object value = BeanUtils.findProperty(this.context, objectName);
        if (value == null && this.parentTemplate != null) {
            value = this.parentTemplate.lookup(objectName);
        }
        return value == null ? defaultValue : value;
    }

    private void handleCommand(CharBuf buf, String template, JSTLCoreParser.Token token, Iterator<JSTLCoreParser.Token> tokens) {
        String commandText = this.textFromToken(template, token);
        int index = StringScanner.findWhiteSpace(commandText);
        String command = Str.endSliceOf(commandText, index);
        String args = Str.sliceOf(commandText, index).trim();
        char[] chars = args.toCharArray();
        boolean collectName = true;
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        block5: for (index = 0; index < chars.length; ++index) {
            char c = chars[index];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                case '=': {
                    collectName = false;
                    ++index;
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    collectName = true;
                    ++index;
                    String v = value.toString().trim();
                    Object o = v;
                    if (v.startsWith("${") && v.endsWith("}")) {
                        String path = Str.slc(v, 2, -1);
                        o = this.lookup(path);
                    }
                    params.put(name.toString(), o);
                    name = new StringBuilder();
                    value = new StringBuilder();
                    continue block5;
                }
                default: {
                    if (collectName) {
                        name.append(c);
                        continue block5;
                    }
                    value.append(c);
                }
            }
        }
        this.handleCommand(buf, template, command, params, tokens);
    }

    private void handleCommand(CharBuf buf, String template, String command, Map<String, Object> params, Iterator<JSTLCoreParser.Token> tokens) {
        switch (command) {
            case "if": {
                this.handleIf(buf, template, params, tokens);
            }
        }
    }

    private void handleIf(CharBuf buf, String template, Map<String, Object> params, Iterator<JSTLCoreParser.Token> tokens) {
        int stop;
        boolean display = Conversions.toBoolean(params.get("test"));
        JSTLCoreParser.Token token = tokens.next();
        if (token.type() == JSTLCoreParser.TokenTypes.COMMAND_BODY) {
            stop = token.stop();
        } else {
            stop = -1;
            Exceptions.die();
        }
        while (tokens.hasNext()) {
            token = tokens.next();
            if (display) {
                switch (token.type()) {
                    case TEXT: {
                        buf.add(template, token.start(), token.stop());
                        break;
                    }
                    case EXPRESSION: {
                        String path = this.textFromToken(template, token);
                        buf.add(this.lookup(path));
                        break;
                    }
                    case COMMAND: {
                        this.handleCommand(buf, template, token, tokens);
                    }
                }
            }
            if (token.stop() != stop) continue;
            break;
        }
    }
}

