/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Lists;
import org.boon.Maps;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.core.Conversions;
import org.boon.core.Function;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MethodAccess;
import org.boon.json.JsonFactory;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;
import org.boon.primitive.Chr;
import org.boon.template.Command;
import org.boon.template.Commands;
import org.boon.template.InvokeCommand;

public abstract class BoonTemplate {
    private static char[] startOfJSTLCommand = "<c:".toCharArray();
    private static char[] ifCommand = "if".toCharArray();
    private static char[] ifCommandTestAttribute = "test".toCharArray();
    private static char[] forEachCommand = "forEach".toCharArray();
    private static char[] forEachCommandItemsAttribute = "items".toCharArray();
    protected boolean strictChecking;
    protected char[] expressionStart = "{{".toCharArray();
    protected String endBlockStart = "{{/";
    protected char[] unescapedExpressionStart = "{{{".toCharArray();
    protected char[] unescapedExpressionEnd = "}}}".toCharArray();
    protected final boolean sameStart;
    protected String endBlockEnd = "}}";
    protected char[] expressionEnd = "}}".toCharArray();
    protected char expressionStart1stChar = this.expressionStart[0];
    protected char unescapedExpressionStartChar = this.unescapedExpressionStart[0];
    protected String commandMarker = "#";
    protected String elseBlock = "{{else}}";
    protected int lineIndex;
    protected char[][] lines;
    protected Object context;
    boolean escaped;
    protected Map<String, Command> commandMap;
    protected Map<String, MethodAccess> methodMap;
    protected Map<String, Function> functionMap;
    Function<String, String> stringEscaper = null;
    BoonTemplate parentTemplate;

    protected abstract boolean lineHasCommand();

    protected abstract boolean processLineCommand(CharBuf var1, char[] var2);

    public BoonTemplate(char[] expressionStart, char[] expressionEnd, Object functions) {
        this.expressionStart = expressionStart;
        this.expressionEnd = expressionEnd;
        this.expressionStart1stChar = expressionStart[0];
        this.unescapedExpressionStartChar = this.unescapedExpressionStart[0];
        boolean bl = this.sameStart = this.expressionStart1stChar == this.unescapedExpressionStartChar;
        if (functions != null) {
            this.extractFunctions(functions, false);
        }
    }

    protected Command command(String cmdStr) {
        if (this.commandMap == null) {
            if (this.parentTemplate != null) {
                return this.parentTemplate.command(cmdStr);
            }
            return null;
        }
        Command command = this.commandMap.get(cmdStr);
        if (command == null && this.parentTemplate != null) {
            command = this.parentTemplate.command(cmdStr);
        }
        if (command == null && !command.equals("missingCommand") && (command = this.command("missingCommand")) != null) {
            BeanUtils.idx((Object)command, "commandName", (Object)cmdStr);
        }
        return command;
    }

    public boolean strictChecking() {
        return this.strictChecking;
    }

    public BoonTemplate strictChecking(boolean strictChecking) {
        this.strictChecking = strictChecking;
        return this;
    }

    public BoonTemplate addFunctions(Object object) {
        this.extractFunctions(object, true);
        return this;
    }

    public BoonTemplate addFunction(String name, Function function) {
        if (this.functionMap == null) {
            this.functionMap = new HashMap<String, Function>();
        }
        this.functionMap.put(name, function);
        return this;
    }

    public BoonTemplate addFunction(String methodName, Object functions) {
        if (this.methodMap == null) {
            this.methodMap = new HashMap<String, MethodAccess>();
        }
        ClassMeta classMeta = ClassMeta.classMetaEither(functions);
        MethodAccess method = classMeta.method(methodName);
        return this;
    }

    public BoonTemplate addTemplateAsFunctions() {
        this.addFunction("functionMap", this);
        this.addFunction("commandMap", this);
        this.addFunction("methodMap", this);
        this.addFunction("lineIndex", this);
        this.addFunction("line", this);
        this.addFunction("parentTemplate", this);
        this.addFunction("context", this);
        this.addFunction("getThis", this);
        return this;
    }

    public BoonTemplate addCommandHandlers(Object object) {
        this.extractFunctions(object, false);
        return this;
    }

    public String expressionStart() {
        return FastStringUtils.noCopyStringFromChars(this.expressionStart);
    }

    public BoonTemplate expressionStart(String v) {
        this.expressionStart = FastStringUtils.toCharArray(v);
        return this;
    }

    public String endBlockStart() {
        return this.endBlockStart;
    }

    public BoonTemplate endBlockStart(String v) {
        this.endBlockStart = v;
        return this;
    }

    public String unescapedExpressionStart() {
        return FastStringUtils.noCopyStringFromChars(this.unescapedExpressionStart);
    }

    public BoonTemplate unescapedExpressionStart(String v) {
        this.unescapedExpressionStart = FastStringUtils.toCharArray(v);
        return this;
    }

    public String unescapedExpressionEnd() {
        return FastStringUtils.noCopyStringFromChars(this.unescapedExpressionEnd);
    }

    public BoonTemplate unescapedExpressionEnd(String v) {
        this.unescapedExpressionEnd = FastStringUtils.toCharArray(v);
        return this;
    }

    public String endBlockEnd() {
        return this.endBlockEnd;
    }

    public BoonTemplate endBlockEnd(String v) {
        this.endBlockEnd = v;
        return this;
    }

    public String expressionEnd() {
        return FastStringUtils.noCopyStringFromChars(this.expressionEnd);
    }

    public BoonTemplate expressionEnd(String v) {
        this.expressionEnd = FastStringUtils.toCharArray(v);
        return this;
    }

    public String commandMarker() {
        return this.commandMarker;
    }

    public String elseBlock() {
        return this.elseBlock;
    }

    public int lineIndex() {
        return this.lineIndex;
    }

    public String line() {
        return FastStringUtils.noCopyStringFromChars(this.lines[this.lineIndex]);
    }

    public Object context() {
        return this.context;
    }

    public Object getThis() {
        return this.context;
    }

    public Map<String, Command> commandMap() {
        return this.commandMap;
    }

    public Map<String, MethodAccess> functionMap() {
        return this.methodMap;
    }

    public BoonTemplate parentTemplate() {
        return this.parentTemplate;
    }

    private void extractFunctions(Object functions, boolean all) {
        if (this.commandMap == null) {
            this.commandMap = new HashMap<String, Command>();
        }
        if (this.methodMap == null) {
            this.methodMap = new HashMap<String, MethodAccess>();
        }
        ClassMeta classMeta = ClassMeta.classMetaEither(functions);
        Iterable<MethodAccess> methods = classMeta.methods();
        for (MethodAccess methodAccess : methods) {
            this.methodMap.put(methodAccess.name(), methodAccess.methodAccess().bind(functions));
            this.methodMap.put(Str.add(classMeta.name(), ".", methodAccess.name()), methodAccess.methodAccess().bind(functions));
        }
        if (!all) {
            for (MethodAccess methodAccess : methods) {
                if (methodAccess.respondsTo(CharBuf.class, String.class, CharSequence.class, Object.class)) {
                    this.commandMap.put(methodAccess.name(), new InvokeCommand(functions, methodAccess));
                    continue;
                }
                if (!methodAccess.respondsTo(String.class, CharSequence.class, Object.class)) continue;
                this.commandMap.put(methodAccess.name(), new InvokeCommand(functions, methodAccess));
            }
        } else {
            for (MethodAccess methodAccess : methods) {
                this.commandMap.put(methodAccess.name(), new InvokeCommand(functions, methodAccess));
            }
        }
        if (!all) {
            for (MethodAccess methodAccess : methods) {
                if (methodAccess.respondsTo(CharBuf.class, String.class, CharSequence.class, Object.class)) {
                    this.commandMap.put(Str.add(classMeta.name(), ".", methodAccess.name()), new InvokeCommand(functions, methodAccess));
                    continue;
                }
                if (!methodAccess.respondsTo(String.class, CharSequence.class, Object.class)) continue;
                this.commandMap.put(Str.add(classMeta.name(), ".", methodAccess.name()), new InvokeCommand(functions, methodAccess));
            }
        } else {
            for (MethodAccess methodAccess : methods) {
                this.commandMap.put(Str.add(classMeta.name(), ".", methodAccess.name()), new InvokeCommand(functions, methodAccess));
            }
        }
    }

    public BoonTemplate() {
        this.sameStart = this.expressionStart1stChar == this.unescapedExpressionStartChar;
    }

    public static BoonTemplate template() {
        return new BoonTemplateMustacheLike();
    }

    public static BoonTemplate jstl() {
        return new BoonTemplateJSTLLike();
    }

    public static BoonTemplate template(String expStart, String expEnd) {
        return new BoonTemplateMustacheLike(expStart.toCharArray(), expEnd.toCharArray(), null);
    }

    private static BoonTemplate template(char[] expStart, char[] expEnd) {
        return new BoonTemplateMustacheLike(expStart, expEnd, null);
    }

    public static BoonTemplate template(char[] expStart, char[] expEnd, Object functions) {
        return new BoonTemplateMustacheLike(expStart, expEnd, functions);
    }

    public static BoonTemplate templateWithCommandHandlers(Object functions) {
        BoonTemplateMustacheLike boonTemplate = new BoonTemplateMustacheLike();
        super.extractFunctions(functions, true);
        return boonTemplate;
    }

    public static BoonTemplate templateWithFunctions(Object functions) {
        BoonTemplateMustacheLike boonTemplate = new BoonTemplateMustacheLike();
        super.extractFunctions(functions, true);
        return boonTemplate;
    }

    public CharSequence replace(CharSequence template, Object context) {
        this.initContext(context);
        char[] chars = FastStringUtils.toCharArray(template);
        CharBuf output = CharBuf.create(template.length());
        this.lines = CharScanner.splitLines(chars);
        this.lineIndex = 0;
        while (this.lineIndex < this.lines.length) {
            char[] line = this.lines[this.lineIndex];
            if (!this.lineHasCommand() || !this.processLineCommand(output, line)) {
                int index = this.findExpression(line);
                if (index == -1) {
                    output.add(line);
                } else {
                    output.add(Arrays.copyOfRange(line, 0, index));
                    this.processCommandOrExpression(output, line, index);
                }
            }
            ++this.lineIndex;
        }
        return output;
    }

    protected void initContext(Object context) {
        if (context instanceof CharSequence) {
            try {
                this.context = JsonFactory.fromJson(context.toString());
            }
            catch (Exception ex) {
                this.context = context;
            }
        } else {
            this.context = context;
        }
    }

    private int findExpression(char[] line) {
        return this.findExpressionFromIndex(line, 0);
    }

    private int findExpressionFromIndex(char[] line, int startIndex) {
        if (this.sameStart && CharScanner.findChar(this.expressionStart1stChar, startIndex, line) == -1) {
            return -1;
        }
        int indexEscaped = CharScanner.findChars(this.expressionStart, startIndex, line);
        int indexUnEscaped = CharScanner.findChars(this.unescapedExpressionStart, startIndex, line);
        if (indexUnEscaped != -1) {
            this.escaped = false;
            return indexUnEscaped;
        }
        if (indexEscaped != -1) {
            this.escaped = true;
            return indexEscaped;
        }
        return -1;
    }

    protected String escape(String charSequence) {
        if (this.sameStart && charSequence.charAt(0) == '{') {
            charSequence = Str.sliceOf(charSequence, 1);
        }
        if (this.escaped && this.stringEscaper != null) {
            return this.stringEscaper.apply(charSequence);
        }
        return charSequence;
    }

    public Function<String, String> stringEscaper() {
        return this.stringEscaper;
    }

    public BoonTemplate setStringEscaper(Function<String, String> stringEscaper) {
        this.stringEscaper = stringEscaper;
        return this;
    }

    private void processCommandOrExpression(CharBuf output, char[] line, int index) {
        char[] expressionEnd;
        char[] expressionStart;
        if (this.escaped) {
            expressionStart = this.expressionStart;
            expressionEnd = this.expressionEnd;
        } else {
            expressionStart = this.unescapedExpressionStart;
            expressionEnd = this.unescapedExpressionEnd;
        }
        int startIndex = index + expressionStart.length;
        index = CharScanner.findChars(expressionEnd, startIndex, line);
        if (index == -1) {
            output.add(line);
            return;
        }
        String command = FastStringUtils.noCopyStringFromChars(Arrays.copyOfRange(line, startIndex, index));
        int lineNumber = this.lineIndex;
        this.processCommand(index += expressionEnd.length, output, command);
        int findIndex = this.findExpressionFromIndex(line, index);
        if (lineNumber == this.lineIndex) {
            if (findIndex == -1) {
                output.add(Arrays.copyOfRange(line, index, line.length));
            } else {
                output.add(Arrays.copyOfRange(line, index, findIndex));
                this.processCommandOrExpression(output, line, findIndex);
            }
        }
    }

    private void processCommand(int index, CharBuf output, String command) {
        if (!command.startsWith(this.commandMarker)) {
            this.handleExpressionOrFunction(output, command);
        } else {
            this.handleCommand(index, output, command);
        }
    }

    private void handleCommand(int index, CharBuf output, String command) {
        String cmd = Str.slc(command, this.commandMarker.length(), command.indexOf(32));
        String arguments = Str.slc(command, this.commandMarker.length() + cmd.length() + 1);
        String endOfBlock = Str.add(this.endBlockStart, cmd, this.endBlockEnd);
        switch (Commands.command(cmd)) {
            case UNLESS: {
                CharSequence[] blocks = this.readBlocks(index, this.elseBlock, endOfBlock);
                this.processUnless(output, arguments, blocks);
                break;
            }
            case LENGTH: {
                CharSequence[] blocks = this.readBlocks(index, this.elseBlock, endOfBlock);
                this.processLength(output, arguments, blocks);
                break;
            }
            case IF: {
                CharSequence[] blocks = this.readBlocks(index, this.elseBlock, endOfBlock);
                this.processIf(output, arguments, blocks);
                break;
            }
            case EACH: {
                CharSequence block = this.readBlock(index, endOfBlock);
                this.processEach(output, arguments, block);
                break;
            }
            case WITH: {
                CharSequence block = this.readBlock(index, endOfBlock);
                this.processWith(output, arguments, block);
                break;
            }
            default: {
                CharSequence block = this.readBlock(index, endOfBlock);
                Command commandObject = this.commandMap.get(cmd);
                if (commandObject == null) break;
                commandObject.processCommand(output, arguments, block, this.context);
            }
        }
    }

    protected void handleExpressionOrFunction(CharBuf output, String command) {
        if (command.contains("(")) {
            this.handleFunction(output, command);
        } else {
            this.handleExpression(output, command);
        }
    }

    protected void handleExpression(CharBuf output, String command) {
        Object object = this.lookup(command);
        String str = Str.toString(object, command);
        output.add(this.escape(str));
    }

    private void handleFunction(CharBuf output, String command) {
        String[] split = StringScanner.splitByChars(command, '(', ')');
        String methodName = split[0];
        MethodAccess method = this.methodMap.get(methodName);
        if (method == null) {
            return;
        }
        String arguments = split[1];
        Object args = this.getObjectFromArguments(arguments);
        Object out = Invoker.invokeMethodFromObjectArg(method.bound(), method, args);
        if (out != null) {
            output.add(out.toString());
        }
    }

    public Object lookup(String objectName) {
        return this.lookup(objectName, objectName);
    }

    public Object lookup(String objectName, String defaultValue) {
        Object value = BeanUtils.findProperty(this.context, objectName);
        if (value == null && this.parentTemplate != null) {
            value = this.parentTemplate.lookup(objectName);
        }
        return value == null ? defaultValue : value;
    }

    protected void processEach(CharBuf output, String arguments, CharSequence block) {
        Object object = this.parentTemplate == null && this.context instanceof List && (arguments.equals("this") || arguments.equals(".")) ? this.context : this.getObjectFromArguments(arguments);
        if (object instanceof Map) {
            this.eachMapProperty(output, block, object);
        } else {
            this.eachListItem(output, block, object);
        }
    }

    protected void eachListItem(CharBuf output, CharSequence block, Object object) {
        Iterator iterator = Conversions.iterator(object);
        int len = Boon.len(object);
        int index = 0;
        Map<String, Object> map = Maps.map("@length", len, "@array", object);
        while (iterator.hasNext()) {
            Object item = iterator.next();
            map.put("@index", index);
            map.put("@first", index == 0);
            map.put("@last", index == len - 1);
            map.put("@even", index % 2 == 0);
            map.put("@odd", index % 2 != 0);
            map.put("this", item);
            map.put("item", item);
            CharSequence blockOutput = BoonTemplate.template(this.expressionStart, this.expressionEnd).replace(block, Lists.list(item, map, this.context));
            output.add(blockOutput);
            ++index;
        }
    }

    private void eachMapProperty(CharBuf output, CharSequence block, Object object) {
        Map objectMap = (Map)object;
        Set entries = objectMap.entrySet();
        int len = objectMap.size();
        int index = 0;
        Map<String, Object> map = Maps.map("@length", len, "@array", object);
        for (Map.Entry entry : entries) {
            map.put("@index", index);
            map.put("@first", index == 0);
            map.put("@last", index == len - 1);
            map.put("@even", index % 2 == 0);
            map.put("@odd", index % 2 != 0);
            map.put("@value", entry.getValue());
            map.put("@this", entry.getValue());
            map.put("@key", entry.getKey());
            map.put("this", entry.getValue());
            CharSequence blockOutput = BoonTemplate.template(this.expressionStart, this.expressionEnd).replace(block, Lists.list(entry.getValue(), map, this.context));
            output.add(blockOutput);
            ++index;
        }
    }

    protected void processWith(CharBuf output, String arguments, CharSequence block) {
        Object object = this.getObjectFromArguments(arguments);
        CharSequence blockOutput = BoonTemplate.template(this.expressionStart, this.expressionEnd).replace(block, Lists.list(Maps.map("@this", object, "this", object), this.context));
        output.add(blockOutput);
    }

    protected void processIf(CharBuf output, String arguments, CharSequence[] blocks) {
        this.doProcessIf(output, arguments, blocks, false);
    }

    private void processUnless(CharBuf output, String arguments, CharSequence[] blocks) {
        this.doProcessIf(output, arguments, blocks, true);
    }

    private void processLength(CharBuf output, String arguments, CharSequence[] blocks) {
        String[] strings = Str.splitBySpace(arguments);
        if (strings.length > 1) {
            String len = strings[0];
            int length = (Integer)this.getObjectFromArguments(len);
            Collection collection = (Collection)this.getObjectFromArguments(Str.join(' ', Arry.sliceOf(strings, 1)));
        }
    }

    private void doProcessIf(CharBuf output, String arguments, CharSequence[] blocks, boolean negate) {
        CharSequence blockOutput;
        CharSequence elseBody;
        Object oTest;
        boolean test = true;
        if (arguments.startsWith("[") || arguments.startsWith("\"") || arguments.startsWith("{")) {
            arguments = this.createJSTL().replace(arguments, this.context).toString();
            oTest = JsonFactory.fromJson(arguments.replace('\'', '\"'));
            test = Conversions.toBoolean(oTest);
        } else if (arguments.contains(" ")) {
            arguments = this.createJSTL().replace(arguments, this.context).toString();
            String[] strings = Str.splitBySpace(arguments);
            List<String> list = Lists.list(strings);
            for (String string : strings) {
                oTest = this.lookup(string);
                if (test) {
                    test = Conversions.toBoolean(oTest);
                }
                if (oTest != null) {
                    list.add((String)oTest);
                    continue;
                }
                list.add(string);
            }
            oTest = list;
        } else {
            oTest = this.lookup(arguments, null);
            test = Conversions.toBoolean(oTest);
        }
        CharSequence ifBody = blocks[0];
        CharSequence charSequence = elseBody = blocks.length == 2 ? blocks[1] : null;
        if (negate) {
            boolean bl = test = !test;
        }
        if (test) {
            blockOutput = this.createTemplate().replace(ifBody, Lists.list(Maps.map("test", oTest, "this", oTest), this.context));
            output.add(blockOutput);
        } else if (elseBody != null) {
            blockOutput = this.createTemplate().replace(elseBody, Lists.list(Maps.map("test", oTest, "this", oTest), this.context));
            output.add(blockOutput);
        }
    }

    private BoonTemplate createTemplate() {
        BoonTemplate boonTemplate = this instanceof BoonTemplateMustacheLike ? BoonTemplate.template(this.expressionStart, this.expressionEnd) : (this instanceof BoonTemplateJSTLLike ? BoonTemplate.jstl() : BoonTemplate.template(this.expressionStart, this.expressionEnd));
        boonTemplate.parentTemplate = this;
        boonTemplate.elseBlock = this.elseBlock;
        boonTemplate.endBlockEnd = this.endBlockEnd;
        boonTemplate.endBlockStart = this.endBlockStart;
        boonTemplate.commandMarker = this.commandMarker;
        boonTemplate.expressionEnd = this.expressionEnd;
        boonTemplate.expressionStart = this.expressionStart;
        boonTemplate.unescapedExpressionStart = this.unescapedExpressionStart;
        boonTemplate.unescapedExpressionEnd = this.unescapedExpressionEnd;
        return boonTemplate;
    }

    protected CharSequence[] readBlocks(int startLine, String elseBlock, String endBlock) {
        CharBuf buf = CharBuf.create(80);
        if (this.readBlockFindFirstLine(startLine, endBlock, buf)) {
            return new CharSequence[]{buf};
        }
        CharBuf buf1 = null;
        CharBuf buf2 = null;
        while (this.lineIndex < this.lines.length) {
            int index = CharScanner.findString(elseBlock, this.lines[this.lineIndex]);
            if (index != -1) {
                buf1 = buf;
                buf = CharBuf.create(80);
            } else {
                index = CharScanner.findString(endBlock, this.lines[this.lineIndex]);
                if (index != -1) {
                    if (buf1 == null) break;
                    buf2 = buf;
                    break;
                }
                buf.add(this.lines[this.lineIndex]);
            }
            ++this.lineIndex;
        }
        if (buf2 == null) {
            return new CharBuf[]{buf};
        }
        return new CharBuf[]{buf1, buf2};
    }

    protected CharSequence readBlock(int startIndexOfFirstLine, String endBlock) {
        CharBuf buf = CharBuf.create(80);
        if (this.readBlockFindFirstLine(startIndexOfFirstLine, endBlock, buf)) {
            return buf;
        }
        while (this.lineIndex < this.lines.length) {
            int index = CharScanner.findString(endBlock, this.lines[this.lineIndex]);
            String line = this.line();
            if (index != -1) {
                return buf;
            }
            buf.add(this.lines[this.lineIndex]);
            ++this.lineIndex;
        }
        return buf;
    }

    private boolean readBlockFindFirstLine(int startIndexOfFirstLine, String endBlock, CharBuf buf) {
        char[] line = this.lines[this.lineIndex];
        int endIndexOfFirstLineCommandBody = CharScanner.findString(endBlock, this.lines[this.lineIndex]);
        if (endIndexOfFirstLineCommandBody != -1) {
            line = Chr.sliceOf(line, startIndexOfFirstLine, endIndexOfFirstLineCommandBody);
            buf.add(line);
            ++this.lineIndex;
            return true;
        }
        line = Chr.sliceOf(line, startIndexOfFirstLine);
        ++this.lineIndex;
        return false;
    }

    protected Object getObjectFromArguments(String arguments) {
        Object object;
        if (arguments.startsWith("[") || arguments.startsWith("\"") || arguments.startsWith("{") || arguments.startsWith("'")) {
            arguments = this.createJSTL().replace(arguments, this.context).toString();
            object = JsonFactory.fromJson(arguments.replace('\'', '\"'));
        } else if (arguments.contains(" ")) {
            arguments = this.createJSTL().replace(arguments, this.context).toString();
            String[] strings = Str.splitBySpace(arguments);
            List<String> list = Lists.list(strings);
            for (String string : strings) {
                object = this.lookup(string);
                if (object != null) {
                    list.add((String)object);
                    continue;
                }
                list.add(string);
            }
            object = list;
        } else {
            object = this.lookup(arguments);
        }
        return object;
    }

    private BoonTemplate createJSTL() {
        BoonTemplate jstl = BoonTemplate.jstl();
        jstl.parentTemplate = this;
        return jstl;
    }

    static class BoonTemplateJSTLLike
    extends BoonTemplate {
        BoonTemplateJSTLLike() {
            this.expressionStart = FastStringUtils.toCharArray("${");
            this.expressionEnd = FastStringUtils.toCharArray("}");
            this.unescapedExpressionStart = FastStringUtils.toCharArray("${fn:escapeXml(");
            this.unescapedExpressionEnd = FastStringUtils.toCharArray("}");
            this.expressionStart1stChar = (char)36;
            this.unescapedExpressionStartChar = (char)36;
        }

        @Override
        protected final boolean lineHasCommand() {
            return true;
        }

        @Override
        protected final boolean processLineCommand(CharBuf output, char[] line) {
            int index = 0;
            int indexOfIf = 0;
            int indexOfEach = 0;
            index = CharScanner.findChars(startOfJSTLCommand, line);
            if (index != -1) {
                indexOfIf = CharScanner.findChars(ifCommand, index, line);
                if (indexOfIf != -1) {
                    index = CharScanner.findChars(ifCommandTestAttribute, indexOfIf, line);
                    if (index == -1) {
                        return false;
                    }
                    if ((index = CharScanner.findChar('=', index + ifCommandTestAttribute.length, line)) == -1) {
                        return false;
                    }
                    if ((index = CharScanner.findChar('\"', index, line)) == -1) {
                        return false;
                    }
                    int endIndex = CharScanner.findEndQuote(line, index + 1);
                    String arguments = FastStringUtils.noCopyStringFromChars(Arrays.copyOfRange(line, index + 1, endIndex));
                    index = CharScanner.findChar('>', index + 1, line);
                    CharSequence block = this.readBlock(index, "</c:if>");
                    this.processIf(output, arguments, new CharSequence[]{block});
                    return true;
                }
                indexOfEach = CharScanner.findChars(forEachCommand, index, line);
                if (indexOfEach != -1) {
                    index = CharScanner.findChars(forEachCommandItemsAttribute, indexOfEach, line);
                    if (index == -1) {
                        return false;
                    }
                    if ((index = CharScanner.findChar('=', index + forEachCommandItemsAttribute.length, line)) == -1) {
                        return false;
                    }
                    if ((index = CharScanner.findChar('\"', index, line)) == -1) {
                        return false;
                    }
                    int endIndex = CharScanner.findEndQuote(line, index + 1);
                    String arguments = FastStringUtils.noCopyStringFromChars(Arrays.copyOfRange(line, index + 1, endIndex));
                    index = CharScanner.findChar('>', index + 1, line);
                    CharSequence block = this.readBlock(index, "</c:forEach>");
                    this.processEach(output, arguments, block);
                    return true;
                }
            }
            return false;
        }
    }

    static class BoonTemplateMustacheLike
    extends BoonTemplate {
        BoonTemplateMustacheLike() {
        }

        BoonTemplateMustacheLike(char[] expressionStart, char[] expressionEnd, Object functions) {
            super(expressionStart, expressionEnd, functions);
        }

        @Override
        protected final boolean lineHasCommand() {
            return false;
        }

        @Override
        protected final boolean processLineCommand(CharBuf output, char[] line) {
            return true;
        }
    }
}

