/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.reflection.fields.FieldsAccessorFieldThenProp;
import org.boon.json.serializers.ArraySerializer;
import org.boon.json.serializers.CollectionSerializer;
import org.boon.json.serializers.DateSerializer;
import org.boon.json.serializers.FieldSerializer;
import org.boon.json.serializers.InstanceSerializer;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.json.serializers.MapSerializer;
import org.boon.json.serializers.ObjectSerializer;
import org.boon.json.serializers.StringSerializer;
import org.boon.json.serializers.UnknownSerializer;
import org.boon.json.serializers.impl.BasicObjectSerializerImpl;
import org.boon.json.serializers.impl.CollectionSerializerImpl;
import org.boon.json.serializers.impl.DateSerializerImpl;
import org.boon.json.serializers.impl.FieldSerializerImpl;
import org.boon.json.serializers.impl.InstanceSerializerImpl;
import org.boon.json.serializers.impl.MapSerializerImpl;
import org.boon.json.serializers.impl.StringSerializerImpl;
import org.boon.json.serializers.impl.UnknownSerializerImpl;
import org.boon.primitive.CharBuf;

public class JsonSerializerImpl
implements JsonSerializerInternal {
    private final ObjectSerializer objectSerializer;
    private final StringSerializer stringSerializer;
    private final MapSerializer mapSerializer;
    private final FieldSerializer fieldSerializer;
    private final InstanceSerializer instanceSerializer;
    private final CollectionSerializer collectionSerializer;
    private final ArraySerializer arraySerializer;
    private final UnknownSerializer unknownSerializer;
    private final DateSerializer dateSerializer;
    private final FieldsAccessor fieldsAccessor;
    private CharBuf builder = CharBuf.create(4000);

    public JsonSerializerImpl() {
        this.instanceSerializer = new InstanceSerializerImpl();
        this.objectSerializer = new BasicObjectSerializerImpl();
        this.stringSerializer = new StringSerializerImpl(true);
        this.mapSerializer = new MapSerializerImpl();
        this.fieldSerializer = new FieldSerializerImpl();
        this.collectionSerializer = new CollectionSerializerImpl();
        this.arraySerializer = (ArraySerializer)((Object)this.collectionSerializer);
        this.unknownSerializer = new UnknownSerializerImpl();
        this.dateSerializer = new DateSerializerImpl();
        this.fieldsAccessor = new FieldsAccessorFieldThenProp(true);
    }

    public JsonSerializerImpl(ObjectSerializer objectSerializer, StringSerializer stringSerializer, MapSerializer mapSerializer, FieldSerializer fieldSerializer, InstanceSerializer instanceSerializer, CollectionSerializer collectionSerializer, ArraySerializer arraySerializer, UnknownSerializer unknownSerializer, DateSerializer dateSerializer, FieldsAccessor fieldsAccessor) {
        this.fieldsAccessor = fieldsAccessor == null ? new FieldsAccessorFieldThenProp(true) : fieldsAccessor;
        this.dateSerializer = dateSerializer == null ? new DateSerializerImpl() : dateSerializer;
        this.unknownSerializer = unknownSerializer == null ? new UnknownSerializerImpl() : unknownSerializer;
        this.arraySerializer = arraySerializer == null ? new CollectionSerializerImpl() : arraySerializer;
        this.collectionSerializer = collectionSerializer == null ? new CollectionSerializerImpl() : collectionSerializer;
        this.instanceSerializer = instanceSerializer == null ? new InstanceSerializerImpl() : instanceSerializer;
        this.objectSerializer = objectSerializer == null ? new BasicObjectSerializerImpl() : objectSerializer;
        this.stringSerializer = stringSerializer == null ? new StringSerializerImpl(true) : stringSerializer;
        this.mapSerializer = mapSerializer == null ? new MapSerializerImpl() : mapSerializer;
        this.fieldSerializer = fieldSerializer == null ? new FieldSerializerImpl() : fieldSerializer;
    }

    @Override
    public final CharBuf serialize(Object obj) {
        this.builder.readForRecycle();
        try {
            this.serializeObject(obj, this.builder);
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, "unable to serializeObject", ex);
        }
        return this.builder;
    }

    @Override
    public final boolean serializeField(Object parent, FieldAccess fieldAccess, CharBuf builder) {
        return this.fieldSerializer.serializeField(this, parent, fieldAccess, builder);
    }

    @Override
    public final void serializeObject(Object obj, CharBuf builder) {
        this.objectSerializer.serializeObject(this, obj, builder);
    }

    @Override
    public final void serializeString(String str, CharBuf builder) {
        this.stringSerializer.serializeString(this, str, builder);
    }

    @Override
    public final void serializeMap(Map<String, Object> map, CharBuf builder) {
        this.mapSerializer.serializeMap(this, map, builder);
    }

    @Override
    public final void serializeCollection(Collection<?> collection, CharBuf builder) {
        this.collectionSerializer.serializeCollection(this, collection, builder);
    }

    @Override
    public final void serializeArray(Object obj, CharBuf builder) {
        this.arraySerializer.serializeArray(this, obj, builder);
    }

    @Override
    public final void serializeUnknown(Object obj, CharBuf builder) {
        this.unknownSerializer.serializeUnknown(this, obj, builder);
    }

    @Override
    public final void serializeDate(Date date, CharBuf builder) {
        this.dateSerializer.serializeDate(this, date, builder);
    }

    @Override
    public final void serializeInstance(Object obj, CharBuf builder) {
        this.instanceSerializer.serializeInstance(this, obj, builder);
    }

    @Override
    public void serializeSubtypeInstance(Object obj, CharBuf builder) {
        this.instanceSerializer.serializeSubtypeInstance(this, obj, builder);
    }

    @Override
    public final Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        return this.fieldsAccessor.getFields(aClass);
    }
}

