/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.implementation;

import java.util.AbstractList;
import java.util.ArrayList;
import org.boon.core.Type;
import org.boon.core.Value;
import org.boon.core.value.CharSequenceValue;
import org.boon.core.value.LazyValueMap;
import org.boon.core.value.MapItemValue;
import org.boon.core.value.NumberValue;
import org.boon.core.value.ValueContainer;
import org.boon.core.value.ValueList;
import org.boon.core.value.ValueMap;
import org.boon.core.value.ValueMapImpl;
import org.boon.json.implementation.JsonFastParser;
import org.boon.primitive.CharScanner;

public class PlistParser
extends JsonFastParser {
    protected static final int CLOSED_PAREN = 41;
    protected static final int SEMI_COLON = 59;

    public PlistParser() {
    }

    public PlistParser(boolean useValues) {
        super(useValues);
    }

    public PlistParser(boolean useValues, boolean chop) {
        super(useValues, chop);
    }

    public PlistParser(boolean useValues, boolean chop, boolean lazyChop) {
        super(useValues, chop, lazyChop);
    }

    public PlistParser(boolean useValues, boolean chop, boolean lazyChop, boolean checkDates) {
        super(useValues, chop, lazyChop, checkDates);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value decodeJsonObjectLax() {
        if (this.__currentChar == '{') {
            this.nextChar();
        }
        ValueMap map = (ValueMap)((Object)(this.useValues ? new ValueMapImpl() : new LazyValueMap(this.lazyChop)));
        ValueContainer value = new ValueContainer(map);
        this.skipWhiteSpaceIfNeeded();
        int startIndexOfKey = this.__index;
        while (this.__index < this.charArray.length) {
            this.skipWhiteSpaceIfNeeded();
            switch (this.__currentChar) {
                case '/': {
                    this.handleComment();
                    startIndexOfKey = this.__index;
                    break;
                }
                case '#': {
                    this.handleBashComment();
                    startIndexOfKey = this.__index;
                    break;
                }
                case '=': {
                    char startChar = this.charArray[startIndexOfKey];
                    if (startChar == ';') {
                        ++startIndexOfKey;
                    }
                    Value key = this.extractLaxString(startIndexOfKey, this.__index - 1, false, false);
                    Value item = this.decodeValuePlist();
                    this.skipWhiteSpaceIfNeeded();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                    startIndexOfKey = ++this.__index;
                    if (this.__currentChar != '}') break;
                    ++this.__index;
                    return value;
                }
                case '\"': {
                    Value key = this.decodeStringPlist();
                    this.skipWhiteSpaceIfNeeded();
                    if (this.__currentChar != '=') {
                        this.complain("expecting current character to be '='  but got " + this.charDescription(this.__currentChar) + "\n");
                    }
                    Value item = this.decodeValuePlist();
                    this.skipWhiteSpaceIfNeeded();
                    MapItemValue miv = new MapItemValue(key, item);
                    map.add(miv);
                    startIndexOfKey = ++this.__index;
                    if (this.__currentChar != '}') break;
                    ++this.__index;
                    if (!this.hasMore()) return value;
                    if (this.charArray[this.__index] != ';') return value;
                    ++this.__index;
                    return value;
                }
                case '}': {
                    ++this.__index;
                    if (!this.hasMore()) return value;
                    if (this.charArray[this.__index] != ';') return value;
                    ++this.__index;
                    return value;
                }
            }
            ++this.__index;
        }
        return value;
    }

    private Value extractLaxString(int startIndexOfKey, int end, boolean encoded, boolean checkDate) {
        int endIndex;
        block8: while (startIndexOfKey < this.__index && startIndexOfKey < this.charArray.length) {
            char startChar = this.charArray[startIndexOfKey];
            switch (startChar) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    break block8;
                }
            }
            ++startIndexOfKey;
        }
        int n = endIndex = end >= this.charArray.length ? this.charArray.length - 1 : end;
        block9: while (endIndex >= startIndexOfKey + 1 && endIndex >= 0) {
            char endChar = this.charArray[endIndex];
            switch (endChar) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '}': {
                    break;
                }
                case ',': 
                case ';': {
                    break;
                }
                case ')': {
                    break;
                }
                default: {
                    break block9;
                }
            }
            --endIndex;
        }
        return new CharSequenceValue(this.chop, Type.STRING, startIndexOfKey, endIndex + 1, this.charArray, encoded, checkDate);
    }

    private Value decodeValuePlist() {
        Value value = null;
        while (this.__index < this.charArray.length) {
            this.skipWhiteSpaceIfNeeded();
            switch (this.__currentChar) {
                case '/': {
                    this.handleComment();
                    break;
                }
                case '#': {
                    this.handleBashComment();
                    break;
                }
                case '\"': {
                    value = this.decodeStringPlist();
                    break;
                }
                case 't': {
                    if (this.isTrue()) {
                        return this.decodeTrue() ? ValueContainer.TRUE : ValueContainer.FALSE;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case 'f': {
                    if (this.isFalse()) {
                        return !this.decodeFalse() ? ValueContainer.FALSE : ValueContainer.TRUE;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case 'n': {
                    if (this.isNull()) {
                        return this.decodeNull() == null ? ValueContainer.NULL : ValueContainer.NULL;
                    }
                    value = this.decodeStringLax();
                    break;
                }
                case '(': {
                    value = this.decodeJsonArrayLax();
                    break;
                }
                case '{': {
                    value = this.decodeJsonObjectLax();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = this.decodeNumberPLIST(false);
                    break;
                }
                case '-': {
                    value = this.decodeNumberPLIST(true);
                    break;
                }
                default: {
                    value = this.decodeStringLax();
                }
            }
            if (value != null) {
                return value;
            }
            ++this.__index;
        }
        return null;
    }

    private void handleBashComment() {
        while (this.__index < this.charArray.length) {
            this.__currentChar = this.charArray[this.__index];
            if (this.__currentChar == '\n') {
                ++this.__index;
                return;
            }
            ++this.__index;
        }
    }

    private void handleComment() {
        if (this.hasMore()) {
            ++this.__index;
            this.__currentChar = this.charArray[this.__index];
            switch (this.__currentChar) {
                case '*': {
                    while (this.__index < this.charArray.length) {
                        this.__currentChar = this.charArray[this.__index];
                        if (this.__currentChar == '*') {
                            if (this.hasMore()) {
                                ++this.__index;
                                this.__currentChar = this.charArray[this.__index];
                                if (this.__currentChar == '/' && this.hasMore()) {
                                    ++this.__index;
                                    return;
                                }
                            } else {
                                this.complain("missing close of comment");
                            }
                        }
                        ++this.__index;
                    }
                }
                case '/': {
                    while (this.__index < this.charArray.length) {
                        this.__currentChar = this.charArray[this.__index];
                        if (this.__currentChar == '\n') {
                            if (this.hasMore()) {
                                ++this.__index;
                                return;
                            }
                            return;
                        }
                        ++this.__index;
                    }
                    break;
                }
            }
        }
    }

    protected static boolean isPLISTDelimiter(int c) {
        return c == 59 || c == 125 || c == 41 || c == 44;
    }

    protected Value decodeNumberPLIST(boolean minus) {
        char currentChar;
        char[] array = this.charArray;
        int startIndex = this.__index;
        int index = this.__index;
        boolean doubleFloat = false;
        if (minus && index + 1 < array.length) {
            ++index;
        }
        do {
            if (CharScanner.isNumberDigit(currentChar = array[index])) continue;
            if (currentChar <= ' ' || PlistParser.isPLISTDelimiter(currentChar)) break;
            if (!CharScanner.isDecimalChar(currentChar)) continue;
            doubleFloat = true;
        } while (++index < array.length);
        this.__index = index;
        this.__currentChar = currentChar;
        Type type = doubleFloat ? Type.DOUBLE : Type.INTEGER;
        NumberValue value = new NumberValue(this.chop, type, startIndex, this.__index, this.charArray);
        return value;
    }

    private boolean isNull() {
        return this.__index + NULL.length <= this.charArray.length && this.charArray[this.__index] == 'n' && this.charArray[this.__index + 1] == 'u' && this.charArray[this.__index + 2] == 'l' && this.charArray[this.__index + 3] == 'l';
    }

    private boolean isTrue() {
        return this.__index + TRUE.length <= this.charArray.length && this.charArray[this.__index] == 't' && this.charArray[this.__index + 1] == 'r' && this.charArray[this.__index + 2] == 'u' && this.charArray[this.__index + 3] == 'e';
    }

    private boolean isFalse() {
        return this.__index + FALSE.length <= this.charArray.length && this.charArray[this.__index] == 'f' && this.charArray[this.__index + 1] == 'a' && this.charArray[this.__index + 2] == 'l' && this.charArray[this.__index + 3] == 's' && this.charArray[this.__index + 4] == 'e';
    }

    private Value decodeStringLax() {
        int index;
        char currentChar = this.charArray[this.__index];
        int startIndex = this.__index;
        boolean encoded = false;
        char[] charArray = this.charArray;
        for (index = this.__index; index < charArray.length && !PlistParser.isPLISTDelimiter(currentChar = charArray[index]) && currentChar != '\\'; ++index) {
        }
        Value value = this.extractLaxString(startIndex, index, encoded, this.checkDates);
        this.__index = index;
        return value;
    }

    private Value decodeStringPlist() {
        char[] array = this.charArray;
        int index = this.__index;
        char currentChar = this.charArray[index];
        if (index < array.length && currentChar == '\"') {
            ++index;
        }
        int startIndex = index;
        boolean encoded = CharScanner.hasEscapeChar(array, index, this.indexHolder);
        index = this.indexHolder[0];
        if (encoded) {
            index = CharScanner.findEndQuote(array, index);
        }
        CharSequenceValue value = new CharSequenceValue(this.chop, Type.STRING, startIndex, index, array, encoded, this.checkDates);
        if (index < array.length) {
            ++index;
        }
        this.__index = index;
        return value;
    }

    private Value decodeJsonArrayLax() {
        if (this.__currentChar == '(') {
            ++this.__index;
        }
        this.skipWhiteSpaceIfNeeded();
        if (this.__currentChar == ')') {
            ++this.__index;
            return EMPTY_LIST;
        }
        AbstractList list = this.useValues ? new ArrayList() : new ValueList(this.lazyChop);
        ValueContainer value = new ValueContainer(list);
        this.skipWhiteSpaceIfNeeded();
        do {
            this.skipWhiteSpaceIfNeeded();
            Value arrayItem = this.decodeValuePlist();
            list.add((Object)arrayItem);
            this.skipWhiteSpaceIfNeeded();
            char c = this.__currentChar;
            if (c == ',') {
                ++this.__index;
                continue;
            }
            if (c == ')') {
                ++this.__index;
                break;
            }
            String charString = this.charDescription(c);
            this.complain(String.format("expecting a ',' or a ')',  but got \nthe current character of  %s  on array index of %s \n", charString, list.size()));
        } while (this.hasMore());
        return value;
    }

    @Override
    public Object parse(char[] chars) {
        this.lastIndex = chars.length - 1;
        this.__index = 0;
        this.charArray = chars;
        Value value = this.decodeValuePlist();
        if (value.isContainer()) {
            return value.toValue();
        }
        return value;
    }
}

