/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldsAccessor;

public class PropertyFieldAccessor
implements FieldsAccessor {
    private final Map<Class<?>, Map<String, FieldAccess>> fieldMap = new ConcurrentHashMap();
    private final boolean useAlias;
    private final boolean caseInsensitive;

    public PropertyFieldAccessor(boolean useAlias) {
        this(useAlias, false);
    }

    public PropertyFieldAccessor(boolean useAlias, boolean caseInsensitive) {
        this.useAlias = useAlias;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public final Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> map = this.fieldMap.get(aClass);
        if (map == null) {
            map = this.doGetFields(aClass);
            this.fieldMap.put(aClass, map);
        }
        return map;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    private final Map<String, FieldAccess> doGetFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> fieldAccessMap = Reflection.getPropertyFieldAccessors(aClass);
        if (this.caseInsensitive) {
            Map<String, FieldAccess> mapOld = fieldAccessMap;
            fieldAccessMap = new LinkedHashMap<String, FieldAccess>();
            for (Map.Entry entry : mapOld.entrySet()) {
                fieldAccessMap.put(((String)entry.getKey()).toLowerCase(), (FieldAccess)entry.getValue());
            }
        }
        if (this.useAlias) {
            LinkedHashMap<String, FieldAccess> fieldAccessMap2 = new LinkedHashMap<String, FieldAccess>(fieldAccessMap.size());
            for (FieldAccess fieldAccess : fieldAccessMap.values()) {
                String alias = fieldAccess.alias();
                if (this.caseInsensitive) {
                    alias = alias.toLowerCase();
                }
                fieldAccessMap2.put(alias, fieldAccess);
            }
            return fieldAccessMap2;
        }
        return fieldAccessMap;
    }
}

