/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.invoke.ConstantCallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.collections.MultiMap;
import org.boon.core.Typ;
import org.boon.core.reflection.Annotated;
import org.boon.core.reflection.AnnotationData;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.ConstructorAccess;
import org.boon.core.reflection.MethodAccess;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.impl.ConstructorAccessImpl;
import org.boon.core.reflection.impl.MethodAccessImpl;

public class ClassMeta<T>
implements Annotated {
    final Class<T> cls;
    final Map<String, MethodAccess> methodMap;
    final List<ConstructorAccess<T>> constructorAccessSet;
    final MultiMap<String, MethodAccess> methodsMulti;
    final List<MethodAccess> methods;
    final Map<String, FieldAccess> fieldMap;
    final Map<String, FieldAccess> propertyMap;
    final List<FieldAccess> fields;
    final List<FieldAccess> properties;
    final Set<String> instanceMethods;
    final Set<String> classMethods;
    final ConstructorAccess<T> noArgConstructor;
    static final MethodAccess MANY_METHODS = new MethodAccessImpl(){

        @Override
        public Object invoke(Object object, Object ... args) {
            return Exceptions.die(Object.class, "Unable to invoke method as there are more than one with that same name", object, args);
        }

        @Override
        public boolean respondsTo(Class<?>[] parametersToMatch) {
            return false;
        }

        @Override
        public Iterable<AnnotationData> annotationData() {
            return Exceptions.die(Iterable.class, "Unable to use method as there are more than one with that same name");
        }

        @Override
        public boolean hasAnnotation(String annotationName) {
            return Exceptions.die(Boolean.class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public AnnotationData annotation(String annotationName) {
            return Exceptions.die(AnnotationData.class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public Class<?>[] parameterTypes() {
            return Exceptions.die(Class[].class, "Unable to invoke method as there are more than one with that same name");
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return Exceptions.die(Type[].class, "Unable to invoke method as there are more than one with that same name");
        }
    };
    private final Map<String, AnnotationData> annotationMap;
    private final List<AnnotationData> annotations;

    public Set<String> instanceMethods() {
        return new LinkedHashSet<String>(this.instanceMethods);
    }

    public Set<String> classMethods() {
        return new LinkedHashSet<String>(this.classMethods);
    }

    public ClassMeta(Class<T> cls) {
        Exceptions.requireNonNull(cls);
        this.cls = cls;
        if (!cls.isInterface()) {
            this.fieldMap = Reflection.getAllAccessorFields(this.cls);
            this.fields = Lists.list(this.fieldMap.values());
        } else {
            this.fieldMap = Collections.EMPTY_MAP;
            this.fields = Collections.EMPTY_LIST;
        }
        this.propertyMap = Reflection.getPropertyFieldAccessors(this.cls);
        this.properties = Lists.list(this.propertyMap.values());
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        ConstructorAccessImpl noArg = null;
        LinkedHashSet set = new LinkedHashSet();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length == 0) {
                noArg = new ConstructorAccessImpl(constructor);
            }
            set.add(new ConstructorAccessImpl(constructor));
        }
        this.noArgConstructor = noArg;
        this.constructorAccessSet = Lists.safeList(set);
        List<Class<T>> classes = this.getBaseClassesSuperFirst(cls);
        this.methodMap = new ConcurrentHashMap<String, MethodAccess>();
        this.methodsMulti = new MultiMap();
        this.instanceMethods = new LinkedHashSet<String>();
        this.classMethods = new LinkedHashSet<String>();
        for (Class<T> clasz : classes) {
            Method[] methods_;
            for (Method m : methods_ = clasz.getDeclaredMethods()) {
                if (this.methodMap.containsKey(m.getName())) {
                    MethodAccessImpl invoker = (MethodAccessImpl)this.methodMap.get(m.getName());
                    if (invoker != MANY_METHODS) {
                        if (invoker.method.getParameterTypes().length != m.getParameterTypes().length) {
                            this.methodMap.put(m.getName(), MANY_METHODS);
                        } else {
                            boolean match = true;
                            for (int index = 0; index < m.getParameterTypes().length; ++index) {
                                if (m.getParameterTypes()[index] == invoker.method.getParameterTypes()[index]) continue;
                                match = false;
                            }
                            if (match) {
                                this.methodMap.put(m.getName(), new MethodAccessImpl(m));
                            } else {
                                this.methodMap.put(m.getName(), MANY_METHODS);
                            }
                        }
                    }
                } else {
                    this.methodMap.put(m.getName(), new MethodAccessImpl(m));
                }
                MethodAccessImpl mai = new MethodAccessImpl(m);
                if (!mai.isStatic()) {
                    this.instanceMethods.add(mai.name());
                } else {
                    this.classMethods.add(mai.name());
                }
                this.methodsMulti.put(m.getName(), mai);
            }
        }
        this.methods = Lists.list(this.methodsMulti.values());
        this.annotationMap = Annotations.getAnnotationDataForClassAsMap(cls);
        this.annotations = Annotations.getAnnotationDataForClass(cls);
    }

    public static <T> ClassMeta<T> classMeta(Class<T> aClass) {
        ClassMeta<Object> meta = Reflection.context()._classMetaMap.get(aClass);
        if (meta == null) {
            meta = new ClassMeta<T>(aClass);
            Reflection.context()._classMetaMap.put(aClass, meta);
        }
        return meta;
    }

    public static ClassMeta<?> classMetaUnTyped(Class<?> aClass) {
        ClassMeta<?> meta = Reflection.context()._classMetaMap.get(aClass);
        if (meta == null) {
            meta = new ClassMeta(aClass);
            Reflection.context()._classMetaMap.put(aClass, meta);
        }
        return meta;
    }

    public static ClassMeta classMetaEither(Object obj) {
        if (obj instanceof Class) {
            return ClassMeta.classMeta((Class)obj);
        }
        return ClassMeta.classMeta(obj.getClass());
    }

    public MethodAccess method(String name) {
        return this.methodMap.get(name);
    }

    public Iterable<MethodAccess> methods(String name) {
        return this.methodsMulti.getAll(name);
    }

    private List<Class<?>> getBaseClassesSuperFirst(Class<?> cls) {
        if (!cls.isInterface()) {
            ArrayList classes = new ArrayList(10);
            for (Class<?> currentClass = cls; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                classes.add(currentClass);
            }
            Collections.reverse(classes);
            return classes;
        }
        List<Class<?>> classes = Lists.list(cls.getInterfaces());
        classes.add(cls);
        return classes;
    }

    public Map<String, FieldAccess> fieldMap() {
        return this.fieldMap;
    }

    public Map<String, FieldAccess> propertyMap() {
        return this.propertyMap;
    }

    public Iterator<FieldAccess> fields() {
        return this.fields.iterator();
    }

    public Iterable<MethodAccess> methods() {
        return new Iterable<MethodAccess>(){

            @Override
            public Iterator<MethodAccess> iterator() {
                return ClassMeta.this.methods.iterator();
            }
        };
    }

    public Iterator<FieldAccess> properties() {
        return this.properties.iterator();
    }

    public Iterable<ConstructorAccess<T>> constructors() {
        return new Iterable<ConstructorAccess<T>>(){

            @Override
            public Iterator<ConstructorAccess<T>> iterator() {
                return ClassMeta.this.constructorAccessSet.iterator();
            }
        };
    }

    public ConstructorAccess<T> noArgConstructor() {
        return this.noArgConstructor;
    }

    public <T> ConstructorAccess<T> declaredConstructor(Class<? extends Object> singleArg) {
        for (ConstructorAccess<T> constructorAccess : this.constructorAccessSet) {
            if (constructorAccess.parameterTypes().length != 1 || !constructorAccess.parameterTypes()[0].isAssignableFrom(singleArg)) continue;
            return constructorAccess;
        }
        return null;
    }

    public List<ConstructorAccess> oneArgumentConstructors() {
        ArrayList<ConstructorAccess> constructors = new ArrayList<ConstructorAccess>();
        for (ConstructorAccess<T> constructorAccess : this.constructorAccessSet) {
            if (constructorAccess.parameterTypes().length != 1) continue;
            constructors.add(constructorAccess);
        }
        return constructors;
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return new Iterable<AnnotationData>(){

            @Override
            public Iterator<AnnotationData> iterator() {
                return ClassMeta.this.annotations.iterator();
            }
        };
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    public boolean respondsTo(String methodName) {
        return this.methodMap.containsKey(methodName);
    }

    public boolean respondsTo(String methodName, Class<?> ... types) {
        Iterable<MethodAccess> methods = this.methodsMulti.getAll(methodName);
        for (MethodAccess methodAccess : methods) {
            if (methodAccess.isStatic() || !methodAccess.respondsTo(types)) continue;
            return true;
        }
        return false;
    }

    public boolean respondsTo(String methodName, Object ... args) {
        Iterable<MethodAccess> methods = this.methodsMulti.getAll(methodName);
        for (MethodAccess methodAccess : methods) {
            if (methodAccess.isStatic() || !methodAccess.respondsTo(args)) continue;
            return true;
        }
        return false;
    }

    public boolean respondsTo(String methodName, List list) {
        Object[] args = list.toArray(new Object[list.size()]);
        return this.respondsTo(methodName, args);
    }

    public boolean handles(Class<?> interfaceMethods) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = interfaceMethods.getDeclaredMethods()) {
            if (this.respondsTo(method.getName(), method.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    public Object invoke(T instance, String methodName, Object ... args) {
        return this.methodMap.get(methodName).invoke(instance, args);
    }

    public Object invokeUntyped(Object instance, String methodName, Object ... args) {
        return this.methodMap.get(methodName).invoke(instance, args);
    }

    public MethodAccess invokeMethodAccess(String methodName) {
        return this.methodMap.get(methodName);
    }

    public Object invokeStatic(String methodName, Object ... args) {
        return this.methodMap.get(methodName).invokeStatic(args);
    }

    public Object invoke(T instance, String methodName, List<?> args) {
        Object[] array = args.toArray(new Object[args.size()]);
        return this.methodMap.get(methodName).invoke(instance, array);
    }

    public boolean invokePredicate(Object instance, Object arg) {
        MethodAccess methodAccess = null;
        methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("test");
        return (Boolean)methodAccess.invoke(instance, arg);
    }

    public Object invokeReducer(Object instance, Object sum, Object value) {
        MethodAccess methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("test");
        Class<?> arg1 = methodAccess.parameterTypes()[0];
        if (Typ.isPrimitiveNumber(arg1) && sum == null) {
            return methodAccess.invoke(instance, 0, value);
        }
        return methodAccess.invoke(instance, sum, value);
    }

    public Object invokeFunction(Object instance, Object arg) {
        MethodAccess methodAccess = this.invokeFunctionMethodAccess();
        return methodAccess.invoke(instance, arg);
    }

    public MethodAccess invokeFunctionMethodAccess() {
        if (this.methods.size() == 1) {
            return this.methods.get(0).methodAccess();
        }
        return this.methodMap.get("apply").methodAccess();
    }

    public String name() {
        return this.cls.getSimpleName();
    }

    public ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(Object object) {
        MethodAccess methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("reduce");
        ConstantCallSite methodHandle = methodAccess.invokeReducerLongIntReturnLongMethodHandle(object);
        return methodHandle;
    }

    public ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(Object object, String methodName) {
        MethodAccess methodAccess = this.methodMap.get(methodName);
        ConstantCallSite methodHandle = methodAccess.invokeReducerLongIntReturnLongMethodHandle(object);
        return methodHandle;
    }

    public Method invokeReducerLongIntReturnLongMethod(Object object) {
        MethodAccess methodAccess = this.methods.size() == 1 ? this.methods.get(0) : this.methodMap.get("reduce");
        return methodAccess.method();
    }

    public Method invokeReducerLongIntReturnLongMethod(Object object, String methodName) {
        MethodAccess methodAccess = this.methodMap.get(methodName);
        return methodAccess.method();
    }
}

