/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.core.Sys;
import org.boon.core.reflection.AnnotationData;

public class Annotations {
    private static final Context _context;
    private static WeakReference<Context> weakContext;

    private static Context context() {
        if (_context != null) {
            return _context;
        }
        Context context = (Context)weakContext.get();
        if (context == null) {
            context = new Context();
            weakContext = new WeakReference<Context>(context);
        }
        return context;
    }

    public static List<AnnotationData> getAnnotationDataForProperty(Class<?> clazz, String propertyName, boolean useReadMethod, Set<String> allowedPackages) {
        List annotationDataList;
        Map cacheProperty = Annotations.context().annotationDataCacheProperty;
        ConcurrentHashMap<String, List> classMap = (ConcurrentHashMap<String, List>)cacheProperty.get(clazz);
        if (classMap == null) {
            classMap = new ConcurrentHashMap<String, List>();
            cacheProperty.put(clazz, classMap);
        }
        if ((annotationDataList = (List)classMap.get(propertyName)) == null) {
            annotationDataList = Annotations.extractValidationAnnotationData(Annotations.extractAllAnnotationsForProperty(clazz, propertyName, useReadMethod), allowedPackages);
            if (annotationDataList == null) {
                annotationDataList = Collections.EMPTY_LIST;
            }
            classMap.put(propertyName, annotationDataList);
        }
        return annotationDataList;
    }

    public static List<AnnotationData> getAnnotationDataForField(Class<?> clazz, String propertyName, Set<String> allowedPackages) {
        List annotationDataList;
        Map cacheProperty = Annotations.context().annotationDataCacheField;
        ConcurrentHashMap<String, List> classMap = (ConcurrentHashMap<String, List>)cacheProperty.get(clazz);
        if (classMap == null) {
            classMap = new ConcurrentHashMap<String, List>();
            cacheProperty.put(clazz, classMap);
        }
        if ((annotationDataList = (List)classMap.get(propertyName)) == null) {
            annotationDataList = Annotations.extractValidationAnnotationData(Annotations.findFieldAnnotations(clazz, propertyName), allowedPackages);
            if (annotationDataList == null) {
                annotationDataList = Collections.EMPTY_LIST;
            }
            classMap.put(propertyName, annotationDataList);
        }
        return annotationDataList;
    }

    public static List<AnnotationData> getAnnotationDataForClass(Class<?> clazz) {
        return Annotations.getAnnotationDataForClass(clazz, Collections.EMPTY_SET);
    }

    public static List<AnnotationData> getAnnotationDataForMethod(Method method) {
        List<AnnotationData> list = Annotations.extractValidationAnnotationData(method.getDeclaredAnnotations(), Collections.EMPTY_SET);
        return list;
    }

    public static List<AnnotationData> getAnnotationDataForMethod(Constructor method) {
        List<AnnotationData> list = Annotations.extractValidationAnnotationData(method.getDeclaredAnnotations(), Collections.EMPTY_SET);
        return list;
    }

    public static Map<String, AnnotationData> getAnnotationDataForClassAsMap(Class<?> clazz) {
        Map cache = Annotations.context().annotationDataCacheClassAsMap;
        ConcurrentHashMap<String, AnnotationData> map = (ConcurrentHashMap<String, AnnotationData>)cache.get(clazz);
        if (map == null) {
            List<AnnotationData> list = Annotations.getAnnotationDataForClass(clazz);
            if (list.size() == 0) {
                map = Collections.EMPTY_MAP;
            } else {
                map = new ConcurrentHashMap<String, AnnotationData>(list.size());
                for (AnnotationData data : list) {
                    map.put(data.getFullClassName(), data);
                    map.put(data.getSimpleClassName(), data);
                    map.put(data.getName(), data);
                }
            }
            cache.put(clazz, map);
        }
        return map;
    }

    public static List<AnnotationData> getAnnotationDataForClass(Class<?> clazz, Set<String> allowedPackages) {
        Map cache = Annotations.context().annotationDataCacheClass;
        List<AnnotationData> annotationDataList = (List<AnnotationData>)cache.get(clazz);
        if (annotationDataList == null) {
            annotationDataList = Annotations.extractValidationAnnotationData(Annotations.findClassAnnotations(clazz), allowedPackages);
            cache.put(clazz, annotationDataList);
        }
        return annotationDataList;
    }

    private static Annotation[] findClassAnnotations(Class<?> clazz) {
        return clazz.getAnnotations();
    }

    public static Collection<AnnotationData> getAnnotationDataForFieldAndProperty(Class<?> clazz, String propertyName, Set<String> allowedPackages) {
        List<AnnotationData> propertyAnnotationDataList = Annotations.getAnnotationDataForProperty(clazz, propertyName, false, allowedPackages);
        List<AnnotationData> fieldAnnotationDataList = Annotations.getAnnotationDataForField(clazz, propertyName, allowedPackages);
        HashMap<String, AnnotationData> map = new HashMap<String, AnnotationData>(propertyAnnotationDataList.size() + fieldAnnotationDataList.size());
        for (AnnotationData annotationData : propertyAnnotationDataList) {
            map.put(annotationData.getName(), annotationData);
        }
        for (AnnotationData annotationData : fieldAnnotationDataList) {
            map.put(annotationData.getName(), annotationData);
        }
        return map.values();
    }

    public static List<AnnotationData> extractValidationAnnotationData(Annotation[] annotations, Set<String> allowedPackages) {
        ArrayList<AnnotationData> annotationsList = new ArrayList<AnnotationData>();
        for (Annotation annotation : annotations) {
            AnnotationData annotationData = new AnnotationData(annotation, allowedPackages);
            if (!annotationData.isAllowed()) continue;
            annotationsList.add(annotationData);
        }
        return annotationsList;
    }

    private static Annotation[] extractAllAnnotationsForProperty(Class<?> clazz, String propertyName, boolean useRead) {
        try {
            Annotation[] annotations = Annotations.findPropertyAnnotations(clazz, propertyName, useRead);
            if (annotations.length == 0) {
                annotations = Annotations.findPropertyAnnotations(clazz.getSuperclass(), propertyName, useRead);
            }
            return annotations;
        }
        catch (Exception ex) {
            return Exceptions.handle(Annotation[].class, Boon.sputs("Unable to extract annotations for property", propertyName, " of class ", clazz, "  useRead ", useRead), ex);
        }
    }

    private static Annotation[] findPropertyAnnotations(Class<?> clazz, String propertyName, boolean useRead) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = Annotations.getPropertyDescriptor(clazz, propertyName);
        if (propertyDescriptor == null) {
            return new Annotation[0];
        }
        Method accessMethod = null;
        accessMethod = useRead ? propertyDescriptor.getReadMethod() : propertyDescriptor.getWriteMethod();
        if (accessMethod != null) {
            Annotation[] annotations = accessMethod.getAnnotations();
            return annotations;
        }
        return new Annotation[0];
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> type, String propertyName) {
        Exceptions.requireNonNull(type);
        Exceptions.requireNonNull(propertyName);
        if (!propertyName.contains(".")) {
            return Annotations.doGetPropertyDescriptor(type, propertyName);
        }
        String[] propertyNames = propertyName.split("[.]");
        Class<?> clazz = type;
        PropertyDescriptor propertyDescriptor = null;
        for (String pName : propertyNames) {
            propertyDescriptor = Annotations.doGetPropertyDescriptor(clazz, pName);
            if (propertyDescriptor == null) {
                return null;
            }
            clazz = propertyDescriptor.getPropertyType();
        }
        return propertyDescriptor;
    }

    private static Annotation[] findFieldAnnotations(Class<?> clazz, String propertyName) {
        Field field = Annotations.getField(clazz, propertyName);
        if (field == null) {
            return new Annotation[0];
        }
        Annotation[] annotations = field.getAnnotations();
        return annotations;
    }

    private static PropertyDescriptor doGetPropertyDescriptor(Class<?> type, String propertyName) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                if (!pd.getName().equals(propertyName)) continue;
                return pd;
            }
            Class<?> superclass = type.getSuperclass();
            if (superclass != null) {
                return Annotations.doGetPropertyDescriptor(superclass, propertyName);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get property " + propertyName + " for class " + type, ex);
        }
    }

    private static Field getField(Class<?> type, String fieldName) {
        if (!fieldName.contains(".")) {
            return Annotations.doFindFieldInHeirarchy(type, fieldName);
        }
        String[] fieldNames = fieldName.split("[.]");
        Class<?> clazz = type;
        Field field = null;
        for (String fName : fieldNames) {
            field = Annotations.doFindFieldInHeirarchy(clazz, fName);
            if (field == null) {
                return null;
            }
            clazz = field.getType();
        }
        field.setAccessible(true);
        return field;
    }

    private static Field doFindFieldInHeirarchy(Class<?> clazz, String propertyName) {
        Field field = Annotations.doGetField(clazz, propertyName);
        Class<?> sclazz = clazz.getSuperclass();
        if (field == null) {
            do {
                if (sclazz == null) continue;
                field = Annotations.doGetField(sclazz, propertyName);
                sclazz = sclazz.getSuperclass();
            } while (field == null && sclazz != null);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Field doGetField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException se) {
            field = null;
        }
        catch (NoSuchFieldException nsfe) {
            field = null;
        }
        if (field == null) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (!f.getName().equals(fieldName)) continue;
                field = f;
            }
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Object contextToHold() {
        return Annotations.context();
    }

    static {
        weakContext = new WeakReference<Object>(null);
        boolean noStatics = Boolean.getBoolean("org.boon.noStatics");
        if (noStatics || Sys.inContainer()) {
            _context = null;
            weakContext = new WeakReference<Context>(new Context());
        } else {
            _context = new Context();
        }
    }

    private static class Context {
        private Map<Class<?>, Map<String, List<AnnotationData>>> annotationDataCacheProperty = new ConcurrentHashMap();
        private Map<Class<?>, Map<String, List<AnnotationData>>> annotationDataCacheField = new ConcurrentHashMap();
        private Map<Class<?>, List<AnnotationData>> annotationDataCacheClass = new ConcurrentHashMap();
        private Map<Class<?>, Map<String, AnnotationData>> annotationDataCacheClassAsMap = new ConcurrentHashMap();

        private Context() {
        }
    }
}

