/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicReference;
import org.boon.Lists;
import org.boon.Str;
import org.boon.core.Conversions;
import org.boon.core.reflection.Annotations;
import org.boon.core.reflection.Reflection;
import org.boon.core.timer.TimeKeeper;
import org.boon.core.timer.TimeKeeperBasic;
import org.boon.logging.Logging;

public class Sys {
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final boolean inContainer;
    private static final boolean is1_7OorLater;
    private static final int buildNumber;
    private static final BigDecimal version;
    private static final boolean is1_7;
    private static final boolean is1_8;
    static final AtomicReference<TimeKeeper> timer;

    public static void println(String message) {
        System.out.println(message);
    }

    public static void print(String message) {
        System.out.print(message);
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean is1_7OrLater() {
        return is1_7OorLater;
    }

    public static boolean is1_7() {
        return is1_7;
    }

    public static boolean is1_8() {
        return is1_8;
    }

    public static int buildNumber() {
        return buildNumber;
    }

    public static char windowsPathSeparator() {
        return '\\';
    }

    public static TimeKeeper timer() {
        return timer.get();
    }

    public static long time() {
        return timer.get().time();
    }

    private static boolean detectContainer() {
        boolean _inContainer;
        try {
            Class.forName("javax.servlet.http.HttpServlet");
            _inContainer = true;
        }
        catch (ClassNotFoundException e) {
            _inContainer = false;
        }
        if (!_inContainer) {
            try {
                Class.forName("javax.ejb.EJBContext");
                _inContainer = true;
            }
            catch (ClassNotFoundException e) {
                _inContainer = false;
            }
        }
        return _inContainer;
    }

    public static boolean inContainer() {
        return inContainer;
    }

    public static Object contextToHold() {
        return Lists.list(Reflection.contextToHold(), Annotations.contextToHold(), Logging.contextToHold());
    }

    public static String sysProp(String key) {
        return Sys.sysProp(key, null);
    }

    public static String sysProp(String key, Object defaultValue) {
        String property = System.getProperty(key, null);
        if (property == null) {
            property = System.getenv(key);
        }
        if (property == null) {
            String newKey = Str.underBarCase(key);
            property = System.getenv(newKey);
        }
        if (property == null) {
            return Conversions.toString(defaultValue);
        }
        return property;
    }

    public static String putSysProp(String key, Object value) {
        return System.setProperty(key, Conversions.toString(value));
    }

    public static boolean hasSysProp(String propertyName) {
        return System.getProperties().containsKey(propertyName);
    }

    static {
        BigDecimal v = new BigDecimal("-1");
        int b = -1;
        String sversion = System.getProperty("java.version");
        if (sversion.indexOf("_") != -1) {
            String[] split = sversion.split("_");
            try {
                String ver = split[0];
                if (ver.startsWith("1.8")) {
                    v = new BigDecimal("1.8");
                }
                if (ver.startsWith("1.7")) {
                    v = new BigDecimal("1.7");
                }
                if (ver.startsWith("1.6")) {
                    v = new BigDecimal("1.6");
                }
                if (ver.startsWith("1.5")) {
                    v = new BigDecimal("1.5");
                }
                if (ver.startsWith("1.9")) {
                    v = new BigDecimal("1.9");
                }
                b = Integer.parseInt(split[1]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Unable to determine build number or version");
            }
        } else if ("1.8.0".equals(sversion)) {
            b = -1;
            v = new BigDecimal("1.8");
        } else {
            v = new BigDecimal(sversion);
            b = -1;
        }
        buildNumber = b;
        version = v;
        is1_7OorLater = version.compareTo(new BigDecimal("1.7")) >= 0;
        is1_7 = version.compareTo(new BigDecimal("1.7")) == 0;
        is1_8 = version.compareTo(new BigDecimal("1.8")) == 0;
        timer = new AtomicReference<TimeKeeperBasic>(new TimeKeeperBasic());
        boolean forceInContainer = Boolean.parseBoolean(System.getProperty("org.boon.forceInContainer", "false"));
        boolean forceNoContainer = Boolean.parseBoolean(System.getProperty("org.boon.forceNoContainer", "false"));
        boolean _inContainer = forceNoContainer ? false : (forceInContainer ? true : Sys.detectContainer());
        inContainer = _inContainer;
    }
}

