/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.boon.Exceptions;
import org.boon.Functional;
import org.boon.IO;
import org.boon.Lists;
import org.boon.Logger;
import org.boon.Maps;
import org.boon.Str;
import org.boon.config.ContextConfigReader;
import org.boon.core.Conversions;
import org.boon.core.Sys;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.di.Context;
import org.boon.json.JsonFactory;
import org.boon.logging.LogLevel;
import org.boon.logging.Logging;
import org.boon.logging.TerminalLogger;
import org.boon.primitive.CharBuf;
import org.boon.template.BoonTemplate;

public class Boon {
    public static final String BOON_SYSTEM_CONF_DIR = "BOON_SYSTEM_CONF_DIR";
    private static AtomicBoolean debug = new AtomicBoolean(false);
    private static final Logger logger = Sys.inContainer() ? null : Boon.configurableLogger(Boon.class);

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void println(String message) {
        Sys.println(message);
    }

    public static void println() {
        Sys.println("");
    }

    public static void println(Object message) {
        Boon.print(message);
        Boon.println();
    }

    public static void print(String message) {
        Sys.print(message);
    }

    public static void print(Object message) {
        if (message == null) {
            Boon.print("<NULL>");
        } else if (message instanceof char[]) {
            Boon.print(FastStringUtils.noCopyStringFromChars((char[])message));
        } else if (message.getClass().isArray()) {
            Boon.print(Lists.toListOrSingletonList(message).toString());
        } else {
            Boon.print(message.toString());
        }
    }

    public static void puts(Object ... messages) {
        for (Object message : messages) {
            Boon.print(message);
            Boon.print(Character.valueOf(' '));
        }
        Boon.println();
    }

    public static void putc(Object context, Object ... messages) {
        for (Object message : messages) {
            if (message instanceof CharSequence) {
                String transformedMessage = Boon.jstl(message.toString(), context);
                Boon.print(message);
            } else {
                Boon.print(message);
            }
            Boon.print(Character.valueOf(' '));
        }
        Boon.println();
    }

    public static void puth(Object context, Object ... messages) {
        for (Object message : messages) {
            if (message instanceof CharSequence) {
                String transformedMessage = Boon.handlebars(message.toString(), context);
                Boon.print(message);
            } else {
                Boon.print(message);
            }
            Boon.print(Character.valueOf(' '));
        }
        Boon.println();
    }

    public static void putl(Object ... messages) {
        for (Object message : messages) {
            if (message instanceof Collection || Typ.isArray(message)) {
                Iterator iterator = Conversions.iterator(message);
                while (iterator.hasNext()) {
                    Boon.puts(iterator.next());
                }
                continue;
            }
            Boon.print(message);
            Boon.println();
        }
        Boon.println();
    }

    public static String sputl(Object ... messages) {
        CharBuf buf = CharBuf.create(100);
        return Boon.sputl(buf, messages).toString();
    }

    public static String sputs(Object ... messages) {
        CharBuf buf = CharBuf.create(80);
        return Boon.sputs(buf, messages).toString();
    }

    public static CharBuf sputl(CharBuf buf, Object ... messages) {
        for (Object message : messages) {
            if (message == null) {
                buf.add("<NULL>");
            } else if (message.getClass().isArray()) {
                buf.add(Lists.toListOrSingletonList(message).toString());
            } else {
                buf.add(message.toString());
            }
            buf.add('\n');
        }
        buf.add('\n');
        return buf;
    }

    public static CharBuf sputs(CharBuf buf, Object ... messages) {
        int index = 0;
        for (Object message : messages) {
            if (index != 0) {
                buf.add(' ');
            }
            ++index;
            if (message == null) {
                buf.add("<NULL>");
                continue;
            }
            if (message.getClass().isArray()) {
                buf.add(Lists.toListOrSingletonList(message).toString());
                continue;
            }
            buf.add(message.toString());
        }
        buf.add('\n');
        return buf;
    }

    public static StringBuilder sputs(StringBuilder buf, Object ... messages) {
        int index = 0;
        for (Object message : messages) {
            if (index != 0) {
                buf.append(' ');
            }
            ++index;
            if (message == null) {
                buf.append("<NULL>");
                continue;
            }
            if (message.getClass().isArray()) {
                buf.append(Lists.toListOrSingletonList(message).toString());
                continue;
            }
            buf.append(message.toString());
        }
        buf.append('\n');
        return buf;
    }

    public static boolean isArray(Object obj) {
        return Typ.isArray(obj);
    }

    public static int len(Object obj) {
        return Conversions.len(obj);
    }

    public static Iterator iterator(Object o) {
        return Conversions.iterator(o);
    }

    public static String joinBy(char delim, Object ... args) {
        CharBuf builder = CharBuf.create(256);
        int index = 0;
        for (Object arg : args) {
            builder.add(arg.toString());
            if (index != args.length - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }

    public static String joinBy(char delim, Collection<?> collection) {
        CharBuf builder = CharBuf.create(256);
        int index = 0;
        int size = collection.size();
        for (Object arg : collection) {
            builder.add(arg.toString());
            if (index != size - 1) {
                builder.add(delim);
            }
            ++index;
        }
        return builder.toString();
    }

    public static String joinBy(char delim, Iterable<?> iterable) {
        CharBuf builder = CharBuf.create(256);
        int index = 0;
        for (Object arg : iterable) {
            builder.add(arg.toString());
            builder.add(delim);
            ++index;
        }
        if (index > 1) {
            builder.removeLastChar();
        }
        return builder.toString();
    }

    public static List<?> mapBy(Iterable<?> objects, Object function) {
        return Lists.mapBy(objects, function);
    }

    public static void each(Iterable<?> objects, Object function) {
        Functional.each(objects, function);
    }

    public static String toJson(Object value) {
        return JsonFactory.toJson(value);
    }

    public static Object fromJson(String value) {
        return JsonFactory.fromJson(value);
    }

    public static <T> T fromJson(String value, Class<T> clazz) {
        return JsonFactory.fromJson(value, clazz);
    }

    public static Object atIndex(Object value, String path) {
        return BeanUtils.idx(value, path);
    }

    public static String gets() {
        Scanner console = new Scanner(System.in);
        String input = console.nextLine();
        return input.trim();
    }

    public static String jstl(String template, Object context) {
        return BoonTemplate.jstl().replace(template, context).toString();
    }

    public static String handlebars(String template, Object context) {
        return BoonTemplate.template().replace(template, context).toString();
    }

    public static String add(String ... args) {
        return Str.add(args);
    }

    public static String stringAtIndex(Object value, String path) {
        return Conversions.toString(BeanUtils.idx(value, path));
    }

    public static Object call(Object value, String method) {
        if (value instanceof Class) {
            return Invoker.invoke((Class)value, method, new Object[0]);
        }
        return Invoker.invoke(value, method, new Object[0]);
    }

    public static String sliceOf(String string, int start, int stop) {
        return Str.sliceOf(string, start, stop);
    }

    public static String sliceOf(String string, int start) {
        return Str.sliceOf(string, start);
    }

    public static String endSliceOf(String string, int end) {
        return Str.endSliceOf(string, end);
    }

    public static Context readConfig(String namespace, String path) {
        String localConfigDir = Boon.add(System.getProperty("user.home"), "/.", Str.camelCaseLower(Str.underBarCase(namespace)));
        return Boon.readConfig(namespace, path, "classpath:/", localConfigDir, Boon.sysProp(BOON_SYSTEM_CONF_DIR, "/etc/"));
    }

    public static Context readConfig(String namespace, String path, String ... roots) {
        Boon.trace("readConfig(namespace, path, roots)", "IN", namespace, path, roots);
        if (path.startsWith("/")) {
            path = Boon.sliceOf(path, 1);
        }
        if (!path.endsWith(".json") && !path.endsWith("/")) {
            path = Boon.add(path, "/");
        }
        ContextConfigReader contextConfigReader = ContextConfigReader.config().namespace(namespace);
        for (String root : roots) {
            if (!root.endsWith("/")) {
                root = Boon.add(root, "/");
            }
            Boon.debug("readConfig", "adding root", root);
            contextConfigReader.resource(Boon.add(root, path));
        }
        Boon.trace("readConfig(namespace, path, roots)", "OUT", namespace, path, roots);
        return contextConfigReader.read();
    }

    public static String sysProp(String propertyName, Object defaultValue) {
        return Sys.sysProp(propertyName, defaultValue);
    }

    public static boolean hasSysProp(String propertyName) {
        return Sys.hasSysProp(propertyName);
    }

    public static void putSysProp(String propertyName, Object value) {
        Sys.putSysProp(propertyName, value);
    }

    public static Context readConfig() {
        return Boon.readConfig(Boon.sysProp("BOON.APP.NAMESPACE", "boon.app"), Boon.sysProp("BOON.APP.CONFIG.PATH", "boon/app"));
    }

    public static void pressEnterKey(String pressEnterKeyMessage) {
        Boon.puts(pressEnterKeyMessage);
        Boon.gets();
    }

    public static void pressEnterKey() {
        Boon.puts("Press enter key to continue");
        Boon.gets();
    }

    public static boolean respondsTo(Object object, String method) {
        if (object instanceof Class) {
            return Reflection.respondsTo((Class)object, method);
        }
        return Reflection.respondsTo(object, method);
    }

    public static String resource(String path) {
        if (!IO.exists(IO.path(path))) {
            path = Boon.add("classpath:/", path);
        }
        String str = IO.read(path);
        return str;
    }

    public static String resource(Path path) {
        String str = IO.read(path);
        return str;
    }

    public static String resourceFromHandleBarsTemplate(String path, Object context) {
        String str;
        if (!IO.exists(IO.path(path))) {
            path = Boon.add("classpath:/", path);
        }
        if ((str = IO.read(path)) != null) {
            str = Boon.handlebars(str, context);
        }
        return str;
    }

    public static String resourceFromHandleBarsTemplate(Path path, Object context) {
        String str = IO.read(path);
        if (str != null) {
            str = Boon.handlebars(str, context);
        }
        return str;
    }

    public static String resourceFromTemplate(String path, Object context) {
        String str;
        if (!IO.exists(IO.path(path))) {
            path = Boon.add("classpath:/", path);
        }
        if ((str = IO.read(path)) != null) {
            str = Boon.jstl(str, context);
        }
        return str;
    }

    public static String resourceFromTemplate(Path path, Object context) {
        String str = IO.read(path);
        if (str != null) {
            str = Boon.jstl(str, context);
        }
        return str;
    }

    public static Object jsonResource(String path) {
        String str;
        if (!IO.exists(IO.path(path))) {
            path = Boon.add("classpath:/", path);
        }
        if ((str = IO.read(path)) != null) {
            return Boon.fromJson(str);
        }
        return null;
    }

    public static Object jsonResource(Path path) {
        String str = IO.read(path);
        if (str != null) {
            return Boon.fromJson(str);
        }
        return null;
    }

    public static Object jsonResourceFromTemplate(String path, Object context) {
        String str;
        if (!IO.exists(IO.path(path))) {
            path = Boon.add("classpath:/", path);
        }
        if ((str = IO.read(path)) != null) {
            str = Boon.jstl(str, context);
            return Boon.fromJson(str);
        }
        return null;
    }

    public static Object jsonResourceFromTemplate(Path path, Object context) {
        String str = IO.read(path);
        if (str != null) {
            str = Boon.jstl(str, context);
            return Boon.fromJson(str);
        }
        return null;
    }

    public static Map<String, Object> resourceMap(String path) {
        return (Map)Boon.jsonResource(path);
    }

    public static Map<String, Object> resourceMap(Path path) {
        return (Map)Boon.jsonResource(path);
    }

    public static Map<String, Object> resourceMapFromTemplate(String path, Object context) {
        return (Map)Boon.jsonResourceFromTemplate(path, context);
    }

    public static Map<String, Object> resourceMapFromTemplate(Path path, Object context) {
        return (Map)Boon.jsonResourceFromTemplate(path, context);
    }

    public static <T> T resourceObject(String path, Class<T> type) {
        return Maps.fromMap(Boon.resourceMap(path), type);
    }

    public static <T> T resourceObject(Path path, Class<T> type) {
        return Maps.fromMap(Boon.resourceMap(path), type);
    }

    public static <T> T resourceObjectFromTemplate(String path, Class<T> type, Object context) {
        return Maps.fromMap(Boon.resourceMapFromTemplate(path, context), type);
    }

    public static <T> T resourceObjectFromTemplate(Path path, Class<T> type, Object context) {
        return Maps.fromMap(Boon.resourceMapFromTemplate(path, context), type);
    }

    public static List<?> resourceList(String path) {
        return (List)Boon.jsonResource(path);
    }

    public static List<?> resourceList(Path path) {
        return (List)Boon.jsonResource(path);
    }

    public static <T> List<T> resourceListFromTemplate(String path, Class<T> listOf, Object context) {
        List list = (List)Boon.jsonResourceFromTemplate(path, context);
        return MapObjectConversion.convertListOfMapsToObjects(true, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), listOf, list, Collections.EMPTY_SET);
    }

    public static <T> List<T> resourceListFromTemplate(Path path, Class<T> listOf, Object context) {
        List list = (List)Boon.jsonResourceFromTemplate(path, context);
        return MapObjectConversion.convertListOfMapsToObjects(true, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), listOf, list, Collections.EMPTY_SET);
    }

    public static <T> List<T> resourceList(String path, Class<T> listOf) {
        List list = (List)Boon.jsonResource(path);
        return MapObjectConversion.convertListOfMapsToObjects(true, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), listOf, list, Collections.EMPTY_SET);
    }

    public static <T> List<T> resourceList(Path path, Class<T> listOf) {
        List list = (List)Boon.jsonResource(path);
        return MapObjectConversion.convertListOfMapsToObjects(true, null, FieldAccessMode.FIELD_THEN_PROPERTY.create(true), listOf, list, Collections.EMPTY_SET);
    }

    public static List<?> resourceListFromTemplate(String path, Object context) {
        return (List)Boon.jsonResourceFromTemplate(path, context);
    }

    public static List<?> resourceListFromTemplate(Path path, Object context) {
        return (List)Boon.jsonResourceFromTemplate(path, context);
    }

    public static String className(Object object) {
        return object == null ? "CLASS<NULL>" : object.getClass().getName();
    }

    public static String simpleName(Object object) {
        return object == null ? "CLASS<NULL>" : object.getClass().getSimpleName();
    }

    public static Logger logger(Class<?> clazz) {
        return new Logger(Logging.logger(clazz));
    }

    public static Logger logger(String name) {
        return new Logger(Logging.logger(name));
    }

    public static Logger configurableLogger(String name) {
        return new Logger(Logging.configurableLogger(name));
    }

    public static Logger configurableLogger(Class<?> clazz) {
        return new Logger(Logging.configurableLogger(clazz.getName()));
    }

    public static boolean debugOn() {
        return debug.get();
    }

    public static void turnDebugOn() {
        debug.set(true);
    }

    public static void turnDebugOff() {
        debug.set(false);
    }

    private static Logger _log() {
        if (Boon.debugOn()) {
            return new Logger(new TerminalLogger().level(LogLevel.DEBUG));
        }
        return logger == null ? Boon.configurableLogger("BOON.SYSTEM") : logger;
    }

    public static boolean logInfoOn() {
        return Boon._log().infoOn();
    }

    public static boolean logTraceOn() {
        return Boon._log().traceOn();
    }

    public static boolean logDebugOn() {
        return Boon._log().debugOn();
    }

    public static void fatal(Object ... messages) {
        Boon._log().fatal(messages);
    }

    public static void error(Object ... messages) {
        Boon._log().error(messages);
    }

    public static void warn(Object ... messages) {
        Boon._log().warn(messages);
    }

    public static void info(Object ... messages) {
        Boon._log().info(messages);
    }

    public static void debug(Object ... messages) {
        Boon._log().debug(messages);
    }

    public static void trace(Object ... messages) {
        Boon._log().trace(messages);
    }

    public static void config(Object ... messages) {
        Boon._log().config(messages);
    }

    public static void fatal(Throwable t, Object ... messages) {
        Boon._log().fatal(t, messages);
    }

    public static void error(Throwable t, Object ... messages) {
        Boon._log().error(t, messages);
    }

    public static void warn(Throwable t, Object ... messages) {
        Boon._log().warn(t, messages);
    }

    public static void info(Throwable t, Object ... messages) {
        Boon._log().info(t, messages);
    }

    public static void config(Throwable t, Object ... messages) {
        Boon._log().config(t, messages);
    }

    public static void debug(Throwable t, Object ... messages) {
        Boon._log().debug(t, messages);
    }

    public static void trace(Throwable t, Object ... messages) {
        Boon._log().trace(t, messages);
    }

    public static boolean equalsOrDie(Object expected, Object got) {
        if (expected == null && got != null) {
            Exceptions.die();
        }
        if (!expected.equals(got)) {
            Exceptions.die("Expected was", expected, "but we got", got);
        }
        return true;
    }
}

