/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.Invoker;

public class Flt {
    public static float[] grow(float[] array, int size) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static float[] grow(float[] array) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static float[] shrink(float[] array, int size) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static float[] compact(float[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (float ch : array) {
            if (ch != 0.0f) continue;
            ++nullCount;
        }
        float[] newArray = new float[array.length - nullCount];
        int j = 0;
        for (float ch : array) {
            if (ch == 0.0f) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static float[] arrayOfFloat(int size) {
        return new float[size];
    }

    @Universal
    public static float[] array(float ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int lengthOf(float[] array) {
        return Flt.len(array);
    }

    @Universal
    public static int len(float[] array) {
        return array.length;
    }

    @Universal
    public static float atIndex(float[] array, int index) {
        return Flt.idx(array, index);
    }

    @Universal
    public static float idx(float[] array, int index) {
        int i = Flt.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void atIndex(float[] array, int index, float value) {
        Flt.idx(array, index, value);
    }

    @Universal
    public static void idx(float[] array, int index, float value) {
        int i = Flt.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static float[] sliceOf(float[] array, int startIndex, int endIndex) {
        return Flt.slc(array, startIndex, endIndex);
    }

    @Universal
    public static float[] slc(float[] array, int startIndex, int endIndex) {
        int start = Flt.calculateIndex(array, startIndex);
        int end = Flt.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static float[] sliceOf(float[] array, int startIndex) {
        return Flt.slc(array, startIndex);
    }

    @Universal
    public static float[] slc(float[] array, int startIndex) {
        int start = Flt.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static float[] endOfSlice(float[] array, int endIndex) {
        return Flt.slcEnd(array, endIndex);
    }

    @Universal
    public static float[] slcEnd(float[] array, int endIndex) {
        int end = Flt.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        float[] newArray = new float[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(float value, float[] array) {
        for (float currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static float[] copy(float[] array) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static float[] add(float[] array, float v) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static float[] add(float[] array, float[] array2) {
        Exceptions.requireNonNull(array);
        float[] newArray = new float[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static float[] insert(float[] array, int idx, float v) {
        if (idx >= array.length) {
            return Flt.add(array, v);
        }
        int index = Flt.calculateIndex(array, idx);
        float[] newArray = new float[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static float[] insert(float[] array, int fromIndex, float[] values) {
        Exceptions.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Flt.add(array, values);
        }
        int index = Flt.calculateIndex(array, fromIndex);
        float[] newArray = new float[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(float[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(float[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static boolean equalsOrDie(float[] expected, float[] got) {
        if (expected.length != got.length) {
            Exceptions.die("Lengths did not match, expected length", expected.length, "but got", got.length);
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            Exceptions.die("value at index did not match index", index, "expected value", Float.valueOf(expected[index]), "but got", Float.valueOf(got[index]));
        }
        return true;
    }

    public static boolean equals(float[] expected, float[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static double reduceBy(float[] array, ReduceBy reduceBy) {
        double sum = 0.0;
        for (float v : array) {
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static double reduceBy(float[] array, int start, int length, ReduceBy reduceBy) {
        double sum = 0.0;
        for (int index = start; index < length; ++index) {
            float v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static double reduceBy(float[] array, int length, ReduceBy reduceBy) {
        double sum = 0.0;
        for (int index = 0; index < length; ++index) {
            float v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static <T> double reduceBy(float[] array, T object) {
        if (object.getClass().isAnonymousClass()) {
            return Flt.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (float v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Flt.reduceByR(array, object);
        }
    }

    public static <T> double reduceBy(float[] array, T object, String methodName) {
        if (object.getClass().isAnonymousClass()) {
            return Flt.reduceByR(array, object, methodName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object, methodName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (float v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Flt.reduceByR(array, object, methodName);
        }
    }

    private static <T> double reduceByR(float[] array, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            double sum = 0.0;
            for (float v : array) {
                sum = (Double)method.invoke(object, sum, Float.valueOf(v));
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(float[] array, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            double sum = 0.0;
            for (float v : array) {
                sum = (Double)method.invoke(object, sum, Float.valueOf(v));
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(float[] array, int length, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            double sum = 0.0;
            for (int index = 0; index < length; ++index) {
                float v = array[index];
                sum = (Double)method.invoke(object, sum, Float.valueOf(v));
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(float[] array, int length, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            double sum = 0.0;
            for (int index = 0; index < length; ++index) {
                float v = array[index];
                sum = (Double)method.invoke(object, sum, Float.valueOf(v));
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    public static double reduceBy(float[] array, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Flt.reduceByR(array, length, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = 0; index < length; ++index) {
                    float v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Flt.reduceByR(array, length, object);
        }
    }

    public static double reduceBy(float[] array, int length, Object function, String functionName) {
        if (function.getClass().isAnonymousClass()) {
            return Flt.reduceByR(array, length, function, functionName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(function, functionName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = 0; index < length; ++index) {
                    float v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Flt.reduceByR(array, length, function, functionName);
        }
    }

    public static double reduceBy(float[] array, int start, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Flt.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = start; index < length; ++index) {
                    float v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Flt.reduceByR(array, object);
        }
    }

    public static boolean equalsOrDie(float expected, float got) {
        if (expected != got) {
            return Exceptions.die(Boolean.class, "Expected was", Float.valueOf(expected), "but we got ", Float.valueOf(got));
        }
        return true;
    }

    public static boolean equals(float expected, float got) {
        return expected == got;
    }

    public static double sum(float[] values) {
        return Flt.sum(values, 0, values.length);
    }

    public static float sum(float[] values, int length) {
        return Flt.sum(values, 0, length);
    }

    public static float sum(float[] values, int start, int length) {
        double sum = 0.0;
        for (int index = start; index < length; ++index) {
            sum += (double)values[index];
        }
        if (sum < (double)1.4E-45f) {
            Exceptions.die("overflow the sum is too small", sum);
        }
        if (sum > 3.4028234663852886E38) {
            Exceptions.die("overflow the sum is too big", sum);
        }
        return (float)sum;
    }

    public static double bigSum(float[] values) {
        return Flt.bigSum(values, 0, values.length);
    }

    public static double bigSum(float[] values, int length) {
        return Flt.bigSum(values, 0, length);
    }

    public static double bigSum(float[] values, int start, int length) {
        double sum = 0.0;
        for (int index = start; index < length; ++index) {
            sum += (double)values[index];
        }
        return sum;
    }

    public static float max(float[] values, int start, int length) {
        float max = Float.MIN_VALUE;
        for (int index = start; index < length; ++index) {
            if (!(values[index] > max)) continue;
            max = values[index];
        }
        return max;
    }

    public static float max(float[] values) {
        return Flt.max(values, 0, values.length);
    }

    public static float max(float[] values, int length) {
        return Flt.max(values, 0, length);
    }

    public static float min(float[] values, int start, int length) {
        float min = Float.MAX_VALUE;
        for (int index = start; index < length; ++index) {
            if (!(values[index] < min)) continue;
            min = values[index];
        }
        return min;
    }

    public static float min(float[] values) {
        return Flt.min(values, 0, values.length);
    }

    public static float min(float[] values, int length) {
        return Flt.min(values, 0, length);
    }

    public static float mean(float[] values, int start, int length) {
        return (float)Flt.meanDouble(values, start, length);
    }

    public static float mean(float[] values, int length) {
        return (float)Flt.meanDouble(values, 0, length);
    }

    public static float mean(float[] values) {
        return (float)Flt.meanDouble(values, 0, values.length);
    }

    public static float variance(float[] values, int start, int length) {
        return (float)Flt.varianceDouble(values, start, length);
    }

    private static double meanDouble(float[] values, int start, int length) {
        double mean = Flt.bigSum(values, start, length) / (double)length;
        return mean;
    }

    public static double varianceDouble(float[] values, int start, int length) {
        double mean = Flt.meanDouble(values, start, length);
        double temp = 0.0;
        for (int index = start; index < length; ++index) {
            double a = values[index];
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)length;
    }

    public static float variance(float[] values, int length) {
        return (float)Flt.varianceDouble(values, 0, length);
    }

    public static float variance(float[] values) {
        return (float)Flt.varianceDouble(values, 0, values.length);
    }

    public static float standardDeviation(float[] values, int start, int length) {
        double variance = Flt.varianceDouble(values, start, length);
        return (float)Math.sqrt(variance);
    }

    public static float standardDeviation(float[] values, int length) {
        double variance = Flt.varianceDouble(values, 0, length);
        return (float)Math.sqrt(variance);
    }

    public static float standardDeviation(float[] values) {
        double variance = Flt.varianceDouble(values, 0, values.length);
        return (float)Math.sqrt(variance);
    }

    public static float median(float[] values, int start, int length) {
        float[] sorted = new float[length];
        System.arraycopy(values, start, sorted, 0, length);
        Arrays.sort(sorted);
        if (length % 2 == 0) {
            int middle = sorted.length / 2;
            double median = (double)(sorted[middle - 1] + sorted[middle]) / 2.0;
            return (float)median;
        }
        return sorted[sorted.length / 2];
    }

    public static float median(float[] values, int length) {
        return Flt.median(values, 0, length);
    }

    public static float median(float[] values) {
        return Flt.median(values, 0, values.length);
    }

    public static boolean equals(int start, int end, float[] expected, float[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = start; index < end; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (float item : array) {
            int bits = Float.floatToIntBits(item);
            result = 31 * result + bits;
        }
        return result;
    }

    public static int hashCode(int start, int end, float[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = start; index < end; ++index) {
            int bits = Float.floatToIntBits(array[index]);
            result = 31 * result + bits;
        }
        return result;
    }

    public static interface ReduceBy {
        public double reduce(double var1, float var3);
    }
}

