/*
 * Decompiled with CFR 0.152.
 */
package org.boon.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.boon.Boon;
import org.boon.Str;
import org.boon.logging.LogLevel;
import org.boon.logging.LoggerDelegate;

public class JDKLogger
implements LoggerDelegate {
    private final Logger logger;

    JDKLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public boolean infoOn() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean debugOn() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean traceOn() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void fatal(Object ... messages) {
        this.logger.log(Level.SEVERE, Boon.sputs(messages));
    }

    @Override
    public void fatal(Throwable t, Object ... messages) {
        this.logger.log(Level.SEVERE, Boon.sputs(messages), t);
    }

    @Override
    public void error(Object ... messages) {
        this.logger.log(Level.SEVERE, Boon.sputs(messages));
    }

    @Override
    public void error(Throwable t, Object ... messages) {
        this.logger.log(Level.SEVERE, Boon.sputs(messages), t);
    }

    @Override
    public void warn(Object ... messages) {
        this.logger.log(Level.WARNING, Boon.sputs(messages));
    }

    @Override
    public void warn(Throwable t, Object ... messages) {
        this.logger.log(Level.WARNING, Boon.sputs(messages), t);
    }

    @Override
    public void info(Object ... messages) {
        this.logger.log(Level.INFO, Boon.sputs(messages));
    }

    @Override
    public void info(Throwable t, Object ... messages) {
        this.logger.log(Level.INFO, Boon.sputs(messages), t);
    }

    @Override
    public void config(Object ... messages) {
        this.logger.log(Level.CONFIG, Boon.sputs(messages));
    }

    @Override
    public void config(Throwable t, Object ... messages) {
        this.logger.log(Level.CONFIG, Boon.sputs(messages), t);
    }

    @Override
    public void debug(Object ... messages) {
        this.logger.log(Level.FINE, Boon.sputs(messages));
    }

    @Override
    public void debug(Throwable t, Object ... messages) {
        this.logger.log(Level.FINE, Boon.sputs(messages), t);
    }

    @Override
    public void trace(Object ... messages) {
        this.logger.log(Level.FINEST, Boon.sputs(messages));
    }

    @Override
    public void trace(Throwable t, Object ... messages) {
        this.logger.log(Level.FINEST, Boon.sputs(messages), t);
    }

    public LogLevel level() {
        Level level = this.logger.getLevel();
        if (level == Level.FINE) {
            return LogLevel.DEBUG;
        }
        if (level == Level.FINEST) {
            return LogLevel.TRACE;
        }
        if (level == Level.CONFIG) {
            return LogLevel.CONFIG;
        }
        if (level == Level.INFO) {
            return LogLevel.INFO;
        }
        if (level == Level.WARNING) {
            return LogLevel.WARN;
        }
        if (level == Level.SEVERE) {
            return LogLevel.FATAL;
        }
        return LogLevel.ERROR;
    }

    @Override
    public LoggerDelegate level(LogLevel level) {
        switch (level) {
            case DEBUG: {
                this.logger.setLevel(Level.FINE);
                break;
            }
            case TRACE: {
                this.logger.setLevel(Level.FINEST);
                break;
            }
            case CONFIG: {
                this.logger.setLevel(Level.CONFIG);
                break;
            }
            case INFO: {
                this.logger.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                this.logger.setLevel(Level.WARNING);
                break;
            }
            case ERROR: {
                this.logger.setLevel(Level.SEVERE);
                break;
            }
            case FATAL: {
                this.logger.setLevel(Level.SEVERE);
            }
        }
        return this;
    }

    @Override
    public LoggerDelegate turnOff() {
        this.logger.setLevel(Level.OFF);
        return this;
    }

    @Override
    public void fatal(Object message) {
        this.logger.log(Level.SEVERE, Str.str(message));
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logger.log(Level.SEVERE, Str.str(message), t);
    }

    @Override
    public void error(Object message) {
        this.logger.log(Level.SEVERE, Str.str(message));
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logger.log(Level.SEVERE, Str.str(message), t);
        this.logger.log(Level.SEVERE, Str.str(message), t);
    }

    @Override
    public void warn(Object message) {
        this.logger.log(Level.WARNING, Str.str(message));
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.logger.log(Level.WARNING, Str.str(message), t);
    }

    @Override
    public void info(Object message) {
        this.logger.log(Level.INFO, Str.str(message));
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logger.log(Level.INFO, Str.str(message), t);
    }

    @Override
    public void debug(Object message) {
        this.logger.log(Level.FINE, Str.str(message));
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.logger.log(Level.FINE, Str.str(message), t);
    }

    @Override
    public void trace(Object message) {
        this.logger.log(Level.FINEST, Str.str(message));
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.logger.log(Level.FINEST, Str.str(message), t);
    }
}

