/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.core.reflection.fields.FieldsAccessor;

public class PropertyFieldAccessor
implements FieldsAccessor {
    private final Map<Class<?>, Map<String, FieldAccess>> fieldMap = new ConcurrentHashMap();
    private final boolean useAlias;

    public PropertyFieldAccessor(boolean useAlias) {
        this.useAlias = useAlias;
    }

    @Override
    public final Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> map = this.fieldMap.get(aClass);
        if (map == null) {
            map = this.doGetFields(aClass);
            this.fieldMap.put(aClass, map);
        }
        return map;
    }

    private final Map<String, FieldAccess> doGetFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> fieldAccessMap = Reflection.getPropertyFieldAccessors(aClass);
        if (this.useAlias) {
            LinkedHashMap<String, FieldAccess> fieldAccessMap2 = new LinkedHashMap<String, FieldAccess>(fieldAccessMap.size());
            for (FieldAccess fa : fieldAccessMap.values()) {
                fieldAccessMap2.put(fa.alias(), fa);
            }
            return fieldAccessMap2;
        }
        return fieldAccessMap;
    }
}

