/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.core.Sys;
import org.boon.core.reflection.FastStringUtils;
import org.boon.json.JsonException;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;

public class Dates {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static volatile long lastNow;
    private static long MILLI_SECOND;
    private static long SECOND;
    private static long MINUTE;
    private static long HOUR;
    private static long DAY;
    private static long WEEK;
    private static long MONTH;
    private static long YEAR;
    static final int SHORT_ISO_8601_TIME_LENGTH;
    static final int LONG_ISO_8601_TIME_LENGTH;
    public static final int JSON_TIME_LENGTH;
    private static final boolean isGMT;

    public static long utcNow() {
        long now = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(now);
        calendar.setTimeZone(UTC_TIME_ZONE);
        long utcNow = calendar.getTime().getTime();
        lastNow = now;
        return utcNow;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static long timeZoneNow(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        return Dates.timeZoneNow(timeZone);
    }

    public static long timeZoneNow(TimeZone timeZone, Calendar calendar) {
        long now = System.currentTimeMillis();
        calendar.setTimeInMillis(now);
        calendar.setTimeZone(timeZone);
        long timeZoneNow = calendar.getTime().getTime();
        return timeZoneNow;
    }

    public static Calendar utcCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(UTC_TIME_ZONE);
        return calendar;
    }

    public static int durationInHours(long to, long from) {
        long duration = Math.abs(to - from);
        return (int)(duration / HOUR);
    }

    public static int durationInMinutes(long to, long from) {
        long duration = Math.abs(to - from);
        return (int)(duration / MINUTE);
    }

    public static long durationInSeconds(long to, long from) {
        long duration = Math.abs(to - from);
        return (int)(duration / SECOND);
    }

    public static long durationInMilis(long to, long from) {
        long duration = Math.abs(to - from);
        return (int)(duration / MILLI_SECOND);
    }

    public static long utcNowFast(Calendar utcCalendar) {
        long now = Sys.time();
        long utcNow = utcCalendar.getTime().getTime();
        lastNow = now;
        return utcNow;
    }

    public static long utc(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.setTimeZone(UTC_TIME_ZONE);
        long utcNow = calendar.getTime().getTime();
        lastNow = time;
        return utcNow;
    }

    public static long utcFast(long time, Calendar utcCalendar) {
        long utcNow = utcCalendar.getTime().getTime();
        lastNow = time;
        return utcNow;
    }

    static long lastNow() {
        return lastNow;
    }

    public static long fromUtcTimeToTimeZone(long utcTime, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(UTC_TIME_ZONE);
        calendar.setTimeInMillis(utcTime);
        calendar.setTimeZone(timeZone);
        return calendar.getTime().getTime();
    }

    public static boolean before(long isThis, long beforeThis) {
        return isThis < beforeThis;
    }

    public static boolean after(long isThis, long afterThis) {
        return isThis > afterThis;
    }

    public static long hourDuration(int count) {
        return (long)count * HOUR;
    }

    public static long minuteDuration(int count) {
        return (long)count * MINUTE;
    }

    public static long secondDuration(int count) {
        return (long)count * SECOND;
    }

    public static long dayDuration(int count) {
        return (long)count * DAY;
    }

    public static long secondsFrom(long time, int seconds) {
        return time + (long)seconds * SECOND;
    }

    public static long minutesFrom(long time, int minutes) {
        return time + (long)minutes * MINUTE;
    }

    public static long hoursFrom(long time, int hours) {
        return time + (long)hours * HOUR;
    }

    public static long daysFrom(long time, int days) {
        return time + (long)days * DAY;
    }

    public static long weeksFrom(long time, int weeks) {
        return time + (long)weeks * WEEK;
    }

    public static long monthsFrom(long time, int months) {
        return time + (long)months * MONTH;
    }

    public static long yearsFrom(long time, int years) {
        return time + (long)years * YEAR;
    }

    public static long utcDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        calendar.setTimeZone(UTC_TIME_ZONE);
        return Dates.internalDate(year, month, day, calendar);
    }

    public static long utcDate(int year, int month, int day, int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        calendar.setTimeZone(UTC_TIME_ZONE);
        return Dates.internalDateLong(year, month, day, hour, minute, calendar);
    }

    private static long internalDateLong(int year, int month, int day, int hour, int minute, Calendar calendar) {
        return Dates.internalDate(year, month, day, hour, minute, calendar).getTime();
    }

    private static Date internalDate(int year, int month, int day, int hour, int minute, Calendar calendar) {
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        return calendar.getTime();
    }

    private static Date internalDate(TimeZone tz, int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.setTimeZone(tz);
        return calendar.getTime();
    }

    private static Date internalDate(TimeZone tz, int year, int month, int day, int hour, int minute, int second, int miliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, miliseconds);
        calendar.setTimeZone(tz);
        return calendar.getTime();
    }

    public static long wallTimeDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        return Dates.internalDate(year, month, day, calendar);
    }

    public static long date(int year, int month, int day) {
        return Dates.utcDate(year, month, day);
    }

    public static long date(int year, int month, int day, int hour, int minute) {
        return Dates.utcDate(year, month, day, hour, minute);
    }

    public static long date(TimeZone tz, int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        calendar.setTimeZone(tz);
        return Dates.internalDate(year, month, day, calendar);
    }

    private static long internalDate(int year, int month, int day, Calendar calendar) {
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime().getTime();
    }

    public static long wallTimeDate(int year, int month, int day, int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        return Dates.internalDateLong(year, month, day, hour, minute, calendar);
    }

    public static Date toDate(TimeZone tz, int year, int month, int day, int hour, int minute, int second) {
        return Dates.internalDate(tz, year, month, day, hour, minute, second);
    }

    public static Date toDate(TimeZone tz, int year, int month, int day, int hour, int minute, int second, int miliseconds) {
        return Dates.internalDate(tz, year, month, day, hour, minute, second, miliseconds);
    }

    public static Date toDate(int year, int month, int day, int hour, int minute, int second, int miliseconds) {
        return Dates.internalDate(TimeZone.getDefault(), year, month, day, hour, minute, second, miliseconds);
    }

    public static long date(TimeZone tz, int year, int month, int day, int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        Dates.midnight(calendar);
        calendar.setTimeZone(tz);
        return Dates.internalDateLong(year, month, day, hour, minute, calendar);
    }

    private static void midnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static String euroUTCSystemDateNowString() {
        long now = System.currentTimeMillis();
        return Dates.euroUTCSystemDateString(now);
    }

    public static String euroUTCSystemDateString(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        calendar.setTimeZone(UTC_TIME_ZONE);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        CharBuf buf = CharBuf.create(16);
        buf.add(Str.zfill(day, 2)).add('_');
        buf.add(Str.zfill(month, 2)).add('_');
        buf.add(year).add('_');
        buf.add(Str.zfill(hour, 2)).add('_');
        buf.add(Str.zfill(minute, 2)).add('_');
        buf.add(Str.zfill(second, 2)).add("_utc_euro");
        return buf.toString();
    }

    public static void main(String ... args) {
        Sys.println(Dates.euroUTCSystemDateNowString());
    }

    public static Date year(int year) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(GMT);
        c.set(1970, 0, 2, 0, 0, 0);
        c.set(1, year);
        return c.getTime();
    }

    public static Date getUSDate(int month, int day, int year) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(GMT);
        c.set(year, month - 1, day + 1, 0, 0, 0);
        return c.getTime();
    }

    public static Date getUSDate(int month, int day, int year, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(GMT);
        c.set(year, month - 1, day + 1, hour, minute, second);
        return c.getTime();
    }

    public static Date getEuroDate(int day, int month, int year) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(GMT);
        c.set(year, month - 1, day + 1, 0, 0, 0);
        return c.getTime();
    }

    public static Date getEuroDate(int day, int month, int year, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(GMT);
        c.set(year, month - 1, day + 1, hour, minute, second);
        return c.getTime();
    }

    public static Date fromISO8601_(String string) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").parse(string);
        }
        catch (ParseException e) {
            return Exceptions.handle(Date.class, "Not a valid ISO8601", e);
        }
    }

    public static Date fromJsonDate_(String string) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(string);
        }
        catch (ParseException e) {
            return Exceptions.handle(Date.class, "Not a valid JSON date", e);
        }
    }

    public static Date fromJsonDate(String string) {
        return Dates.fromJsonDate(FastStringUtils.toCharArray(string), 0, string.length());
    }

    public static Date fromISO8601(String string) {
        return Dates.fromISO8601(FastStringUtils.toCharArray(string), 0, string.length());
    }

    public static Date fromISO8601DateLoose(String string) {
        return Dates.fromISO8601DateLoose(FastStringUtils.toCharArray(string), 0, string.length());
    }

    public static Date fromISO8601DateLoose(char[] chars) {
        return Dates.fromISO8601DateLoose(chars, 0, chars.length);
    }

    public static String jsonDate(Date date) {
        CharBuf buf = CharBuf.create(JSON_TIME_LENGTH);
        Dates.jsonDateChars(date, buf);
        return buf.toString();
    }

    public static void jsonDateChars(Date date, CharBuf buf) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        Dates.jsonDateChars(calendar, date, buf);
    }

    public static void jsonDateChars(long milis, CharBuf buf) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        Dates.jsonDateChars(calendar, milis, buf);
    }

    public static void jsonDateChars(Calendar calendar, Date date, CharBuf buf) {
        Dates.jsonDateChars(calendar, date.getTime(), buf);
    }

    public static void jsonDateChars(Calendar calendar, long milis, CharBuf buf) {
        if (isGMT) {
            Dates.fastJsonDateChars(new Date(milis), buf);
            return;
        }
        calendar.setTimeInMillis(milis);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int mili = calendar.get(14);
        buf.add('\"');
        buf.add(year).add('-');
        buf.add(Str.zfill(month, 2)).add('-');
        buf.add(Str.zfill(day, 2)).add('T');
        buf.add(Str.zfill(hour, 2)).add(':');
        buf.add(Str.zfill(minute, 2)).add(':');
        buf.add(Str.zfill(second, 2)).add(".");
        buf.add(Str.zfill(mili, 3)).add("Z");
        buf.add('\"');
    }

    public static void fastJsonDateChars(Date date, CharBuf buf) {
        int day = date.getDate();
        int month = date.getMonth() + 1;
        int year = date.getYear() + 1900;
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        int offset = date.getTimezoneOffset();
        int mili = 1;
        buf.add('\"');
        buf.add(year).add('-');
        buf.add(Str.zfill(month, 2)).add('-');
        buf.add(Str.zfill(day, 2)).add('T');
        buf.add(Str.zfill(hour, 2)).add(':');
        buf.add(Str.zfill(minute, 2)).add(':');
        buf.add(Str.zfill(second, 2)).add(".");
        buf.add(Str.zfill(mili, 3)).add("Z");
        buf.add('\"');
    }

    public static Date fromISO8601DateLoose(char[] buffer, int startIndex, int endIndex) {
        if (Dates.isISO8601QuickCheck(buffer, startIndex, endIndex)) {
            if (Dates.isJsonDate(buffer, startIndex, endIndex)) {
                return Dates.fromJsonDate(buffer, startIndex, endIndex);
            }
            if (Dates.isISO8601(buffer, startIndex, endIndex)) {
                return Dates.fromISO8601(buffer, startIndex, endIndex);
            }
            try {
                return Dates.looseParse(buffer, startIndex, endIndex);
            }
            catch (Exception ex) {
                throw new JsonException("unable to do a loose parse", ex);
            }
        }
        try {
            return Dates.looseParse(buffer, startIndex, endIndex);
        }
        catch (Exception ex) {
            throw new JsonException("unable to do a loose parse", ex);
        }
    }

    private static Date looseParse(char[] buffer, int startIndex, int endIndex) {
        char[][] parts = CharScanner.splitByCharsNoneEmpty(buffer, startIndex, endIndex, '-', ':', 'T', '.');
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minutes = 0;
        int seconds = 0;
        int mili = 0;
        if (parts.length >= 3) {
            year = CharScanner.parseInt(parts[0]);
            month = CharScanner.parseInt(parts[1]);
            day = CharScanner.parseInt(parts[2]);
        }
        if (parts.length >= 6) {
            hour = CharScanner.parseInt(parts[3]);
            minutes = CharScanner.parseInt(parts[4]);
            seconds = CharScanner.parseInt(parts[5]);
        }
        if (parts.length >= 7) {
            mili = CharScanner.parseInt(parts[6]);
        }
        return Dates.toDate(year, month, day, hour, minutes, seconds, mili);
    }

    public static Date fromISO8601(char[] charArray, int from, int to) {
        try {
            int length = to - from;
            if (Dates.isISO8601(charArray, from, to)) {
                int year = CharScanner.parseIntFromTo(charArray, from + 0, from + 4);
                int month = CharScanner.parseIntFromTo(charArray, from + 5, from + 7);
                int day = CharScanner.parseIntFromTo(charArray, from + 8, from + 10);
                int hour = CharScanner.parseIntFromTo(charArray, from + 11, from + 13);
                int minute = CharScanner.parseIntFromTo(charArray, from + 14, from + 16);
                int second = CharScanner.parseIntFromTo(charArray, from + 17, from + 19);
                TimeZone tz = null;
                if (charArray[from + 19] == 'Z') {
                    tz = GMT;
                } else {
                    StringBuilder builder = new StringBuilder(9);
                    builder.append("GMT");
                    builder.append(charArray, from + 19, 6);
                    String tzStr = builder.toString();
                    tz = TimeZone.getTimeZone(tzStr);
                }
                return Dates.toDate(tz, year, month, day, hour, minute, second);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Date fromJsonDate(char[] charArray, int from, int to) {
        try {
            if (Dates.isJsonDate(charArray, from, to)) {
                int year = CharScanner.parseIntFromTo(charArray, from + 0, from + 4);
                int month = CharScanner.parseIntFromTo(charArray, from + 5, from + 7);
                int day = CharScanner.parseIntFromTo(charArray, from + 8, from + 10);
                int hour = CharScanner.parseIntFromTo(charArray, from + 11, from + 13);
                int minute = CharScanner.parseIntFromTo(charArray, from + 14, from + 16);
                int second = CharScanner.parseIntFromTo(charArray, from + 17, from + 19);
                int milliseconds = CharScanner.parseIntFromTo(charArray, from + 20, from + 23);
                TimeZone tz = GMT;
                return Dates.toDate(tz, year, month, day, hour, minute, second, milliseconds);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isISO8601(String string) {
        return Dates.isISO8601(FastStringUtils.toCharArray(string));
    }

    public static boolean isISO8601(char[] charArray) {
        return Dates.isISO8601(charArray, 0, charArray.length);
    }

    public static boolean isISO8601(char[] charArray, int start, int to) {
        boolean valid = true;
        int length = to - start;
        if (length == SHORT_ISO_8601_TIME_LENGTH) {
            valid &= charArray[start + 19] == 'Z';
        } else if (length == LONG_ISO_8601_TIME_LENGTH) {
            valid &= charArray[start + 19] == '-' || charArray[start + 19] == '+';
            valid &= charArray[start + 22] == ':';
        } else {
            return false;
        }
        return valid &= charArray[start + 4] == '-' && charArray[start + 7] == '-' && charArray[start + 10] == 'T' && charArray[start + 13] == ':' && charArray[start + 16] == ':';
    }

    public static boolean isISO8601QuickCheck(char[] charArray, int start, int to) {
        int length = to - start;
        try {
            return length == JSON_TIME_LENGTH || length == LONG_ISO_8601_TIME_LENGTH || length == SHORT_ISO_8601_TIME_LENGTH || length >= 17 && charArray[start + 16] == ':';
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isISO8601QuickCheck(char[] charArray) {
        int length = charArray.length;
        return (length == JSON_TIME_LENGTH || length == LONG_ISO_8601_TIME_LENGTH || length == SHORT_ISO_8601_TIME_LENGTH || length >= 16 && charArray[16] == ':') && length >= 16 && charArray[16] == ':';
    }

    public static boolean isJsonDate(String str) {
        return Dates.isJsonDate(FastStringUtils.toCharArray(str), 0, str.length());
    }

    public static boolean isJsonDate(char[] charArray, int start, int to) {
        boolean valid = true;
        int length = to - start;
        if (length != JSON_TIME_LENGTH) {
            return false;
        }
        if (!(valid &= charArray[start + 19] == '.')) {
            return false;
        }
        return valid &= charArray[start + 4] == '-' && charArray[start + 7] == '-' && charArray[start + 10] == 'T' && charArray[start + 13] == ':' && charArray[start + 16] == ':';
    }

    static {
        MILLI_SECOND = 1L;
        SECOND = MILLI_SECOND * 1000L;
        MINUTE = 60L * SECOND;
        HOUR = 60L * MINUTE;
        DAY = 24L * HOUR;
        WEEK = 7L * DAY;
        MONTH = (long)(30.4167 * (double)DAY);
        YEAR = (long)(365.2425 * (double)DAY);
        SHORT_ISO_8601_TIME_LENGTH = "1994-11-05T08:15:30Z".length();
        LONG_ISO_8601_TIME_LENGTH = "1994-11-05T08:15:30-05:00".length();
        JSON_TIME_LENGTH = "2013-12-14T01:55:33.412Z".length();
        isGMT = TimeZone.getDefault() == GMT;
    }
}

