/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.validators.BaseValidator;

public class RegexValidator
extends BaseValidator {
    private String match;
    private boolean negate;
    private Map<String, Pattern> compiledRegexCache = new HashMap<String, Pattern>();

    public boolean isNegate() {
        return this.negate;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    protected String getMatch() {
        return this.match;
    }

    public void setMatch(String regex) {
        this.match = regex;
    }

    @Override
    public ValidatorMessageHolder validate(Object object, String fieldLabel) {
        ValidatorMessage message = new ValidatorMessage();
        if (object == null) {
            return message;
        }
        String string = object.toString();
        Pattern pattern = this.compileRegex();
        boolean valid = this.negate ? !pattern.matcher(string).matches() : pattern.matcher(string).matches();
        if (!valid) {
            this.populateMessage(message, fieldLabel, new Object[0]);
            return message;
        }
        return message;
    }

    private Pattern compileRegex() {
        Pattern pattern = this.compiledRegexCache.get(this.getMatch());
        if (pattern == null) {
            pattern = Pattern.compile(this.getMatch());
            this.compiledRegexCache.put(this.getMatch(), pattern);
        }
        return pattern;
    }
}

