/*
 * Decompiled with CFR 0.152.
 */
package org.boon.validation.validators;

import java.lang.reflect.Method;
import org.boon.validation.ValidatorMessage;
import org.boon.validation.ValidatorMessageHolder;
import org.boon.validation.validators.BaseValidator;

public class CommonBridgeValidator
extends BaseValidator {
    private Class<?> validatorClass;
    private String methodName = "isValid";
    private String factoryMethod = "getInstance";
    private Object validator;
    private Method validateMethod;

    @Override
    public ValidatorMessageHolder validate(Object object, String fieldLabel) {
        ValidatorMessage message = new ValidatorMessage();
        if (object == null) {
            return message;
        }
        boolean valid = false;
        try {
            this.initValidatorIfNeeded();
            this.initValidateMethodIfNeeded();
            valid = (Boolean)this.validateMethod.invoke(this.validator, (String)object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Fatal exception trying to create validator, probably a missing jar or bad class name in spring context", exception);
        }
        if (!valid) {
            this.populateMessage(message, fieldLabel, new Object[0]);
        }
        return message;
    }

    private void initValidateMethodIfNeeded() throws Exception {
        if (this.validateMethod == null) {
            this.validateMethod = this.validatorClass.getMethod(this.methodName, String.class);
        }
    }

    private void initValidatorIfNeeded() throws Exception {
        if (this.validator == null) {
            if (this.factoryMethod == null) {
                this.validator = this.validatorClass.newInstance();
            } else {
                Method method = this.validatorClass.getMethod(this.factoryMethod, new Class[0]);
                this.validator = method.invoke(null, (Object[])null);
            }
        }
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setValidatorClass(Class<?> validatorClass) {
        this.validatorClass = validatorClass;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }
}

