/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.ArrayList;
import java.util.List;
import org.boon.Boon;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharScanner;

public class JSTLCoreParser {
    char[] charArray;
    int index;
    int ch;
    private List<Token> tokenList;

    public void TemplateParser() {
    }

    public void parse(String string) {
        this.charArray = FastStringUtils.toCharArray(string);
        this.index = 0;
        this.tokenList = new ArrayList<Token>();
        this.processLoop();
    }

    private void processLoop() {
        Token text = Token.text(this.index, -1);
        while (this.index < this.charArray.length) {
            this.ch = this.charArray[this.index];
            if (this.ch == 60) {
                if (CharScanner.matchChars(TokenTypes.COMMAND_START.chars, this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.COMMAND_START.chars.length;
                    this.handleCommand();
                }
            } else if (this.ch == 36) {
                if (CharScanner.matchChars(TokenTypes.EXPRESSION_START.chars, this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.EXPRESSION_START.chars.length;
                    this.handleExpression();
                }
            } else if (text == null) {
                text = Token.text(this.index, -1);
            }
            ++this.index;
        }
        if (text != null) {
            text.stop = this.charArray.length;
            this.tokenList.add(text);
        }
    }

    private void handleExpression() {
        int startIndex = this.index;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.chars, this.index, this.charArray);
        if (this.index > 0) {
            this.tokenList.add(Token.expression(startIndex, this.index));
            this.index += TokenTypes.EXPRESSION_END.chars.length;
        }
    }

    private void handleCommand() {
        int startIndex = this.index;
        this.index = CharScanner.findChars(TokenTypes.COMMAND_END_START.chars, this.index, this.charArray);
        if (this.index == -1) {
            return;
        }
        this.tokenList.add(Token.commandStart(startIndex, this.index));
        this.index += TokenTypes.COMMAND_END_START.chars.length;
        Token commandBody = Token.commandBody(this.index, -1);
        this.tokenList.add(commandBody);
        Token text = Token.text(this.index, -1);
        while (this.index < this.charArray.length) {
            this.ch = this.charArray[this.index];
            if (this.ch == 60) {
                if (CharScanner.matchChars(TokenTypes.COMMAND_START.chars, this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.COMMAND_START.chars.length;
                    this.handleCommand();
                } else if (CharScanner.matchChars(TokenTypes.COMMAND_START_END.chars, this.index, this.charArray)) {
                    text = this.textToken(text);
                    commandBody.stop = this.index++;
                    this.index = CharScanner.findChar('>', this.index, this.charArray);
                    break;
                }
            } else if (this.ch == 36) {
                if (CharScanner.matchChars(TokenTypes.EXPRESSION_START.chars, this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.EXPRESSION_START.chars.length;
                    this.handleExpression();
                }
            } else if (text == null) {
                text = Token.text(this.index, -1);
            }
            ++this.index;
        }
    }

    private Token textToken(Token text) {
        if (text != null) {
            text.stop = this.index;
            if (text.start != text.stop) {
                this.tokenList.add(text);
            }
            text = null;
        }
        return text;
    }

    public static void main(String ... args) {
        JSTLCoreParser parser = new JSTLCoreParser();
        parser.parse("<c:if test>         <c:if test>    g    ${fine}   </c:if>   g         </c:if>   How are you?");
        Boon.putl(parser.tokenList);
    }

    public static enum TokenTypes {
        COMMAND(""),
        COMMAND_BODY(""),
        EXPRESSION(""),
        COMMAND_START("<c:"),
        COMMAND_END_START(">"),
        COMMAND_START_END("</c:"),
        EXPRESSION_START("${"),
        EXPRESSION_END("}"),
        TEXT("");

        char[] chars;

        private TokenTypes(String str) {
            this.chars = FastStringUtils.toCharArray(str);
        }
    }

    public static class Token {
        int start;
        int stop;
        TokenTypes type;

        public Token(int start, int stop, TokenTypes type) {
            this.start = start;
            this.stop = stop;
            this.type = type;
        }

        public Token() {
        }

        public static Token text(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.TEXT;
            return token;
        }

        public static Token commandStart(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.COMMAND;
            return token;
        }

        public static Token commandBody(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.COMMAND_BODY;
            return token;
        }

        public static Token expression(int start, int stop) {
            Token token = new Token();
            token.start = start;
            token.stop = stop;
            token.type = TokenTypes.EXPRESSION;
            return token;
        }

        public String toString() {
            return "Token{start=" + this.start + ", stop=" + this.stop + ", type=" + (Object)((Object)this.type) + '}';
        }
    }
}

