/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.Invoker;

public class Int {
    public static int[] grow(int[] array, int size) {
        Exceptions.requireNonNull(array);
        int[] newArray = new int[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] grow(int[] array) {
        Exceptions.requireNonNull(array);
        int[] newArray = new int[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] shrink(int[] array, int size) {
        Exceptions.requireNonNull(array);
        int[] newArray = new int[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static int[] compact(int[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (int ch : array) {
            if (ch != 0) continue;
            ++nullCount;
        }
        int[] newArray = new int[array.length - nullCount];
        int j = 0;
        for (int ch : array) {
            if (ch == 0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static int[] arrayOfInt(int size) {
        return new int[size];
    }

    @Universal
    public static int[] array(int ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int lengthOf(int[] array) {
        return Int.len(array);
    }

    @Universal
    public static int len(int[] array) {
        return array.length;
    }

    @Universal
    public static int idx(int[] array, int index) {
        int i = Int.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static int atIndex(int[] array, int index) {
        int i = Int.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(int[] array, int index, int value) {
        int i = Int.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static void atIndex(int[] array, int index, int value) {
        int i = Int.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static int[] slc(int[] array, int startIndex, int endIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int end = Int.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] sliceOf(int[] array, int startIndex, int endIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int end = Int.calculateIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] slc(int[] array, int startIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] sliceOf(int[] array, int startIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] slcEnd(int[] array, int endIndex) {
        int end = Int.calculateIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] endSliceOf(int[] array, int endIndex) {
        int end = Int.calculateIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(int value, int[] array) {
        for (int currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static int[] copy(int[] array) {
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static int[] add(int[] array, int v) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static int[] add(int[] array, int[] array2) {
        int[] newArray = new int[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static int[] insert(int[] array, int idx, int v) {
        if (idx >= array.length) {
            return Int.add(array, v);
        }
        int index = Int.calculateIndex(array, idx);
        int[] newArray = new int[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static int[] insert(int[] array, int fromIndex, int[] values) {
        if (fromIndex >= array.length) {
            return Int.add(array, values);
        }
        int index = Int.calculateIndex(array, fromIndex);
        int[] newArray = new int[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(int[] array, int originalIndex) {
        int length = array.length;
        Exceptions.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    public static long reduceBy(int[] array, Object object) {
        long sum = 0L;
        for (int v : array) {
            sum = (Long)Invoker.invokeReducer(object, sum, v);
        }
        return sum;
    }
}

