/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Maps;
import org.boon.core.Type;
import org.boon.core.reflection.FastStringUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.primitive.CharBuf;

public class JsonSimpleSerializerImpl
implements JsonSerializerInternal {
    private final Map<Class<?>, Map<String, FieldAccess>> fieldMap = new ConcurrentHashMap();
    private final String view;
    private CharBuf builder = CharBuf.create(4000);
    private static final char[] EMPTY_MAP_CHARS = new char[]{'{', '}'};
    private static final char[] EMPTY_LIST_CHARS = new char[]{'[', ']'};

    public JsonSimpleSerializerImpl(String view) {
        this.view = view;
    }

    @Override
    public final void serializeString(String str, CharBuf builder) {
        builder.asJsonString(str);
    }

    @Override
    public CharBuf serialize(Object obj) {
        this.builder.readForRecycle();
        try {
            this.serializeObject(obj, this.builder);
        }
        catch (Exception ex) {
            return Exceptions.handle(CharBuf.class, "unable to serializeObject", ex);
        }
        return this.builder;
    }

    @Override
    public final boolean serializeField(Object parent, FieldAccess fieldAccess, CharBuf builder) {
        String fieldName = fieldAccess.name();
        Type typeEnum = fieldAccess.typeEnum();
        try {
            if (fieldAccess.ignore()) {
                return false;
            }
            if (this.view != null && !fieldAccess.isViewActive(this.view)) {
                return false;
            }
            switch (typeEnum) {
                case INT: {
                    int value = fieldAccess.getInt(parent);
                    if (value != 0) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addInt(value);
                        return true;
                    }
                    return false;
                }
                case BOOLEAN: {
                    boolean bvalue = fieldAccess.getBoolean(parent);
                    if (bvalue) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addBoolean(bvalue);
                        return true;
                    }
                    return false;
                }
                case BYTE: {
                    byte byvalue = fieldAccess.getByte(parent);
                    if (byvalue != 0) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addByte(byvalue);
                        return true;
                    }
                    return false;
                }
                case LONG: {
                    long lvalue = fieldAccess.getLong(parent);
                    if (lvalue != 0L) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addLong(lvalue);
                        return true;
                    }
                    return false;
                }
                case DOUBLE: {
                    double dvalue = fieldAccess.getDouble(parent);
                    if (dvalue != 0.0) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addDouble(dvalue);
                        return true;
                    }
                    return false;
                }
                case FLOAT: {
                    float fvalue = fieldAccess.getFloat(parent);
                    if (fvalue != 0.0f) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addFloat(fvalue);
                        return true;
                    }
                    return false;
                }
                case SHORT: {
                    short svalue = fieldAccess.getShort(parent);
                    if (svalue != 0) {
                        this.serializeFieldName(fieldName, builder);
                        builder.addShort(svalue);
                        return true;
                    }
                    return false;
                }
                case CHAR: {
                    char cvalue = fieldAccess.getChar(parent);
                    if (cvalue != '\u0000') {
                        this.serializeFieldName(fieldName, builder);
                        builder.addChar(cvalue);
                        return true;
                    }
                    return false;
                }
            }
            Object value = fieldAccess.getObject(parent);
            if (value == null) {
                return false;
            }
            if (value == parent) {
                return false;
            }
            switch (typeEnum) {
                case BIG_DECIMAL: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addBigDecimal((BigDecimal)value);
                    return true;
                }
                case BIG_INT: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addBigInteger((BigInteger)value);
                    return true;
                }
                case DATE: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeDate((Date)value, builder);
                    return true;
                }
                case STRING: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeString((String)value, builder);
                    return true;
                }
                case CLASS: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeString(((Class)value).getName(), builder);
                    return true;
                }
                case CHAR_SEQUENCE: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeString(value.toString(), builder);
                    return true;
                }
                case INTEGER_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addInt((Integer)value);
                    return true;
                }
                case LONG_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addLong((Long)value);
                    return true;
                }
                case FLOAT_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addFloat((Float)value);
                    return true;
                }
                case DOUBLE_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addDouble((Double)value);
                    return true;
                }
                case SHORT_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addShort((Short)value);
                    return true;
                }
                case BYTE_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addByte((Byte)value);
                    return true;
                }
                case CHAR_WRAPPER: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addChar(((Character)value).charValue());
                    return true;
                }
                case ENUM: {
                    this.serializeFieldName(fieldName, builder);
                    builder.addQuoted(value.toString());
                    return true;
                }
                case COLLECTION: 
                case LIST: 
                case SET: {
                    Collection collection = (Collection)value;
                    if (collection.size() > 0) {
                        this.serializeFieldName(fieldName, builder);
                        this.serializeCollection(collection, builder);
                        return true;
                    }
                    return false;
                }
                case MAP: {
                    Map map = (Map)value;
                    if (map.size() > 0) {
                        this.serializeFieldName(fieldName, builder);
                        this.serializeMap(map, builder);
                        return true;
                    }
                    return false;
                }
                case ARRAY: {
                    if (value.getClass().isArray() && Array.getLength(value) > 0) {
                        this.serializeFieldName(fieldName, builder);
                        this.serializeArray(value, builder);
                        return true;
                    }
                    return false;
                }
                case INTERFACE: 
                case ABSTRACT: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeSubtypeInstance(value, builder);
                    return true;
                }
                case INSTANCE: {
                    this.serializeFieldName(fieldName, builder);
                    this.serializeInstance(value, builder);
                    return true;
                }
                case SYSTEM: {
                    return false;
                }
            }
            this.serializeFieldName(fieldName, builder);
            this.serializeUnknown(value, builder);
            return true;
        }
        catch (Exception ex) {
            return Exceptions.handle(Boolean.class, ex, new Object[]{"Unable to serialize field", fieldName, "from parent object", parent, "type enum", typeEnum});
        }
    }

    @Override
    public final void serializeDate(Date date, CharBuf builder) {
        builder.addLong(date.getTime());
    }

    @Override
    public final void serializeObject(Object obj, CharBuf builder) {
        Type type = Type.getInstanceType(obj);
        switch (type) {
            case NULL: {
                return;
            }
            case INT: {
                builder.addInt(Integer.TYPE.cast(obj));
                return;
            }
            case BOOLEAN: {
                builder.addBoolean(Boolean.TYPE.cast(obj));
                return;
            }
            case BYTE: {
                builder.addByte(Byte.TYPE.cast(obj));
                return;
            }
            case LONG: {
                builder.addLong(Long.TYPE.cast(obj));
                return;
            }
            case DOUBLE: {
                builder.addDouble(Double.TYPE.cast(obj));
                return;
            }
            case FLOAT: {
                builder.addFloat(Float.TYPE.cast(obj));
                return;
            }
            case SHORT: {
                builder.addShort(Short.TYPE.cast(obj));
                return;
            }
            case CHAR: {
                builder.addChar(Character.TYPE.cast(obj).charValue());
                return;
            }
            case BIG_DECIMAL: {
                builder.addBigDecimal((BigDecimal)obj);
                return;
            }
            case BIG_INT: {
                builder.addBigInteger((BigInteger)obj);
                return;
            }
            case DATE: {
                this.serializeDate((Date)obj, builder);
                return;
            }
            case CLASS: {
                this.serializeString(((Class)obj).getName(), builder);
                return;
            }
            case STRING: {
                this.serializeString((String)obj, builder);
                return;
            }
            case CHAR_SEQUENCE: {
                this.serializeString(obj.toString(), builder);
                return;
            }
            case BOOLEAN_WRAPPER: {
                builder.addBoolean((Boolean)obj);
                return;
            }
            case INTEGER_WRAPPER: {
                builder.addInt((Integer)obj);
                return;
            }
            case LONG_WRAPPER: {
                builder.addLong((Long)obj);
                return;
            }
            case FLOAT_WRAPPER: {
                builder.addFloat((Float)obj);
                return;
            }
            case DOUBLE_WRAPPER: {
                builder.addDouble((Double)obj);
                return;
            }
            case SHORT_WRAPPER: {
                builder.addShort((Short)obj);
                return;
            }
            case BYTE_WRAPPER: {
                builder.addByte((Byte)obj);
                return;
            }
            case CHAR_WRAPPER: {
                builder.addChar(((Character)obj).charValue());
                return;
            }
            case ENUM: {
                builder.addQuoted(obj.toString());
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                this.serializeCollection((Collection)obj, builder);
                return;
            }
            case MAP: {
                this.serializeMap((Map)obj, builder);
                return;
            }
            case ARRAY: {
                this.serializeArray(obj, builder);
                return;
            }
            case INTERFACE: 
            case ABSTRACT: {
                this.serializeSubtypeInstance(obj, builder);
                return;
            }
            case INSTANCE: {
                this.serializeInstance(obj, builder);
                return;
            }
        }
        this.serializeUnknown(obj, builder);
    }

    @Override
    public void serializeUnknown(Object obj, CharBuf builder) {
        try {
            builder.addQuoted(obj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final void serializeInstance(Object instance, CharBuf builder) {
        try {
            if (Reflection.respondsTo(instance, "serializeAs")) {
                this.serializeObject(Invoker.invoke(instance, "serializeAs", new Object[0]), builder);
                return;
            }
            Collection<FieldAccess> fields = this.getFields(instance.getClass()).values();
            builder.addChar('{');
            int index = 0;
            for (FieldAccess fieldAccess : fields) {
                if (!this.serializeField(instance, fieldAccess, builder)) continue;
                builder.addChar(',');
                ++index;
            }
            if (index > 0) {
                builder.removeLastChar();
            }
            builder.addChar('}');
        }
        catch (Exception ex) {
            Exceptions.handle(ex, "serialize instance", instance, "class name of instance", Boon.className(instance), "obj", instance);
        }
    }

    @Override
    public Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> map = this.fieldMap.get(aClass);
        if (map == null) {
            map = this.doGetFields(aClass);
            this.fieldMap.put(aClass, map);
        }
        return map;
    }

    private final Map<String, FieldAccess> doGetFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> fields = Maps.copy(Reflection.getPropertyFieldAccessMapFieldFirst(aClass));
        ArrayList<FieldAccess> removeFields = new ArrayList<FieldAccess>();
        for (FieldAccess field : fields.values()) {
            if (!field.isWriteOnly()) continue;
            removeFields.add(field);
        }
        for (FieldAccess fieldAccess : removeFields) {
            fields.remove(fieldAccess.name());
        }
        return fields;
    }

    @Override
    public final void serializeMap(Map<String, Object> smap, CharBuf builder) {
        Map<String, Object> map = smap;
        if (map.size() == 0) {
            builder.addChars(EMPTY_MAP_CHARS);
            return;
        }
        builder.addChar('{');
        int index = 0;
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (entry.getValue() == null) continue;
            this.serializeFieldName(entry.getKey().toString(), builder);
            this.serializeObject(entry.getValue(), builder);
            builder.addChar(',');
            ++index;
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }

    @Override
    public void serializeArray(Object array, CharBuf builder) {
        if (Array.getLength(array) == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        int length = Array.getLength(array);
        for (int index = 0; index < length; ++index) {
            this.serializeObject(Array.get(array, index), builder);
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }

    private void serializeFieldName(String name, CharBuf builder) {
        try {
            builder.addJsonFieldName(FastStringUtils.toCharArray(name));
        }
        catch (Exception ex) {
            Exceptions.handle(Boon.sputs("Unable to serialize field name", name), (Throwable)ex);
        }
    }

    @Override
    public final void serializeCollection(Collection<?> collection, CharBuf builder) {
        if (collection.size() == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        for (Object o : collection) {
            if (o == null) {
                builder.addNull();
            } else {
                this.serializeObject(o, builder);
            }
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }

    @Override
    public void serializeSubtypeInstance(Object instance, CharBuf builder) {
        Map<String, FieldAccess> fieldAccessors = this.getFields(instance.getClass());
        Collection<FieldAccess> values = fieldAccessors.values();
        builder.addString("{\"class\":");
        builder.addQuoted(instance.getClass().getName());
        int index = 0;
        int length = values.size();
        if (length > 0) {
            builder.addChar(',');
            for (FieldAccess fieldAccess : values) {
                if (!this.serializeField(instance, fieldAccess, builder)) continue;
                builder.addChar(',');
                ++index;
            }
            if (index > 0) {
                builder.removeLastChar();
            }
            builder.addChar('}');
        }
    }
}

