/*
 * Decompiled with CFR 0.152.
 */
package org.boon.di.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Logger;
import org.boon.collections.ConcurrentLinkedHashSet;
import org.boon.core.Supplier;
import org.boon.core.Typ;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Fields;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.Reflection;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.di.Context;
import org.boon.di.Module;
import org.boon.di.ProviderInfo;
import org.boon.json.JsonFactory;
import org.boon.logging.LogLevel;
import org.boon.logging.TerminalLogger;

public class ContextImpl
implements Context,
Module {
    protected ConcurrentLinkedHashSet<Module> modules = new ConcurrentLinkedHashSet();
    private String name;
    private AtomicReference<Context> parent = new AtomicReference();
    private Class<ContextImpl> contextImpl = ContextImpl.class;
    private Logger logger = Boon.configurableLogger(this.contextImpl);
    private boolean debug;

    public void initDebug() {
        if (Boon.debugOn()) {
            this.logger.level(LogLevel.DEBUG);
            this.logger.tee(new TerminalLogger());
            this.debug = true;
        }
        if (this.logger.debugOn()) {
            this.debug = true;
        }
    }

    public ContextImpl() {
        this.initDebug();
    }

    public ContextImpl(Module ... modules) {
        this.initDebug();
        for (Module module : modules) {
            module.parent(this);
            this.modules.add(module);
        }
    }

    @Override
    public void parent(Context context) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "parent");
        }
        this.parent.set(context);
    }

    @Override
    public Iterable<Object> values() {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "values()", "IN");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Module m : this.modules) {
            for (Object o : m.values()) {
                list.add(o);
            }
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "values()", "OUT", list);
        }
        return list;
    }

    @Override
    public Iterable<String> names() {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "names()", "IN");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Module m : this.modules) {
            for (String n : m.names()) {
                list.add(n);
            }
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "names()", "OUT", list);
        }
        return list;
    }

    @Override
    public Iterable<Class<?>> types() {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "types()", "IN");
        }
        ArrayList list = new ArrayList();
        for (Module m : this.modules) {
            for (Class<?> c : m.types()) {
                list.add(c);
            }
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "types()", "OUT", list);
        }
        return list;
    }

    @Override
    public Iterable<Module> children() {
        return this.modules;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "get(type)", "IN", type);
        }
        T object = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            object = module.get(type);
            break;
        }
        this.resolveProperties(true, object, this.getProviderInfo(type));
        if (this.debug) {
            this.logger.debug(this.contextImpl, "get(type)", "OUT", object);
        }
        T t = object;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type, String name) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "get(type, name)", "IN", type, name);
        }
        T object = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            object = module.get(type, name);
            break;
        }
        this.resolveProperties(true, object, this.getProviderInfo(type, name));
        if (this.debug) {
            this.logger.debug(this.contextImpl, "get(type, name)", "IN", type, name, "OUT", object);
        }
        T t = object;
        return t;
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo(type)", "IN", type);
        }
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            pi = module.getProviderInfo(type);
            break;
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo(type)", "IN", type, "OUT", pi);
        }
        return pi;
    }

    @Override
    public ProviderInfo getProviderInfo(String name) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo(name)", "IN", name);
        }
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            pi = module.getProviderInfo(name);
            break;
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo(name)", "IN", name, "OUT", pi);
        }
        return pi;
    }

    @Override
    public ProviderInfo getProviderInfo(Class<?> type, String name) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo( type, name )", "IN", type, name);
        }
        ProviderInfo pi = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            pi = module.getProviderInfo(type, name);
            break;
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "getProviderInfo( type, name )", "IN", type, name, "OUT", pi);
        }
        return pi;
    }

    @Override
    public boolean has(Class type) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "has( type )", "IN", type);
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "has( type )", "IN", type);
        }
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            if (this.debug) {
                this.logger.debug(this.contextImpl, "has( type )", "IN", type, "OUT", true);
            }
            return true;
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "has( type )", "IN", type, "OUT", false);
        }
        return false;
    }

    @Override
    public boolean has(String name) {
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            if (this.debug) {
                this.logger.debug(this.contextImpl, "has( name )", "IN", name, "OUT", true);
            }
            return true;
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "has( name )", "IN", name, "OUT", false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Supplier<T> getSupplier(final Class<T> type, final String name) {
        Supplier<T> supplier = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            supplier = module.getSupplier(type, name);
            break;
        }
        final Supplier<T> s = supplier;
        final ContextImpl resolver = this;
        Supplier supplier2 = new Supplier<T>(){
            String supplierName;
            Class<T> supplierType;
            {
                this.supplierName = name;
                this.supplierType = type;
            }

            @Override
            public T get() {
                Object o = s.get();
                resolver.resolveProperties(o);
                return o;
            }
        };
        return supplier2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Supplier<T> getSupplier(Class<T> type) {
        Supplier<T> supplier = null;
        for (Module module : this.modules) {
            if (!module.has(type)) continue;
            supplier = module.getSupplier(type);
            break;
        }
        final Supplier<T> s = supplier;
        ContextImpl resolver = this;
        Supplier supplier2 = new Supplier<T>(){

            @Override
            public T get() {
                Object o = s.get();
                ContextImpl.this.resolveProperties(o);
                return o;
            }
        };
        return supplier2;
    }

    private void resolveProperties(boolean enforce, Object object, ProviderInfo info) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "resolveProperties(enforce, object, info )", "IN", enforce, object, info);
        }
        if (object != null) {
            if (Fields.hasField(object, "__init__") && BeanUtils.idxBoolean(object, "__init__")) {
                if (this.debug) {
                    this.logger.debug(this.contextImpl, "Object was initialized already");
                }
                return;
            }
            if (info != null && info.isPostConstructCalled() && info.value() != null && !info.prototype()) {
                return;
            }
            Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(object.getClass(), true);
            for (FieldAccess field : fields.values()) {
                if (!field.injectable()) continue;
                this.handleInjectionOfField(enforce, object, field);
            }
            if (this.debug) {
                this.logger.debug(this.contextImpl, "Invoking post construct start...", object);
            }
            Invoker.invokeMethodWithAnnotationNoReturn(object, "postConstruct");
            if (this.debug) {
                this.logger.debug(this.contextImpl, "Invoking post construct done...", object);
            }
            if (info != null && info.value() != null && !info.prototype()) {
                if (this.debug) {
                    this.logger.debug(this.contextImpl, "Setting post construct property on provider info...", object);
                }
                info.setPostConstructCalled(true);
            }
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "resolveProperties(enforce, object, info )", "OUT", enforce, object, info);
        }
    }

    @Override
    public void resolveProperties(Object object) {
        this.resolveProperties(true, object, null);
    }

    @Override
    public void resolvePropertiesIgnoreRequired(Object object) {
        this.resolveProperties(false, object, null);
    }

    private void handleInjectionOfField(boolean enforce, Object object, FieldAccess field) {
        if (this.debug) {
            this.logger.debug(this.contextImpl, "handleInjectionOfField(enforce, object, field )", "IN", enforce, object, field);
        }
        Object value = null;
        if (field.type().isPrimitive() || Typ.isBasicType(field.type())) {
            this.handleInjectionOfBasicField(enforce, object, field);
            return;
        }
        boolean fieldNamed = field.isNamed();
        value = fieldNamed && field.type() != Supplier.class ? (Object)this.get(field.type(), field.named()) : (fieldNamed && field.type() == Supplier.class ? this.getSupplier(field.getComponentClass(), field.named()) : (Object)this.get(field.type()));
        if (value == null && field.isNamed() && (value = this.get(field.named())) != null) {
            field.type().isAssignableFrom(value.getClass());
        }
        if (enforce && field.requiresInjection() && value == null) {
            this.debug();
            Exceptions.die(Boon.sputs("Unable to inject into", field.name(), " of ", field.parent(), "with alias\n", field.named(), "was named", field.isNamed(), "field info", field, "\n"));
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "handleInjectionOfField(enforce, object, field )", "IN", enforce, object, field, "\n", "FIELD INJECTION", "into", object, field.name(), "with value", value, "VALUE TYPE", Boon.className(value), field.type());
        }
        field.setValue(object, value);
    }

    private void handleInjectionOfBasicField(boolean enforce, Object object, FieldAccess field) {
        Object value;
        if (this.debug) {
            this.logger.debug(this.contextImpl, "handleInjectionOfBasicField(enforce, object, field )", "IN", enforce, object, field);
        }
        String name = null;
        if (field.isNamed()) {
            if (this.debug) {
                this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "FIELD IS NAMED");
            }
            name = field.alias();
            if (this.debug) {
                this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "FIELD IS NAMED", "name", name);
            }
        }
        if (name == null) {
            name = field.name();
            if (this.debug) {
                this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "USING FIELD NAME AS NAME", "name", name);
            }
        }
        if ((value = this.get(name)) == null) {
            if (this.debug) {
                this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "NAME NOT FOUND IN CONTEXT", "name", name);
            }
            name = Boon.add(field.declaringParent().getName(), ".", field.alias());
        }
        if ((value = this.get(name)) == null) {
            if (this.debug) {
                this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "NAME NOT FOUND IN CONTEXT", "name", name);
            }
            name = Boon.add(field.declaringParent().getPackage().getName(), ".", field.alias());
        }
        value = this.get(name);
        if (this.debug && value == null) {
            this.logger.debug(this.contextImpl, "handleInjectionOfBasicField", "NAME NOT FOUND IN CONTEXT", "name", name);
        }
        if (enforce && value == null && field.requiresInjection()) {
            Exceptions.die("Basic field", field.name(), "needs injection for class", field.declaringParent());
        }
        if (this.debug) {
            this.logger.debug(this.contextImpl, "handleInjectionOfBasicField(enforce, object, field )", "IN", enforce, object, field, "\n", "FIELD INJECTION", "into", object, field.name(), "with value", value, "VALUE TYPE", Boon.className(value), field.type());
        }
        field.setValue(object, value);
        if (this.debug) {
            this.logger.debug(this.contextImpl, "handleInjectionOfBasicField(enforce, object, field )", "OUT", enforce, object, field);
        }
    }

    @Override
    public void debug() {
        Boon.puts(this, "----debug----");
        if (this.parent.get() != null) {
            Boon.puts(this, "delegating to parent----");
            this.parent.get().debug();
        } else {
            this.displayModuleInfo();
        }
    }

    private void displayModuleInfo() {
        int index = 0;
        for (Module module : this.modules) {
            if (module instanceof ContextImpl) {
                ContextImpl context = (ContextImpl)module;
                context.displayModuleInfo();
            } else {
                Boon.puts(index, module);
                Boon.puts("Names:---------------------------");
                for (String string : module.names()) {
                    Boon.puts("              ", string);
                }
                Boon.puts("Type--:---------------------------");
                for (Class clazz : module.types()) {
                    Boon.puts("              ", this.name);
                }
                Boon.puts("Object--:---------------------------");
                for (Object object : module.values()) {
                    Boon.puts("              ", this.name);
                }
            }
            ++index;
        }
    }

    @Override
    public Object get(String name) {
        Map map;
        Object object = null;
        for (Module module : this.modules) {
            if (!module.has(name)) continue;
            object = module.get(name);
            break;
        }
        if (object instanceof Map && (map = (Map)object).containsKey("class")) {
            object = MapObjectConversion.fromMap(map);
        }
        this.resolveProperties(true, object, this.getProviderInfo(name));
        return object;
    }

    @Override
    public Object invoke(String objectName, String methodName, Object args) {
        Object object = this.get(objectName);
        return Invoker.invokeFromObject(object, methodName, args);
    }

    @Override
    public Object invokeOverload(String objectName, String methodName, Object args) {
        Object object = this.get(objectName);
        return Invoker.invokeOverloadedFromObject(object, methodName, args);
    }

    @Override
    public Object invokeFromJson(String objectName, String methodName, String args) {
        return this.invoke(objectName, methodName, JsonFactory.fromJson(args));
    }

    @Override
    public Object invokeOverloadFromJson(String objectName, String methodName, String args) {
        return this.invokeOverload(objectName, methodName, JsonFactory.fromJson(args));
    }

    @Override
    public Context add(Module module) {
        module.parent(this);
        this.modules.add(module);
        return this;
    }

    @Override
    public Context remove(Module module) {
        module.parent(null);
        this.modules.remove(module);
        return this;
    }

    @Override
    public Context addFirst(Module module) {
        module.parent(this);
        this.modules.addFirst(module);
        return this;
    }

    public String toString() {
        return "ContextImpl{, name='" + this.name + '\'' + '}';
    }
}

