/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Sets;
import org.boon.core.Conversions;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Criterion;
import org.boon.criteria.ObjectFilter;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.Group;
import org.boon.criteria.internal.Grouping;
import org.boon.criteria.internal.Operator;
import org.boon.criteria.internal.QueryFactory;
import org.boon.datarepo.Filter;
import org.boon.datarepo.LookupIndex;
import org.boon.datarepo.ResultSet;
import org.boon.datarepo.SearchableCollection;
import org.boon.datarepo.impl.ResultSetImpl;
import org.boon.datarepo.spi.FilterComposer;
import org.boon.datarepo.spi.ResultSetInternal;
import org.boon.datarepo.spi.SearchIndex;

public class FilterDefault
implements Filter,
FilterComposer {
    private Set<Operator> indexedOperators = Sets.set(Operator.BETWEEN, Operator.EQUAL, Operator.STARTS_WITH, Operator.GREATER_THAN, Operator.GREATER_THAN_EQUAL, Operator.LESS_THAN, Operator.LESS_THAN_EQUAL);
    private Map<String, FieldAccess> fields;
    private SearchableCollection searchableCollection;
    private Map<String, SearchIndex> searchIndexMap;
    private Map<String, LookupIndex> lookupIndexMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet filter(Criteria ... expressions) {
        try {
            Criteria.fields(this.fields);
            ResultSet resultSet = this.mainQueryPlan(expressions);
            return resultSet;
        }
        finally {
            Criteria.clearFields();
        }
    }

    private ResultSet mainQueryPlan(Criteria[] expressions) {
        ResultSetImpl results = new ResultSetImpl(this.fields);
        if (expressions == null || expressions.length == 0) {
            results.addResults(this.searchableCollection.all());
        }
        Group group = expressions.length == 1 && expressions[0] instanceof Group ? (Group)expressions[0] : ObjectFilter.and(expressions);
        this.doFilterGroup(group, results);
        return results;
    }

    private void orPlanWithIndex(Criterion criterion, ResultSetInternal results) {
        Operator operator = criterion.getOperator();
        if (operator == Operator.EQUAL && this.lookupIndexMap.get(criterion.getName()) != null) {
            this.doFilterWithIndex(criterion, this.fields, results);
        } else if (this.isIndexed(criterion.getName()) && Sets.in(operator, this.indexedOperators)) {
            this.doFilterWithIndex(criterion, this.fields, results);
        } else {
            List list = QueryFactory.filter(this.searchableCollection.all(), criterion);
            results.addResults(list);
        }
    }

    @Override
    public void invalidate() {
    }

    private void doFilterGroup(Group group, ResultSetInternal results) {
        if (group.getGrouping() == Grouping.OR) {
            this.or(group.getExpressions(), this.fields, results);
        } else {
            ResultSetImpl resultsForAnd = new ResultSetImpl(this.fields);
            this.and(group.getExpressions(), this.fields, resultsForAnd);
            results.addResults(resultsForAnd.asList());
        }
    }

    private void or(Criteria[] expressions, Map<String, FieldAccess> fields, ResultSetInternal results) {
        for (Criteria expression : expressions) {
            if (expression instanceof Criterion) {
                this.orPlanWithIndex((Criterion)expression, results);
                continue;
            }
            if (!(expression instanceof Group)) continue;
            this.doFilterGroup((Group)expression, results);
        }
    }

    private void and(Criteria[] expressions, Map<String, FieldAccess> fields, ResultSetInternal resultSet) {
        Set<Criteria> expressionSet = Sets.set(expressions);
        boolean foundIndex = this.applyIndexedFiltersForAnd(expressions, fields, expressionSet, resultSet);
        this.applyLinearSearch(expressionSet, resultSet, foundIndex);
        this.applyGroups(expressionSet, resultSet);
    }

    private boolean applyIndexedFiltersForAnd(Criteria[] expressions, Map<String, FieldAccess> fields, Set<Criteria> expressionSet, ResultSetInternal resultSet) {
        Criterion criteria = null;
        boolean foundIndex = false;
        if (expressions.length == 1 && expressions[0] instanceof Criterion) {
            criteria = (Criterion)expressions[0];
            foundIndex = this.doFilterWithIndex(criteria, fields, resultSet);
            if (foundIndex) {
                expressionSet.remove(criteria);
            }
            return foundIndex;
        }
        for (Criteria expression : expressions) {
            if (!(expression instanceof Criterion)) continue;
            criteria = (Criterion)expression;
            foundIndex = this.doFilterWithIndex(criteria, fields, resultSet);
            if (foundIndex) {
                expressionSet.remove(criteria);
            }
            if (resultSet.lastSize() < 20) {
                resultSet.andResults();
                return foundIndex;
            }
            if (resultSet.lastSize() <= 0) continue;
        }
        if (foundIndex) {
            resultSet.andResults();
        }
        return foundIndex;
    }

    private void applyGroups(Set<Criteria> expressionSet, ResultSetInternal resultSet) {
        if (expressionSet.size() == 0) {
            return;
        }
        for (Criteria expression : expressionSet) {
            if (!(expression instanceof Group)) continue;
            this.doFilterGroup((Group)expression, resultSet);
        }
    }

    private void applyLinearSearch(Set<Criteria> expressionSet, ResultSetInternal resultSet, boolean foundIndex) {
        if (expressionSet.size() == 0) {
            return;
        }
        Criteria[] expressions = Conversions.array(Criteria.class, QueryFactory.filter(expressionSet, ObjectFilter.not(ObjectFilter.instanceOf(Group.class))));
        if (foundIndex) {
            resultSet.filterAndPrune(ObjectFilter.and(expressions));
        } else {
            resultSet.addResults(QueryFactory.filter(this.searchableCollection.all(), ObjectFilter.and(expressions)));
        }
        for (Criteria expression : expressions) {
            expressionSet.remove(expression);
        }
    }

    private boolean isIndexed(String name) {
        return this.searchIndexMap.containsKey(name);
    }

    private boolean doFilterWithIndex(Criterion criterion, Map<String, FieldAccess> fields, ResultSetInternal resultSet) {
        boolean indexed = this.indexedOperators.contains((Object)criterion.getOperator());
        if (!indexed) {
            return false;
        }
        String name = criterion.getName();
        Object value = criterion.getValue();
        Operator operator = criterion.getOperator();
        SearchIndex searchIndex = this.searchIndexMap.get(name);
        LookupIndex lookupIndex = this.lookupIndexMap.get(name);
        List resultList = null;
        boolean foundIndex = false;
        if (lookupIndex != null && operator == Operator.EQUAL) {
            foundIndex = true;
            resultList = lookupIndex.getAll(value);
            if (resultList != null) {
                resultSet.addResults(resultList);
                return foundIndex;
            }
            resultSet.addResults(Collections.EMPTY_LIST);
            return foundIndex;
        }
        if (searchIndex == null) {
            return false;
        }
        foundIndex = true;
        if (!criterion.isInitialized()) {
            criterion.initByFields(this.fields);
        }
        switch (operator) {
            case EQUAL: {
                resultList = this.processResultsFromIndex(searchIndex, searchIndex.findEquals(value));
                break;
            }
            case STARTS_WITH: {
                resultList = searchIndex.findStartsWith(value);
                break;
            }
            case GREATER_THAN: {
                resultList = searchIndex.findGreaterThan(value);
                break;
            }
            case GREATER_THAN_EQUAL: {
                resultList = searchIndex.findGreaterThanEqual(value);
                break;
            }
            case LESS_THAN: {
                resultList = searchIndex.findLessThan(value);
                break;
            }
            case LESS_THAN_EQUAL: {
                resultList = searchIndex.findLessThanEqual(value);
                break;
            }
            case BETWEEN: {
                resultList = searchIndex.findBetween(criterion.getValue(), criterion.getValues()[1]);
            }
        }
        criterion.clean();
        if (resultList != null) {
            resultSet.addResults(resultList);
            return foundIndex;
        }
        return foundIndex;
    }

    private List processResultsFromIndex(SearchIndex searchIndex, List results) {
        if (searchIndex.isPrimaryKeyOnly()) {
            return null;
        }
        return results;
    }

    @Override
    public void setSearchableCollection(SearchableCollection searchableCollection) {
        this.searchableCollection = searchableCollection;
    }

    @Override
    public void setFields(Map<String, FieldAccess> fields) {
        this.fields = fields;
    }

    @Override
    public void setSearchIndexMap(Map<String, SearchIndex> searchIndexMap) {
        this.searchIndexMap = searchIndexMap;
    }

    @Override
    public void setLookupIndexMap(Map<String, LookupIndex> lookupIndexMap) {
        this.lookupIndexMap = lookupIndexMap;
    }

    @Override
    public void init() {
    }
}

