/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.core.reflection.fields.BaseField;

public class PropertyField
extends BaseField {
    final Method getter;
    final Method setter;

    public PropertyField(String name, Method setter, Method getter) {
        super(name, getter, setter);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public Object getObject(Object obj) {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (Throwable e) {
            return Exceptions.handle(Object.class, Boon.sputs("unable to call getObject for property ", this.name, "for class ", this.type), e);
        }
    }

    @Override
    public final void setObject(Object obj, Object value) {
        try {
            if (!this.isReadOnly()) {
                this.setter.invoke(obj, value);
            }
        }
        catch (Throwable e) {
            Exceptions.handle(String.format("You tried to modify property %s of %s for instance %s with set %s using %s, and this property read only status is %s", this.name, obj.getClass().getSimpleName(), obj, value, this.name(), this.isReadOnly()), e);
        }
    }

    @Override
    public final boolean getBoolean(Object obj) {
        try {
            return (Boolean)this.getObject(obj);
        }
        catch (Exception e) {
            return Exceptions.handle(Boolean.TYPE, Boon.sputs("unable to call getObject for property", this.name), e);
        }
    }

    @Override
    public final int getInt(Object obj) {
        try {
            return (Integer)this.getObject(obj);
        }
        catch (Exception e) {
            return Exceptions.handle(Integer.TYPE, Boon.sputs("unable to call getObject for property", this.name), e);
        }
    }

    @Override
    public final short getShort(Object obj) {
        try {
            return (Short)this.getObject(obj);
        }
        catch (Exception e) {
            return Exceptions.handle(Short.TYPE, Boon.sputs("unable to call getObject for property", this.name), e);
        }
    }

    @Override
    public final char getChar(Object obj) {
        try {
            return ((Character)this.getObject(obj)).charValue();
        }
        catch (Exception e) {
            return Exceptions.handle(Character.TYPE, Boon.sputs("unable to call getObject for property", this.name), e).charValue();
        }
    }

    @Override
    public final long getLong(Object obj) {
        try {
            return (Long)this.getObject(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final double getDouble(Object obj) {
        try {
            return (Double)this.getObject(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final float getFloat(Object obj) {
        try {
            return ((Float)this.getObject(obj)).floatValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final byte getByte(Object obj) {
        try {
            return (Byte)this.getObject(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Field getField() {
        return null;
    }

    @Override
    public final void setBoolean(Object obj, boolean value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setInt(Object obj, int value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setShort(Object obj, short value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setChar(Object obj, char value) {
        try {
            this.setObject(obj, Character.valueOf(value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setLong(Object obj, long value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setDouble(Object obj, double value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setFloat(Object obj, float value) {
        try {
            this.setObject(obj, Float.valueOf(value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void setByte(Object obj, byte value) {
        try {
            this.setObject(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

