/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Exceptions;
import org.boon.Lists;
import org.boon.core.Conversions;
import org.boon.core.Typ;
import org.boon.core.reflection.ClassMeta;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.MethodAccess;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.value.ValueContainer;

public class Invoker {
    public static Object invokeOverloadedFromObject(Object object, String name, Object args) {
        return Invoker.invokeOverloadedFromObject(false, null, null, object, name, args);
    }

    public static Object invokeOverloadedFromObject(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                ClassMeta classMeta = ClassMeta.classMeta(object.getClass());
                MethodAccess m = classMeta.method(name);
                if (m.parameterTypes().length == 1 && list.size() > 0) {
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map || firstArg instanceof List) {
                        return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, list);
                    }
                    return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
                }
                return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, list);
            }
            if (args == null) {
                return Invoker.invoke(object, name, new Object[0]);
            }
            return Invoker.invokeOverloadedFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "name", name, "args", args);
        }
    }

    public static Object invokeFromObject(Object object, String name, Object args) {
        return Invoker.invokeFromObject(false, null, null, object, name, args);
    }

    public static Object invokeMethodFromObjectArg(Object object, MethodAccess method, Object args) {
        return Invoker.invokeMethodFromObjectArg(false, null, null, object, method, args);
    }

    public static Object invokeMethodFromObjectArg(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, MethodAccess method, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                Class<?>[] paramTypes = method.parameterTypes();
                if (paramTypes.length == 1 && list.size() > 0) {
                    Class<?> firstParamType = paramTypes[0];
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map) {
                        return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
                    }
                    if (firstArg instanceof List && !Typ.isCollection(firstParamType) && !firstParamType.isArray()) {
                        return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
                    }
                    return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
                }
                return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, list);
            }
            if (args == null) {
                return method.invoke(object, new Object[0]);
            }
            return Invoker.invokeMethodFromList(respectIgnore, view, ignoreProperties, object, method, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "method", method, "args", args);
        }
    }

    public static Object invokeFromObject(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, Object args) {
        try {
            if (args instanceof Map) {
                return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
            }
            if (args instanceof List) {
                List list = (List)args;
                ClassMeta classMeta = ClassMeta.classMeta(object.getClass());
                MethodAccess m = classMeta.method(name);
                if (m.parameterTypes().length == 1 && list.size() > 0) {
                    Object firstArg = list.get(0);
                    if (firstArg instanceof Map || firstArg instanceof List) {
                        return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object, name, list);
                    }
                    return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
                }
                return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object, name, list);
            }
            if (args == null) {
                return Invoker.invoke(object, name, new Object[0]);
            }
            return Invoker.invokeFromList(respectIgnore, view, ignoreProperties, object, name, Lists.list(args));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "name", name, "args", args);
        }
    }

    public static Object invokeFromList(Object object, String name, List<?> args) {
        return Invoker.invokeFromList(true, null, null, object, name, args);
    }

    public static Object invokeFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, List<?> args) {
        try {
            ArrayList<Object> list = new ArrayList<Object>(args);
            ClassMeta classMeta = ClassMeta.classMeta(object.getClass());
            MethodAccess m = classMeta.method(name);
            Class[] parameterTypes = m.parameterTypes();
            if (list.size() != parameterTypes.length) {
                return Exceptions.die(Object.class, "Unable to invoke method", name, "on object", object, "with arguments", list);
            }
            FieldsAccessor fieldsAccessor = FieldAccessMode.FIELD.create(true);
            for (int index = 0; index < parameterTypes.length; ++index) {
                if (Invoker.matchAndConvertArgs(respectIgnore, view, ignoreProperties, fieldsAccessor, list, m, parameterTypes, index)) continue;
                return Exceptions.die(Object.class, "Unable to invoke method as argument types did not match", name, "on object", object, "with arguments", list);
            }
            if (args == null && m.parameterTypes().length == 0) {
                return m.invoke(object, new Object[0]);
            }
            return m.invoke(object, list.toArray(new Object[list.size()]));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "name", name, "args", args);
        }
    }

    public static Object invokeMethodFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, MethodAccess method, List<?> args) {
        try {
            ArrayList<Object> list = new ArrayList<Object>(args);
            Class[] parameterTypes = method.parameterTypes();
            if (list.size() != parameterTypes.length) {
                return Exceptions.die(Object.class, "Unable to invoke method", method.name(), "on object", object, "with arguments", list);
            }
            FieldsAccessor fieldsAccessor = FieldAccessMode.FIELD.create(true);
            for (int index = 0; index < parameterTypes.length; ++index) {
                if (Invoker.matchAndConvertArgs(respectIgnore, view, ignoreProperties, fieldsAccessor, list, method, parameterTypes, index)) continue;
                return Exceptions.die(Object.class, "Unable to invoke method as argument types did not match", method.name(), "on object", object, "with arguments", list);
            }
            if (args == null && method.parameterTypes().length == 0) {
                return method.invoke(object, new Object[0]);
            }
            return method.invoke(object, list.toArray(new Object[list.size()]));
        }
        catch (Exception ex) {
            return Exceptions.handle(Object.class, ex, "Unable to invoke method object", object, "method", method, "args", args);
        }
    }

    public static Object invokeEither(Object object, String name, Object ... args) {
        if (object instanceof Class) {
            return Invoker.invoke((Class)object, name, args);
        }
        return Invoker.invoke(object, name, args);
    }

    public static Object invoke(Object object, String name, Object ... args) {
        return ClassMeta.classMeta(object.getClass()).invoke(object, name, args);
    }

    public static MethodAccess invokeMethodAccess(Object object, String name) {
        return ClassMeta.classMeta(object.getClass()).invokeMethodAccess(name);
    }

    public static MethodAccess invokeMethodAccess(Class<?> cls, String name) {
        return ClassMeta.classMeta(cls).invokeMethodAccess(name);
    }

    public static Object invoke(Class cls, String name, Object ... args) {
        return ClassMeta.classMeta(cls).invokeStatic(name, args);
    }

    public static Object invokeOverloaded(Object object, String name, Object ... args) {
        ClassMeta classMeta = ClassMeta.classMeta(object.getClass());
        Iterable<MethodAccess> invokers = classMeta.methods(name);
        for (MethodAccess m : invokers) {
            if (!m.respondsTo(args)) continue;
            return m.invoke(object, args);
        }
        return Exceptions.die(Object.class, "Unable to invoke method", name, "on object", object, "with arguments", args);
    }

    public static Object invokeOverloadedFromList(Object object, String name, List<?> args) {
        return Invoker.invokeOverloadedFromList(true, null, null, object, name, args);
    }

    public static Object invokeOverloadedFromList(boolean respectIgnore, String view, Set<String> ignoreProperties, Object object, String name, List<?> args) {
        ClassMeta classMeta = ClassMeta.classMeta(object.getClass());
        Iterable<MethodAccess> invokers = classMeta.methods(name);
        ArrayList<Object> list = new ArrayList<Object>(args);
        FieldsAccessor fieldsAccessor = FieldAccessMode.FIELD.create(true);
        block0: for (MethodAccess m : invokers) {
            Class[] parameterTypes = m.parameterTypes();
            if (parameterTypes.length != list.size()) continue;
            for (int index = 0; index < parameterTypes.length; ++index) {
                if (!Invoker.matchAndConvertArgs(respectIgnore, view, ignoreProperties, fieldsAccessor, list, m, parameterTypes, index)) continue block0;
            }
            return m.invoke(object, list.toArray(new Object[list.size()]));
        }
        return Exceptions.die(Object.class, "Unable to invoke method", name, "on object", object, "with arguments", args);
    }

    public static void invokeMethodWithAnnotationNoReturn(Object object, String annotation) {
        Invoker.invokeMethodWithAnnotationWithReturnType(object, annotation, Void.TYPE);
    }

    public static void invokeMethodWithAnnotationWithReturnType(Object object, String annotation, Class<?> returnType) {
        Invoker.invokeMethodWithAnnotationWithReturnType(object.getClass(), object, annotation, returnType);
    }

    public static void invokeMethodWithAnnotationWithReturnType(Class<?> type, Object object, String annotation, Class<?> returnType) {
        ClassMeta classMeta = ClassMeta.classMeta(type);
        Iterable<MethodAccess> iterate = classMeta.methods();
        for (MethodAccess m : iterate) {
            if (!m.hasAnnotation(annotation) || m.parameterTypes().length != 0 || m.returnType() != Void.TYPE) continue;
            m.invoke(object, new Object[0]);
            break;
        }
    }

    public static boolean matchAndConvertArgs(boolean respectIgnore, String view, Set<String> ignoreSet, FieldsAccessor fieldsAccessor, List<Object> list, MethodAccess method, Class[] parameterTypes, int index) {
        try {
            Class paramType = parameterTypes[index];
            Object item = list.get(index);
            if (item instanceof ValueContainer) {
                item = ((ValueContainer)item).toValue();
            }
            if (Typ.isPrimitiveOrWrapper(paramType) && (item instanceof Number || item instanceof Boolean || item instanceof CharSequence)) {
                Object o = Conversions.coerceOrDie(paramType, item);
                list.set(index, o);
            } else if (item instanceof Map && !Typ.isMap(paramType)) {
                list.set(index, MapObjectConversion.fromMap(respectIgnore, view, fieldsAccessor, (Map)item, paramType, ignoreSet));
            } else if (item instanceof List && !Typ.isList(paramType)) {
                list.set(index, MapObjectConversion.fromList(fieldsAccessor, (List)item, paramType));
            } else if (Typ.isList(paramType) && item instanceof List) {
                Type type;
                List itemList = (List)item;
                if (itemList.size() > 0 && (itemList.get(0) instanceof List || itemList.get(0) instanceof ValueContainer) && (type = method.getGenericParameterTypes()[index]) instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Class componentType = (Class)pType.getActualTypeArguments()[0];
                    ArrayList newList = new ArrayList(itemList.size());
                    for (Object o : itemList) {
                        if (o instanceof ValueContainer) {
                            o = ((ValueContainer)o).toValue();
                        }
                        List fromList = (List)o;
                        o = MapObjectConversion.fromList(fieldsAccessor, fromList, componentType);
                        newList.add(o);
                    }
                    list.set(index, newList);
                }
            } else if (paramType == Typ.string && item instanceof CharSequence) {
                list.set(index, item.toString());
            } else if (paramType.isEnum() && item instanceof CharSequence | item instanceof Number) {
                list.set(index, Conversions.toEnum(paramType, item));
            } else if (!paramType.isInstance(item)) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static <T> boolean invokeBooleanReturn(Object object, T v) {
        Class<?> cls;
        Object instance = null;
        if (object instanceof Class) {
            cls = (Class<?>)object;
        } else {
            cls = object.getClass();
            instance = object;
        }
        ClassMeta meta = ClassMeta.classMeta(cls);
        return meta.invokePredicate(instance, v);
    }

    public static Object invokeReducer(Object object, Object sum, Object value) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeReducer(null, sum, value);
        }
        ClassMeta meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeReducer(object, sum, value);
    }

    public static Object invokeFunction(Object object, Object arg) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeFunction(null, arg);
        }
        ClassMeta meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeFunction(object, arg);
    }

    public static MethodAccess invokeFunctionMethodAccess(Object object) {
        if (object instanceof Class) {
            ClassMeta meta = ClassMeta.classMeta((Class)object);
            return meta.invokeFunctionMethodAccess();
        }
        ClassMeta meta = ClassMeta.classMeta(object.getClass());
        return meta.invokeFunctionMethodAccess();
    }
}

