/*
 * Decompiled with CFR 0.152.
 */
package org.boon.cache;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.boon.cache.Cache;
import org.boon.cache.CacheEntry;
import org.boon.cache.CacheType;
import org.boon.cache.SortableConcurrentList;
import org.boon.cache.Tradeoffs;
import org.boon.core.timer.TimeKeeper;
import org.boon.core.timer.TimeKeeperBasic;

public class FastConcurrentReadLruLfuFifoCache<KEY, VALUE>
implements Cache<KEY, VALUE> {
    private final ConcurrentHashMap<KEY, CacheEntry<KEY, VALUE>> map = new ConcurrentHashMap();
    private final SortableConcurrentList<CacheEntry<KEY, VALUE>> list;
    private final int evictSize;
    private final AtomicInteger count = new AtomicInteger();
    private final CacheType type;
    private final TimeKeeper timeKeeper;

    public FastConcurrentReadLruLfuFifoCache(int evictSize) {
        this.evictSize = (int)((float)evictSize + (float)evictSize * 0.2f);
        this.list = new SortableConcurrentList();
        this.type = CacheType.LFU;
        this.timeKeeper = new TimeKeeperBasic();
    }

    public FastConcurrentReadLruLfuFifoCache(int evictSize, Tradeoffs tradeoffs, CacheType type) {
        this.evictSize = (int)((float)evictSize + (float)evictSize * 0.2f);
        this.type = type;
        this.list = tradeoffs == Tradeoffs.FAST_REMOVE ? new SortableConcurrentList(new LinkedList()) : (tradeoffs == Tradeoffs.FAST_SORT ? new SortableConcurrentList(new ArrayList()) : new SortableConcurrentList());
        this.timeKeeper = new TimeKeeperBasic();
    }

    FastConcurrentReadLruLfuFifoCache(boolean test, int evictSize, CacheType type) {
        this.evictSize = (int)((float)evictSize + (float)evictSize * 0.2f);
        this.list = new SortableConcurrentList();
        this.type = type;
        this.timeKeeper = new TimeKeeper(){
            int i;

            @Override
            public long time() {
                return System.currentTimeMillis() + (long)this.i++;
            }
        };
    }

    @Override
    public VALUE get(KEY key) {
        CacheEntry<KEY, VALUE> cacheEntry = this.map.get(key);
        if (cacheEntry != null) {
            cacheEntry.readCount.incrementAndGet();
            return cacheEntry.value;
        }
        return null;
    }

    @Override
    public VALUE getSilent(KEY key) {
        CacheEntry<KEY, VALUE> cacheEntry = this.map.get(key);
        if (cacheEntry != null) {
            return cacheEntry.value;
        }
        return null;
    }

    @Override
    public void remove(KEY key) {
        CacheEntry<KEY, VALUE> entry = this.map.remove(key);
        if (entry != null) {
            this.list.remove(entry);
        }
    }

    @Override
    public void put(KEY key, VALUE value) {
        CacheEntry<KEY, VALUE> entry = this.map.get(key);
        if (entry == null) {
            entry = new CacheEntry<KEY, VALUE>(key, value, this.order(), this.type, this.time());
            this.list.add(entry);
            this.map.put(key, entry);
        } else {
            entry.readCount.incrementAndGet();
            entry.value = value;
        }
        this.evictIfNeeded();
    }

    private long time() {
        return this.timeKeeper.time();
    }

    private final int order() {
        int order = this.count.incrementAndGet();
        if (order > 2147483547) {
            this.count.set(0);
        }
        return order;
    }

    private final void evictIfNeeded() {
        if (this.list.size() > this.evictSize) {
            List<CacheEntry<KEY, VALUE>> killList = this.list.sortAndReturnPurgeList(0.1f);
            for (CacheEntry<KEY, VALUE> cacheEntry : killList) {
                this.map.remove(cacheEntry.key);
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

