/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.boon.Boon;
import org.boon.Sets;
import org.boon.Str;
import org.boon.primitive.Arry;
import org.boon.primitive.CharBuf;

public class Exceptions {
    private static final Set<String> ignorePackages = Sets.set("sun.", "com.sun.", "javax.java", "java.", "oracle.", "com.oracle.", "org.junit", "org.boon.", "com.intellij");

    public static void requireNonNull(Object obj) {
        if (obj == null) {
            Exceptions.die("Required object assertion exception");
        }
    }

    public static void requireNonNulls(String message, Object ... array) {
        int index = 0;
        for (Object obj : array) {
            if (obj == null) {
                Exceptions.die(message, index);
            }
            ++index;
        }
    }

    public static void dieIfAnyParametersAreNull(String methodName, Object ... parameters) {
        Exceptions.requireNonNull(Boon.sputs("METHOD", methodName, "Parameter at index was null: index="));
    }

    public static void requireNonNull(Object obj, String message) {
        if (obj == null) {
            Exceptions.die(message);
        }
    }

    public static boolean die() {
        throw new SoftenedException("died");
    }

    public static boolean die(String message) {
        throw new SoftenedException(message);
    }

    public static boolean die(Object ... messages) {
        throw new SoftenedException(Boon.sputs(messages));
    }

    public static <T> T die(Class<T> clazz, String message) {
        throw new SoftenedException(message);
    }

    public static <T> T die(Class<T> clazz, Object ... messages) {
        throw new SoftenedException(Boon.sputs(messages));
    }

    public static void handle(Exception e) {
        throw new SoftenedException(e);
    }

    public static <T> T handle(Class<T> clazz, Exception e) {
        if (e instanceof SoftenedException) {
            throw (SoftenedException)e;
        }
        throw new SoftenedException(e);
    }

    public static <T> T handle(Class<T> clazz, String message, Throwable e) {
        throw new SoftenedException(message, e);
    }

    public static <T> T handle(Class<T> clazz, Throwable e, Object ... messages) {
        throw new SoftenedException(Boon.sputs(messages), e);
    }

    public static void handle(Throwable e, Object ... messages) {
        throw new SoftenedException(Boon.sputs(messages), e);
    }

    public static void printStackTrace(CharBuf charBuf, StackTraceElement[] stackTrace) {
        for (StackTraceElement st : stackTrace) {
            if (st.getClassName().contains("org.boon.Exceptions")) continue;
            charBuf.indent(10).println(st);
        }
    }

    public static <T> T tryIt(Class<T> clazz, TrialWithReturn<T> tryIt) {
        try {
            return tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(ex);
        }
    }

    public static void tryIt(Trial tryIt) {
        try {
            tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(ex);
        }
    }

    public static void handle(String message, Throwable e) {
        throw new SoftenedException(message, e);
    }

    public static void tryIt(String message, Trial tryIt) {
        try {
            tryIt.tryIt();
        }
        catch (Exception ex) {
            throw new SoftenedException(message, ex);
        }
    }

    public static StackTraceElement[] getFilteredStackTrace(StackTraceElement[] stackTrace) {
        if (stackTrace == null || stackTrace.length == 0) {
            return new StackTraceElement[0];
        }
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        HashSet<String> seenThisBefore = new HashSet<String>();
        for (StackTraceElement st : stackTrace) {
            String key;
            if (Str.startsWithItemInCollection(st.getClassName(), ignorePackages) || seenThisBefore.contains(key = Boon.sputs(st.getClassName(), st.getFileName(), st.getMethodName(), st.getLineNumber()))) continue;
            seenThisBefore.add(key);
            list.add(st);
        }
        return Arry.array(StackTraceElement.class, list);
    }

    public static String toString(Exception ex) {
        StackTraceElement[] stackTrace;
        CharBuf buffer = CharBuf.create(255);
        buffer.addLine(ex.getLocalizedMessage());
        for (StackTraceElement element : stackTrace = ex.getStackTrace()) {
            buffer.add(element.getClassName());
            Boon.sputs("      ", buffer, "class", element.getClassName(), "method", element.getMethodName(), "line", element.getLineNumber());
        }
        return buffer.toString();
    }

    public static String asJson(Exception ex) {
        CharBuf buffer = CharBuf.create(255);
        buffer.add('{');
        buffer.addLine().indent(5).addJsonFieldName("message").asJsonString(ex.getMessage()).addLine(Character.valueOf(','));
        StackTraceElement[] stackTrace = Exceptions.getFilteredStackTrace(ex.getStackTrace());
        if (stackTrace != null && stackTrace.length > 0) {
            buffer.addLine().indent(5).addJsonFieldName("stackTrace").addLine();
            Exceptions.stackTraceToJson(buffer, stackTrace);
            buffer.add(',');
        }
        buffer.addLine().indent(5).addJsonFieldName("fullStackTrace").addLine();
        stackTrace = ex.getStackTrace();
        Exceptions.stackTraceToJson(buffer, stackTrace);
        buffer.add('}');
        return buffer.toString();
    }

    public static void stackTraceToJson(CharBuf buffer, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            buffer.addLine("[]");
            return;
        }
        buffer.multiply(' ', 16).addLine(Character.valueOf('['));
        for (int index = 0; index < stackTrace.length; ++index) {
            StackTraceElement element = stackTrace[index];
            if (element.getClassName().contains("org.boon.Exceptions")) continue;
            buffer.indent(17).add("[  ").asJsonString(element.getMethodName()).add(',');
            buffer.indent(3).asJsonString(element.getClassName());
            if (element.getLineNumber() > 0) {
                buffer.add(",");
                buffer.indent(3).asJsonString("" + element.getLineNumber()).addLine("   ],");
                continue;
            }
            buffer.addLine(" ],");
        }
        buffer.removeLastChar();
        buffer.removeLastChar();
        buffer.addLine().multiply(' ', 15).add(']');
    }

    public static class SoftenedException
    extends RuntimeException {
        public SoftenedException(String message) {
            super(message);
        }

        public SoftenedException(String message, Throwable cause) {
            super(message, cause);
        }

        public SoftenedException(Throwable cause) {
            super("Wrapped Exception", cause);
        }

        @Override
        public String getMessage() {
            return super.getMessage() + (this.getCause() == null ? "" : this.getCauseMessage());
        }

        private String getCauseMessage() {
            return "\n CAUSE " + this.getCause().getClass().getName() + " :: " + this.getCause().getMessage();
        }

        @Override
        public String getLocalizedMessage() {
            return this.getMessage();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (this.getRootCause() != null) {
                return Arry.add(this.getRootCause().getStackTrace(), super.getStackTrace());
            }
            return super.getStackTrace();
        }

        @Override
        public Throwable getCause() {
            return super.getCause();
        }

        public Throwable getRootCause() {
            Throwable lastCause = super.getCause();
            for (Throwable cause = super.getCause(); cause != null; cause = cause.getCause()) {
                lastCause = cause;
            }
            return lastCause;
        }

        public void printStackTrace(CharBuf charBuf) {
            charBuf.puts("MESSAGE:", this.getMessage());
            if (this.getRootCause() != null) {
                charBuf.puts("ROOT CAUSE MESSAGE:", this.getRootCause().getMessage());
            } else if (this.getCause() != null) {
                charBuf.puts("CAUSE MESSAGE:", this.getCause().getMessage());
            }
            StackTraceElement[] stackTrace = this.getFilteredStackTrace();
            if (stackTrace.length > 0) {
                charBuf.indent(5).addLine("This happens around this area in your code.");
                Exceptions.printStackTrace(charBuf, stackTrace);
            }
            if (this.getRootCause() != null) {
                charBuf.addLine().puts("Caused by:", "message:", this.getRootCause().getMessage(), "type", this.getRootCause().getClass().getName());
                stackTrace = this.getRootCause().getStackTrace();
                Exceptions.printStackTrace(charBuf, stackTrace);
            }
            charBuf.addLine().multiply('-', 50).addLine().multiply('-', 50).addLine();
            StringWriter writer = new StringWriter();
            super.printStackTrace(new PrintWriter(writer));
            charBuf.add(writer);
            charBuf.addLine().multiply('-', 50).addLine();
        }

        public StackTraceElement[] getFilteredStackTrace() {
            StackTraceElement[] filteredStackTrace = Exceptions.getFilteredStackTrace(super.getStackTrace());
            if (filteredStackTrace.length > 0) {
                StackTraceElement[] cause;
                if (super.getCause() != null && (cause = Exceptions.getFilteredStackTrace(super.getCause().getStackTrace())).length > 0) {
                    filteredStackTrace = Arry.add(cause, filteredStackTrace);
                }
            } else if (super.getCause() != null) {
                filteredStackTrace = Exceptions.getFilteredStackTrace(super.getCause().getStackTrace());
            }
            return Exceptions.getFilteredStackTrace(super.getStackTrace());
        }

        public CharBuf printStackTraceIntoCharBuf() {
            CharBuf out = CharBuf.create(100);
            this.printStackTrace(out);
            return out;
        }

        @Override
        public void printStackTrace(PrintStream s) {
            s.print(this.printStackTraceIntoCharBuf().toString());
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.print(this.printStackTraceIntoCharBuf().toString());
        }

        @Override
        public void printStackTrace() {
            System.err.print(this.printStackTraceIntoCharBuf().toString());
        }
    }

    public static interface TrialWithReturn<T> {
        public T tryIt() throws Exception;
    }

    public static interface Trial {
        public void tryIt() throws Exception;
    }
}

