/*
 * Copyright 2013-2014 Richard M. Hightower
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * __________                              _____          __   .__
 * \______   \ ____   ____   ____   /\    /     \ _____  |  | _|__| ____    ____
 *  |    |  _//  _ \ /  _ \ /    \  \/   /  \ /  \\__  \ |  |/ /  |/    \  / ___\
 *  |    |   (  <_> |  <_> )   |  \ /\  /    Y    \/ __ \|    <|  |   |  \/ /_/  >
 *  |______  /\____/ \____/|___|  / \/  \____|__  (____  /__|_ \__|___|  /\___  /
 *         \/                   \/              \/     \/     \/       \//_____/
 *      ____.                     ___________   _____    ______________.___.
 *     |    |____ ___  _______    \_   _____/  /  _  \  /   _____/\__  |   |
 *     |    \__  \\  \/ /\__  \    |    __)_  /  /_\  \ \_____  \  /   |   |
 * /\__|    |/ __ \\   /  / __ \_  |        \/    |    \/        \ \____   |
 * \________(____  /\_/  (____  / /_______  /\____|__  /_______  / / ______|
 *               \/           \/          \/         \/        \/  \/
 */
package org.boon.datarepo;

import org.boon.criteria.internal.Criteria;
import org.boon.criteria.Selector;
import org.boon.sort.Sort;
import org.boon.criteria.internal.Visitor;
import org.boon.datarepo.spi.SearchIndex;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface SearchableCollection<KEY, ITEM> extends Collection<ITEM> {

    ITEM get( KEY key );

    KEY getKey( ITEM item );

    void invalidateIndex( String property, ITEM item );

    void validateIndex( String property, ITEM item );

    public void validateIndexes( ITEM item );

    int count( KEY key, String property, int value );

    int count( KEY key, String property, short value );

    int count( KEY key, String property, byte value );

    int count( KEY key, String property, long value );

    int count( KEY key, String property, char value );

    int count( KEY key, String property, float value );

    int count( KEY key, String property, double value );

    int count( KEY key, String property, Object value );

    <T> T max( KEY key, String property, Class<T> type );

    String maxString( KEY key, String property );

    Number maxNumber( KEY key, String property );

    int maxInt( KEY key, String property );

    long maxLong( KEY key, String property );

    double maxDouble( KEY key, String property );

    <T> T min( KEY key, String property, Class<T> type );

    String minString( KEY key, String property );

    Number minNumber( KEY key, String property );

    int minInt( KEY key, String property );

    long minLong( KEY key, String property );

    double minDouble( KEY key, String property );


    ResultSet<ITEM> results( Criteria... expressions );

    List<ITEM> query( Criteria... expressions );

    List<ITEM> sortedQuery( String sortBy, Criteria... expressions );

    List<ITEM> sortedQuery( Sort sortBy, Criteria... expressions );

    List<Map<String, Object>> queryAsMaps( Criteria... expressions );

    List<Map<String, Object>> query( List<Selector> selectors, Criteria... expressions );

    List<Map<String, Object>> sortedQuery( String sortBy, List<Selector> selectors, Criteria... expressions );

    List<Map<String, Object>> sortedQuery( Sort sortBy, List<Selector> selectors, Criteria... expressions );

    void query( Visitor<KEY, ITEM> visitor, Criteria... expressions );

    void sortedQuery( Visitor<KEY, ITEM> visitor, String sortBy, Criteria... expressions );

    void sortedQuery( Visitor<KEY, ITEM> visitor, Sort sortBy, Criteria... expressions );


    boolean delete( ITEM item );


    void addSearchIndex( String name, SearchIndex<?, ?> si );

    void addLookupIndex( String name, LookupIndex<?, ?> si );


    List<ITEM> all();

    void removeByKey( KEY key );

}
