/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.taiga;

import io.fabric8.taiga.TaigaClientSupport;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.WebClients;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public class TaigaClient
extends TaigaClientSupport {
    public TaigaClient(String address, String username, String password) {
        super(address, username, password);
    }

    @Override
    protected <T> T createWebClient(Class<T> clientType) {
        List providers = WebClients.createProviders();
        providers.add(new Authenticator());
        WebClient webClient = WebClient.create((String)this.address, (List)providers);
        WebClients.disableSslChecks((WebClient)webClient);
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    protected class Authenticator
    implements ClientRequestFilter {
        protected Authenticator() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String authenticationHeader = this.getAuthenticationHeader();
            if (Strings.isNotBlank((String)authenticationHeader)) {
                headers.add((Object)"Authorization", (Object)authenticationHeader);
            }
        }

        private String getAuthenticationHeader() {
            String token = TaigaClient.this.getAuthToken();
            if (Strings.isNotBlank((String)token)) {
                return "Bearer " + token;
            }
            return null;
        }
    }
}

