/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container;

import io.fabric8.runtime.container.ContainerConfiguration;
import java.io.File;
import java.util.ServiceLoader;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.runtime.RuntimeType;

public abstract class ContainerConfigurationBuilder {
    public static ContainerConfigurationBuilder create(RuntimeType type) {
        ServiceLoader<ContainerConfigurationBuilder> loader = ServiceLoader.load(ContainerConfigurationBuilder.class);
        for (ContainerConfigurationBuilder configurationBuilder : loader) {
            ContainerConfiguration auxconfig = configurationBuilder.internalConfiguration();
            if (auxconfig.getRuntimeType() != type) continue;
            return configurationBuilder;
        }
        throw new IllegalStateException("Cannot obtain container configuration service for: " + type);
    }

    protected abstract ContainerConfiguration internalConfiguration();

    public ContainerConfigurationBuilder addMavenCoordinates(MavenCoordinates coordinates) {
        this.internalConfiguration().addMavenCoordinates(coordinates);
        return this;
    }

    public ContainerConfigurationBuilder setTargetDirectory(String target) {
        this.internalConfiguration().setTargetDirectory(new File(target).getAbsoluteFile());
        return this;
    }

    public ContainerConfigurationBuilder setJavaVmArguments(String javaVmArguments) {
        this.internalConfiguration().setJavaVmArguments(javaVmArguments);
        return this;
    }

    public ContainerConfigurationBuilder setOutputToConsole(boolean outputToConsole) {
        this.internalConfiguration().setOutputToConsole(outputToConsole);
        return this;
    }

    public ContainerConfiguration getConfiguration() {
        ContainerConfiguration configuration = this.internalConfiguration();
        configuration.validate();
        configuration.makeImmutable();
        return configuration;
    }
}

