/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import io.fabric8.process.spring.boot.registry.ProcessRegistry;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeProcessRegistry
implements ProcessRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeProcessRegistry.class);
    private final List<ProcessRegistry> registries;

    public CompositeProcessRegistry(ProcessRegistry ... registries) {
        this(Arrays.asList(registries));
    }

    public CompositeProcessRegistry(List<ProcessRegistry> registries) {
        this.registries = registries;
        LOG.debug("Created composite registry delegating to the following registries: {}", registries);
    }

    @Override
    public String readProperty(String key) {
        LOG.debug("Resolving property: {}", (Object)key);
        for (ProcessRegistry processRegistry : this.registries) {
            String propertyValue = processRegistry.readProperty(key);
            if (propertyValue == null) continue;
            LOG.debug("Found property {} with value {} in registry {}.", new Object[]{key, propertyValue, processRegistry});
            return propertyValue;
        }
        LOG.debug("Property {} not found in any of the registries.");
        return null;
    }
}

