/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.fabric8.process.spring.boot.data.AbstractQuery;
import io.fabric8.process.spring.boot.data.RestRepository;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.client.RestTemplate;

public class TemplateRestRepository<T, ID extends Serializable>
implements RestRepository<T, ID> {
    private final Class<T> entityClass;
    private final Class<T[]> arrayOfEntityClass;
    private final URL url;
    private final RestTemplate restTemplate;

    public TemplateRestRepository(Class<T> entityClass, String url) throws MalformedURLException {
        this(entityClass, new URL(url));
    }

    public TemplateRestRepository(Class<T> entityClass, URL url) {
        this.entityClass = entityClass;
        this.arrayOfEntityClass = Array.newInstance(entityClass, 0).getClass();
        this.url = url;
        this.restTemplate = new RestTemplate();
    }

    @Override
    public Iterable<T> findByQuery(AbstractQuery query) {
        return Arrays.asList((Object[])this.restTemplate.postForObject(this.url + "-ops/searchByQuery", (Object)query, this.arrayOfEntityClass, new Object[0]));
    }

    @Override
    public long countByQuery(AbstractQuery query) {
        return (Long)this.restTemplate.postForObject(this.url + "-ops/countByQuery", (Object)query, Long.class, new Object[0]);
    }

    public Iterable<T> findAll(Sort orders) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public Page<T> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public <S extends T> S save(S s) {
        try {
            URI location = this.restTemplate.postForLocation(this.url.toURI(), s);
            Long id = Long.parseLong(location.toString().replace(this.url + "/", ""));
            this.updateId(s, id);
            return s;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return Iterables.transform(entities, (Function)new Function<S, S>(){

            public S apply(S entity) {
                return TemplateRestRepository.this.save(entity);
            }
        });
    }

    public T findOne(ID id) {
        Object s = this.restTemplate.getForObject(this.url + "/" + id, this.entityClass, new Object[0]);
        this.updateId(s, id);
        return (T)s;
    }

    public boolean exists(ID id) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public Iterable<T> findAll() {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public long count() {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public void delete(ID id) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public void delete(T t) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public void delete(Iterable<? extends T> ts) {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Not *yet* supported.");
    }

    protected void updateId(T entity, ID id) {
        try {
            Field idField = this.entityClass.getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(entity, id);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

