/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.container;

import io.fabric8.process.spring.boot.container.FabricSpringApplicationConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

public class FabricSpringApplication {
    public static final String WEB_PROPERTY_KEY = "io.fabric8.process.spring.boot.container.web";
    public static final String[] NO_ARGUMENTS = new String[0];
    private ConfigurableApplicationContext parent;
    private Boolean web;

    public ConfigurableApplicationContext run(String ... args) {
        SpringApplicationBuilder applicationBuilder = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{FabricSpringApplicationConfiguration.class});
        if (this.parent != null) {
            applicationBuilder.parent(this.parent);
        }
        this.resolveWebEnvironment(applicationBuilder);
        return applicationBuilder.run(args);
    }

    public static void main(String[] args) {
        new FabricSpringApplication().run(args);
    }

    protected void resolveWebEnvironment(SpringApplicationBuilder applicationBuilder) {
        String webSystemProperty = System.getProperty(WEB_PROPERTY_KEY);
        if (webSystemProperty != null) {
            applicationBuilder.web(Boolean.parseBoolean(webSystemProperty));
        } else if (this.web != null) {
            applicationBuilder.web(this.web.booleanValue());
        }
    }

    public FabricSpringApplication parent(ConfigurableApplicationContext parent) {
        this.parent = parent;
        return this;
    }

    public FabricSpringApplication web(boolean web) {
        this.web = web;
        return this;
    }
}

