/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.container;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.ResourceLoader;

public class ComponentScanningApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentScanningApplicationContextInitializer.class);
    public static final String BASE_PACKAGE_PROPERTY_KEY = "spring.main.sources";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        LOG.debug("Initializing Fabric Spring Boot component scanner...");
        String basePackage = System.getProperty(BASE_PACKAGE_PROPERTY_KEY);
        if (basePackage != null) {
            LOG.debug("Found base package definition: {}={}", (Object)BASE_PACKAGE_PROPERTY_KEY, (Object)basePackage);
            ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)applicationContext, true);
            scanner.setResourceLoader((ResourceLoader)applicationContext);
            scanner.scan(new String[]{basePackage});
        } else {
            LOG.debug("No base package definition ({}) found.", (Object)BASE_PACKAGE_PROPERTY_KEY);
        }
    }
}

