/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support.command;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.fabric8.process.manager.support.command.CommandFailedException;
import io.fabric8.process.manager.support.command.CommandTimeoutException;
import io.fabric8.process.manager.support.command.Duration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Command {
    private static final ImmutableSet<Integer> DEFAULT_SUCCESSFUL_EXIT_CODES = ImmutableSet.of((Object)0);
    private static final File DEFAULT_DIRECTORY = new File(".").getAbsoluteFile();
    private static final Duration DEFAULT_TIME_LIMIT = new Duration(365.0, TimeUnit.DAYS);
    private final List<String> command;
    private final Set<Integer> successfulExitCodes;
    private final File directory;
    private final Map<String, String> environment;
    private final Duration timeLimit;

    public Command(String ... command) {
        this((List<String>)ImmutableList.copyOf(Arrays.asList(command)), (Set<Integer>)DEFAULT_SUCCESSFUL_EXIT_CODES, DEFAULT_DIRECTORY, (Map<String, String>)ImmutableMap.of(), DEFAULT_TIME_LIMIT);
    }

    public Command(List<String> command, Set<Integer> successfulExitCodes, File directory, Map<String, String> environment, Duration timeLimit) {
        Preconditions.checkNotNull(command, (Object)"command is null");
        Preconditions.checkArgument((!command.isEmpty() ? 1 : 0) != 0, (Object)"command is empty");
        Preconditions.checkNotNull(successfulExitCodes, (Object)"successfulExitCodes is null");
        Preconditions.checkArgument((!successfulExitCodes.isEmpty() ? 1 : 0) != 0, (Object)"successfulExitCodes is empty");
        Preconditions.checkNotNull((Object)directory, (Object)"directory is null");
        Preconditions.checkNotNull((Object)timeLimit, (Object)"timeLimit is null");
        this.command = ImmutableList.copyOf(command);
        this.successfulExitCodes = ImmutableSet.copyOf(successfulExitCodes);
        this.directory = directory;
        this.environment = environment;
        this.timeLimit = timeLimit;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Command addArgs(String ... args) {
        Preconditions.checkNotNull((Object)args, (Object)"args is null");
        return this.addArgs((Iterable<String>)ImmutableList.copyOf(Arrays.asList(args)));
    }

    public Command addArgs(Iterable<String> args) {
        Preconditions.checkNotNull(args, (Object)"args is null");
        ImmutableList.Builder command = ImmutableList.builder().addAll(this.command).addAll(args);
        return new Command((List<String>)command.build(), this.successfulExitCodes, this.directory, this.environment, this.timeLimit);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Command addEnvironment(String name, String value) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.environment).put((Object)name, (Object)value);
        return new Command(this.command, this.successfulExitCodes, this.directory, (Map<String, String>)builder.build(), this.timeLimit);
    }

    public Command addEnvironment(Map<String, String> environment) {
        Preconditions.checkNotNull(environment, (Object)"environment is null");
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.environment).putAll(environment);
        return new Command(this.command, this.successfulExitCodes, this.directory, (Map<String, String>)builder.build(), this.timeLimit);
    }

    public Set<Integer> getSuccessfulExitCodes() {
        return this.successfulExitCodes;
    }

    public Command setSuccessfulExitCodes(int ... successfulExitCodes) {
        Preconditions.checkNotNull((Object)successfulExitCodes, (Object)"successfulExitCodes is null");
        return this.setSuccessfulExitCodes((Set<Integer>)ImmutableSet.copyOf((Collection)Ints.asList((int[])successfulExitCodes)));
    }

    public Command setSuccessfulExitCodes(Set<Integer> successfulExitCodes) {
        Preconditions.checkNotNull(successfulExitCodes, (Object)"successfulExitCodes is null");
        Preconditions.checkArgument((!successfulExitCodes.isEmpty() ? 1 : 0) != 0, (Object)"successfulExitCodes is empty");
        return new Command(this.command, successfulExitCodes, this.directory, this.environment, this.timeLimit);
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(String directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"directory is null");
        return this.setDirectory(new File(directory));
    }

    public Command setDirectory(File directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"directory is null");
        return new Command(this.command, this.successfulExitCodes, directory, this.environment, this.timeLimit);
    }

    public Duration getTimeLimit() {
        return this.timeLimit;
    }

    public Command setTimeLimit(double value, TimeUnit timeUnit) {
        return this.setTimeLimit(new Duration(value, timeUnit));
    }

    public Command setTimeLimit(Duration timeLimit) {
        Preconditions.checkNotNull((Object)timeLimit, (Object)"timeLimit is null");
        return new Command(this.command, this.successfulExitCodes, this.directory, this.environment, timeLimit);
    }

    public int execute(Executor executor) throws CommandFailedException {
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull(this.command, (Object)"command is null");
        ProcessCallable processCallable = new ProcessCallable(this, executor);
        ListenableFuture<Integer> future = Command.submit(executor, processCallable);
        try {
            Integer result = (Integer)future.get((long)this.timeLimit.toMillis(), TimeUnit.MILLISECONDS);
            return result;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CommandFailedException.class);
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new CommandFailedException(this, "unexpected exception", cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandFailedException(this, "interrupted", e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new CommandTimeoutException(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command other = (Command)o;
        if (!this.command.equals(other.command)) {
            return false;
        }
        if (!this.directory.equals(other.directory)) {
            return false;
        }
        if (!this.successfulExitCodes.equals(other.successfulExitCodes)) {
            return false;
        }
        return this.timeLimit.equals(other.timeLimit);
    }

    public int hashCode() {
        int result = this.command.hashCode();
        result = 31 * result + this.successfulExitCodes.hashCode();
        result = 31 * result + this.directory.hashCode();
        result = 31 * result + this.timeLimit.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Command");
        sb.append("{command=").append(this.command);
        sb.append(", successfulExitCodes=").append(this.successfulExitCodes);
        sb.append(", directory=").append(this.directory);
        sb.append(", timeLimit=").append(this.timeLimit);
        sb.append('}');
        return sb.toString();
    }

    public void logOutput(String out) {
        System.out.println(out);
    }

    private static <T> ListenableFuture<T> submit(Executor executor, Callable<T> task) {
        ListenableFutureTask future = ListenableFutureTask.create(task);
        executor.execute((Runnable)future);
        return future;
    }

    private static class OutputProcessor {
        private final InputStream inputStream;
        private final Executor executor;
        private Future<String> outputFuture;

        private OutputProcessor(Process process, Executor executor) {
            this.inputStream = process.getInputStream();
            this.executor = executor;
        }

        public void start() {
            this.outputFuture = Command.submit(this.executor, new Callable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String call() throws IOException {
                    StringBuffer buffer = new StringBuffer();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(OutputProcessor.this.inputStream, Charsets.UTF_8));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line).append("\n");
                            System.out.println(line);
                        }
                        String string = buffer.toString();
                        return string;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)reader);
                    }
                }
            });
        }

        private String getOutput() {
            while (this.outputFuture != null && !this.outputFuture.isCancelled()) {
                try {
                    return this.outputFuture.get();
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        private void destroy() {
            Closeables.closeQuietly((Closeable)this.inputStream);
            if (this.outputFuture != null) {
                this.outputFuture.cancel(true);
            }
        }
    }

    private static class ProcessCallable
    implements Callable<Integer> {
        private final Command command;
        private final Executor executor;

        public ProcessCallable(Command command, Executor executor) {
            this.command = command;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws CommandFailedException, InterruptedException {
            Process process;
            ProcessBuilder processBuilder = new ProcessBuilder(this.command.getCommand());
            processBuilder.directory(this.command.getDirectory());
            processBuilder.redirectErrorStream(true);
            Map<String, String> processenv = processBuilder.environment();
            Set<Map.Entry<String, String>> entries = this.command.getEnvironment().entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String name = entry.getKey();
                String value = entry.getValue();
                if ("__unset".equals(value)) {
                    processenv.remove(name);
                    continue;
                }
                processenv.put(name, value);
            }
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                throw new CommandFailedException(this.command, "failed to start", e);
            }
            OutputProcessor outputProcessor = null;
            try {
                outputProcessor = new OutputProcessor(process, this.executor);
                outputProcessor.start();
                int exitCode = process.waitFor();
                if (!this.command.getSuccessfulExitCodes().contains(exitCode)) {
                    String out = outputProcessor.getOutput();
                    throw new CommandFailedException(this.command, exitCode, out);
                }
                Integer n = exitCode;
                return n;
            }
            finally {
                try {
                    process.destroy();
                }
                finally {
                    if (outputProcessor != null) {
                        outputProcessor.destroy();
                    }
                }
            }
        }
    }
}

