/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.fabric8.api.Container;
import io.fabric8.process.manager.DownloadStrategy;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InstallOptions
implements Serializable {
    private static final long serialVersionUID = 4943127368399800099L;
    public static final String DEFAULT_EXTRACT_CMD = "tar zxf";
    private final String id;
    private final String name;
    private final URL url;
    private final URL controllerUrl;
    private final String controllerJson;
    private final String extractCmd;
    private final String[] postUnpackCmds;
    private final String[] postInstallCmds;
    private final boolean offline;
    private final String[] optionalDependencyPatterns;
    private final String[] excludeDependencyFilterPatterns;
    private final String mainClass;
    private final Map<String, Object> properties;
    private final Map<String, String> environment;
    private final String[] jvmOptions;
    private final Map<String, File> jarFiles;
    private final Container container;
    private final DownloadStrategy downloadStrategy;

    public static InstallOptionsBuilder builder() {
        return new InstallOptionsBuilder();
    }

    public InstallOptions(String id, String name, URL url, URL controllerUrl, String controllerJson, String extractCmd, String[] postUnpackCmds, String[] postInstallCmds, boolean offline, String[] optionalDependencyPatterns, String[] excludeDependencyFilterPatterns, String mainClass, Map<String, Object> properties, Map<String, String> environment, String[] jvmOptions, Map<String, File> jarFiles, Container container, DownloadStrategy downloadStrategy) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.controllerUrl = controllerUrl;
        this.controllerJson = controllerJson;
        this.extractCmd = extractCmd;
        this.postUnpackCmds = postUnpackCmds;
        this.postInstallCmds = postInstallCmds;
        this.offline = offline;
        this.optionalDependencyPatterns = optionalDependencyPatterns;
        this.excludeDependencyFilterPatterns = excludeDependencyFilterPatterns;
        this.mainClass = mainClass;
        this.properties = properties;
        this.environment = environment;
        this.jvmOptions = jvmOptions;
        this.jarFiles = jarFiles;
        this.container = container;
        this.downloadStrategy = downloadStrategy;
    }

    public String toString() {
        return "InstallOptions{id='" + this.id + '\'' + ", url=" + this.url + ", mainClass='" + this.mainClass + '\'' + ", properties=" + this.properties + ", environment=" + this.environment + ", jvmOptions=" + Arrays.toString(this.jvmOptions) + ", jarFiles=" + this.jarFiles + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallOptions that = (InstallOptions)o;
        if (this.offline != that.offline) {
            return false;
        }
        if (this.controllerJson != null ? !this.controllerJson.equals(that.controllerJson) : that.controllerJson != null) {
            return false;
        }
        if (this.controllerUrl != null ? !this.controllerUrl.equals(that.controllerUrl) : that.controllerUrl != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (!Arrays.equals(this.excludeDependencyFilterPatterns, that.excludeDependencyFilterPatterns)) {
            return false;
        }
        if (this.extractCmd != null ? !this.extractCmd.equals(that.extractCmd) : that.extractCmd != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.jarFiles != null ? !this.jarFiles.equals(that.jarFiles) : that.jarFiles != null) {
            return false;
        }
        if (!Arrays.equals(this.jvmOptions, that.jvmOptions)) {
            return false;
        }
        if (this.mainClass != null ? !this.mainClass.equals(that.mainClass) : that.mainClass != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!Arrays.equals(this.optionalDependencyPatterns, that.optionalDependencyPatterns)) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.controllerUrl != null ? this.controllerUrl.hashCode() : 0);
        result = 31 * result + (this.controllerJson != null ? this.controllerJson.hashCode() : 0);
        result = 31 * result + (this.extractCmd != null ? this.extractCmd.hashCode() : 0);
        result = 31 * result + (this.offline ? 1 : 0);
        result = 31 * result + (this.optionalDependencyPatterns != null ? Arrays.hashCode(this.optionalDependencyPatterns) : 0);
        result = 31 * result + (this.excludeDependencyFilterPatterns != null ? Arrays.hashCode(this.excludeDependencyFilterPatterns) : 0);
        result = 31 * result + (this.mainClass != null ? this.mainClass.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        result = 31 * result + (this.jvmOptions != null ? Arrays.hashCode(this.jvmOptions) : 0);
        result = 31 * result + (this.jarFiles != null ? this.jarFiles.hashCode() : 0);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getControllerUrl() {
        return this.controllerUrl;
    }

    public String getControllerJson() {
        return this.controllerJson;
    }

    public String getExtractCmd() {
        return this.extractCmd;
    }

    public String[] getPostUnpackCmds() {
        return this.postUnpackCmds;
    }

    public String[] getPostInstallCmds() {
        return this.postInstallCmds;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String[] getExcludeDependencyFilterPatterns() {
        return this.excludeDependencyFilterPatterns;
    }

    public String[] getOptionalDependencyPatterns() {
        return this.optionalDependencyPatterns;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String[] getJvmOptions() {
        return this.jvmOptions;
    }

    public Map<String, File> getJarFiles() {
        return this.jarFiles;
    }

    public Container getContainer() {
        return this.container;
    }

    public DownloadStrategy getDownloadStrategy() {
        return this.downloadStrategy;
    }

    public static class InstallOptionsBuilder<T extends InstallOptionsBuilder> {
        private String id;
        private String name;
        private URL url;
        private URL controllerUrl;
        private String controllerJson;
        private String extractCmd = "tar zxf";
        private String[] postUnpackCmds;
        private String[] postInstallCmds;
        private String groupId;
        private String artifactId;
        private String version = "LATEST";
        private String extension = "jar";
        private String classifier;
        private boolean offline;
        private String[] optionalDependencyPatterns = new String[0];
        private String[] excludeDependencyFilterPatterns = new String[0];
        private String mainClass;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Map<String, String> environment = new HashMap<String, String>();
        private String[] jvmOptions = new String[0];
        private Map<String, File> jarFiles = new HashMap<String, File>();
        private Container container;
        private DownloadStrategy downloadStrategy;

        public T id(String id) {
            this.id = id;
            return (T)this;
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T url(URL url) {
            this.url = url;
            return (T)this;
        }

        public T url(String url) throws MalformedURLException {
            this.url = new URL(url);
            return (T)this;
        }

        public T controllerUrl(URL controllerUrl) {
            this.controllerUrl = controllerUrl;
            return (T)this;
        }

        public T controllerUrl(String controllerUrl) throws MalformedURLException {
            this.controllerUrl = new URL(controllerUrl);
            return (T)this;
        }

        public T controllerJson(String controllerJson) {
            this.controllerJson = controllerJson;
            return (T)this;
        }

        public T extractCmd(String extract) {
            this.extractCmd = extract;
            return (T)this;
        }

        public T postUnpackCmds(String[] commands) {
            this.postUnpackCmds = commands;
            return (T)this;
        }

        public T postInstallCmds(String[] commands) {
            this.postInstallCmds = commands;
            return (T)this;
        }

        public T groupId(String groupId) {
            this.groupId = groupId;
            return (T)this;
        }

        public T artifactId(String artifactId) {
            this.artifactId = artifactId;
            return (T)this;
        }

        public T version(String version) {
            if (!Strings.isNullOrEmpty((String)version)) {
                this.version = version;
            }
            return (T)this;
        }

        public T extension(String extension) {
            if (!Strings.isNullOrEmpty((String)extension)) {
                this.extension = extension;
            }
            return (T)this;
        }

        public T classifier(String classifier) {
            this.classifier = classifier;
            return (T)this;
        }

        public T offline(boolean offline) {
            this.offline = offline;
            return (T)this;
        }

        public T optionalDependencyPatterns(String ... optionalDependencyPatterns) {
            this.optionalDependencyPatterns = (String[])Objects.firstNonNull((Object)optionalDependencyPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T excludeDependencyFilterPatterns(String ... excludeDependencyFilterPatterns) {
            this.excludeDependencyFilterPatterns = (String[])Objects.firstNonNull((Object)excludeDependencyFilterPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T mainClass(String mainClass) {
            this.mainClass = mainClass;
            return (T)this;
        }

        public T mainClass(Class mainClass) {
            this.mainClass = mainClass.getName();
            return (T)this;
        }

        public T jarFiles(Map<String, File> jarFiles) {
            this.jarFiles = new HashMap<String, File>(jarFiles);
            return (T)this;
        }

        public T container(Container container) {
            this.container = container;
            if (container != null) {
                this.id(container.getId());
            }
            return (T)this;
        }

        public T downloadStrategy(DownloadStrategy downloadStrategy) {
            this.downloadStrategy = downloadStrategy;
            return (T)this;
        }

        public String getId() {
            return this.id;
        }

        public URL getControllerUrl() {
            return this.controllerUrl;
        }

        public String getControllerJson() {
            return this.controllerJson;
        }

        public String getExtractCmd() {
            return this.extractCmd;
        }

        public String[] getPostUnpackCmds() {
            return this.postUnpackCmds;
        }

        public String[] getPostInstallCmds() {
            return this.postInstallCmds;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public String[] getOptionalDependencyPatterns() {
            return this.optionalDependencyPatterns;
        }

        public String[] getExcludeDependencyFilterPatterns() {
            return this.excludeDependencyFilterPatterns;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public String[] getJvmOptions() {
            return this.jvmOptions;
        }

        public Container getContainer() {
            return this.container;
        }

        public DownloadStrategy getDownloadStrategy() {
            return this.downloadStrategy;
        }

        public InstallOptionsBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public InstallOptionsBuilder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public InstallOptionsBuilder jvmOptions(String ... jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public InstallOptionsBuilder jvmOptionsString(String jvmOptions) {
            this.jvmOptions = jvmOptions.split("\\s+?");
            return this;
        }

        public URL getUrl() throws MalformedURLException {
            if (this.url != null) {
                return this.url;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("mvn:");
            boolean invalid = false;
            if (this.groupId != null) {
                sb.append(this.groupId).append("/");
            } else {
                invalid = true;
            }
            if (this.artifactId != null) {
                sb.append(this.artifactId).append("/");
            } else {
                invalid = true;
            }
            if (this.version != null) {
                sb.append(this.version);
            } else {
                invalid = true;
            }
            if (this.extension != null) {
                sb.append("/").append(this.extension);
            }
            if (this.classifier != null) {
                sb.append("/").append(this.classifier);
            }
            if (invalid) {
                return null;
            }
            return new URL(sb.toString());
        }

        public String getName() {
            if (!Strings.isNullOrEmpty((String)this.name)) {
                return this.name;
            }
            if (!(Strings.isNullOrEmpty((String)this.groupId) || Strings.isNullOrEmpty((String)this.artifactId) || Strings.isNullOrEmpty((String)this.version))) {
                return this.groupId + ":" + this.artifactId + ":" + this.version;
            }
            return null;
        }

        public InstallOptions build() throws MalformedURLException {
            return new InstallOptions(this.id, this.getName(), this.getUrl(), this.controllerUrl, this.controllerJson, this.extractCmd, this.postUnpackCmds, this.postInstallCmds, this.offline, this.optionalDependencyPatterns, this.excludeDependencyFilterPatterns, this.mainClass, this.properties, this.environment, this.jvmOptions, this.jarFiles, this.container, this.downloadStrategy);
        }

        public Map<String, File> getJarFiles() {
            return this.jarFiles;
        }
    }
}

